/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi;

import javax.sound.midi.InvalidMidiDataException;
import net.thecodersbreakfast.lp4j.api.BackBufferOperation;
import net.thecodersbreakfast.lp4j.api.Brightness;
import net.thecodersbreakfast.lp4j.api.Buffer;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Color;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LaunchpadException;
import net.thecodersbreakfast.lp4j.api.LightIntensity;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.api.ScrollSpeed;
import net.thecodersbreakfast.lp4j.midi.protocol.MidiProtocolClient;

public class MidiLaunchpadClient
implements LaunchpadClient {
    private final MidiProtocolClient midiProtocolClient;

    public MidiLaunchpadClient(MidiProtocolClient midiProtocolClient) {
        if (midiProtocolClient == null) {
            throw new IllegalArgumentException("MidiClient must not be null.");
        }
        this.midiProtocolClient = midiProtocolClient;
    }

    @Override
    public void reset() {
        try {
            this.midiProtocolClient.reset();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void testLights(LightIntensity lightIntensity) {
        if (lightIntensity == null) {
            throw new IllegalArgumentException("Light intensity must not be null.");
        }
        int n = switch (lightIntensity) {
            case LightIntensity.LOW -> 125;
            case LightIntensity.MEDIUM -> 126;
            case LightIntensity.HIGH -> 127;
            default -> throw new IllegalArgumentException("Unknown intensity value : " + lightIntensity.name());
        };
        try {
            this.midiProtocolClient.lightsOn(n);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void setLights(Color[] colorArray, BackBufferOperation backBufferOperation) {
        if (colorArray == null) {
            throw new IllegalArgumentException("Colors must not be null");
        }
        int n = colorArray.length;
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("The number of colors for a batch update must be even.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.toRawColor(colorArray[n2], backBufferOperation);
            ++n2;
        }
        try {
            this.midiProtocolClient.notesOn(nArray);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void setPadLight(Pad pad, Color color, BackBufferOperation backBufferOperation) {
        if (pad == null) {
            throw new IllegalArgumentException("Pad must not be null.");
        }
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
        int n = this.toRawCoords(pad.getX(), pad.getY());
        byte by = this.toRawColor(color, backBufferOperation);
        try {
            this.midiProtocolClient.noteOn(n, by);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void setButtonLight(Button button, Color color, BackBufferOperation backBufferOperation) {
        if (button == null) {
            throw new IllegalArgumentException("Button must not be null.");
        }
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
        try {
            byte by = this.toRawColor(color, backBufferOperation);
            if (button.isTopButton()) {
                int n = 104 + button.getCoordinate();
                this.midiProtocolClient.buttonOn(n, by);
            } else {
                int n = this.toRawCoords(8, button.getCoordinate());
                this.midiProtocolClient.noteOn(n, by);
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void setBrightness(Brightness brightness) {
        if (brightness == null) {
            throw new IllegalArgumentException("Brightness must not be null");
        }
        int n = brightness.getBrightness();
        try {
            this.midiProtocolClient.brightness(1, 18 - n);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    @Override
    public void setBuffers(Buffer buffer, Buffer buffer2, boolean bl, boolean bl2) {
        if (buffer == null) {
            throw new IllegalArgumentException("Visible buffer must not be null.");
        }
        if (buffer2 == null) {
            throw new IllegalArgumentException("Write buffer must not be null.");
        }
        try {
            this.midiProtocolClient.doubleBufferMode(this.getBufferValue(buffer), this.getBufferValue(buffer2), bl, bl2);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    private int getBufferValue(Buffer buffer) {
        return buffer == Buffer.BUFFER_0 ? 0 : 1;
    }

    @Override
    public void scrollText(String string, Color color, ScrollSpeed scrollSpeed, boolean bl, BackBufferOperation backBufferOperation) {
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
        if (scrollSpeed == null) {
            throw new IllegalArgumentException("Speed must not be null.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("Operation must not be null.");
        }
        byte by = this.toRawColor(color, backBufferOperation);
        try {
            this.midiProtocolClient.text(string, by, scrollSpeed.getScrollSpeed(), bl);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new LaunchpadException(invalidMidiDataException);
        }
    }

    private byte toRawColor(Color color, BackBufferOperation backBufferOperation) {
        int n = 0;
        switch (backBufferOperation) {
            case NONE: {
                n = 0;
                break;
            }
            case CLEAR: {
                n = 8;
                break;
            }
            case COPY: {
                n = 12;
            }
        }
        return (byte)(n + color.getRed() + 16 * color.getGreen());
    }

    private int toRawCoords(int n, int n2) {
        return n + 16 * n2;
    }
}

