/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi.protocol;

import java.nio.charset.Charset;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import net.thecodersbreakfast.lp4j.api.LaunchpadException;
import net.thecodersbreakfast.lp4j.midi.protocol.MidiProtocolClient;

public class DefaultMidiProtocolClient
implements MidiProtocolClient {
    private final Receiver receiver;

    public DefaultMidiProtocolClient(Receiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("Receiver must not be null.");
        }
        this.receiver = receiver;
    }

    @Override
    public void reset() throws InvalidMidiDataException {
        this.sendShortMessage(176, 0, 0);
    }

    @Override
    public void lightsOn(int n) throws InvalidMidiDataException {
        this.sendShortMessage(176, 0, n);
    }

    @Override
    public void noteOn(int n, int n2) throws InvalidMidiDataException {
        this.sendShortMessage(144, n, n2);
    }

    @Override
    public void noteOff(int n) throws InvalidMidiDataException {
        this.sendShortMessage(128, n, 0);
    }

    @Override
    public void notesOn(int ... nArray) throws InvalidMidiDataException {
        if (nArray == null) {
            throw new IllegalArgumentException("Colors should not be null.");
        }
        int n = nArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            this.sendShortMessage(144, 3, nArray[n2 * 2], nArray[n2 * 2 + 1]);
            ++n2;
        }
    }

    @Override
    public void layout(int n) throws InvalidMidiDataException {
        this.sendShortMessage(176, 0, n);
    }

    @Override
    public void buttonOn(int n, int n2) throws InvalidMidiDataException {
        this.sendShortMessage(176, n, n2);
    }

    @Override
    public void brightness(int n, int n2) throws InvalidMidiDataException {
        if (n < 9) {
            this.sendShortMessage(176, 30, 16 * (n - 1) + (n2 - 3));
        } else {
            this.sendShortMessage(176, 31, 16 * (n - 9) + (n2 - 3));
        }
    }

    @Override
    public void text(String string, int n, int n2, boolean bl) throws InvalidMidiDataException {
        if (bl) {
            n += 64;
        }
        byte[] byArray = new byte[6];
        byArray[0] = -16;
        byArray[2] = 32;
        byArray[3] = 41;
        byArray[4] = 9;
        byArray[5] = (byte)n;
        byte[] byArray2 = byArray;
        byte[] byArray3 = string == null ? new byte[]{} : string.getBytes(Charset.forName("ASCII"));
        byte[] byArray4 = new byte[byArray3.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        byArray4[byArray2.length] = (byte)n2;
        System.arraycopy(byArray3, 0, byArray4, byArray2.length + 1, byArray3.length);
        byArray4[byArray4.length - 1] = -9;
        this.sendSysExMessage(byArray4);
    }

    @Override
    public void doubleBufferMode(int n, int n2, boolean bl, boolean bl2) throws InvalidMidiDataException {
        int n3 = 32 + 4 * n2 + n;
        if (bl) {
            n3 |= 0x10;
        }
        if (bl2) {
            n3 |= 8;
        }
        this.sendShortMessage(176, 0, n3);
    }

    private void sendShortMessage(int n, int n2, int n3) throws LaunchpadException, InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(n, n2, n3);
        this.send(shortMessage);
    }

    private void sendShortMessage(int n, int n2, int n3, int n4) throws LaunchpadException, InvalidMidiDataException {
        ShortMessage shortMessage = new ShortMessage();
        shortMessage.setMessage(n, n2, n3, n4);
        this.send(shortMessage);
    }

    private void sendSysExMessage(byte[] byArray) throws InvalidMidiDataException {
        SysexMessage sysexMessage = new SysexMessage();
        sysexMessage.setMessage(byArray, byArray.length);
        this.send(sysexMessage);
    }

    private void send(MidiMessage midiMessage) {
        this.receiver.send(midiMessage, -1L);
    }
}

