/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi.protocol;

import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.LaunchpadListener;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.midi.protocol.MidiProtocolListener;

public class DefaultMidiProtocolListener
implements MidiProtocolListener {
    private final LaunchpadListener listener;

    public DefaultMidiProtocolListener(LaunchpadListener launchpadListener) {
        this.listener = launchpadListener;
    }

    @Override
    public void onNoteOn(int n, long l) {
        if (this.listener == null) {
            return;
        }
        int n2 = n % 16;
        int n3 = n / 16;
        if (n2 >= 8) {
            Button button = Button.atRight(n3);
            this.listener.onButtonPressed(button, l);
        } else {
            if (n2 < 0 || n3 < 0 || n3 > 7) {
                throw new IllegalArgumentException("Invalid pad coordinates : (" + n2 + "," + n3 + "). Acceptable values on either axis are in range [0..7].");
            }
            this.listener.onPadPressed(Pad.at(n2, n3), l);
        }
    }

    @Override
    public void onNoteOff(int n, long l) {
        if (this.listener == null) {
            return;
        }
        int n2 = n % 16;
        int n3 = n / 16;
        if (n2 >= 8) {
            Button button = Button.atRight(n3);
            this.listener.onButtonReleased(button, l);
        } else {
            if (n2 < 0 || n3 < 0 || n3 > 7) {
                throw new IllegalArgumentException("Invalid pad coordinates : (" + n2 + "," + n3 + "). Acceptable values on either axis are in range [0..7].");
            }
            this.listener.onPadReleased(Pad.at(n2, n3), l);
        }
    }

    @Override
    public void onButtonOn(int n, long l) {
        if (this.listener == null) {
            return;
        }
        int n2 = n - 104;
        Button button = Button.atTop(n2);
        this.listener.onButtonPressed(button, l);
    }

    @Override
    public void onButtonOff(int n, long l) {
        if (this.listener == null) {
            return;
        }
        int n2 = n - 104;
        Button button = Button.atTop(n2);
        this.listener.onButtonReleased(button, l);
    }

    @Override
    public void onTextScrolled(long l) {
        this.listener.onTextScrolled(l);
    }
}

