/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.markdown.markdownSyntactic;

import gama.experimental.markdown.markdownSyntactic.IParser;
import gama.experimental.markdown.markdownSyntactic.LightModel;
import gama.experimental.markdown.markdownSyntactic.MarkdownTools;
import gama.experimental.markdown.visitors.VisitorExperiments;
import gama.experimental.markdown.visitors.VisitorModel;
import gama.experimental.markdown.visitors.VisitorSpecies;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.ui.navigator.view.contents.WrappedGamaFile;
import gaml.compiler.gaml.indexer.GamlResourceIndexer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class MarkdownModelDocumentor {
    StringBuilder mDText;
    String pathToSave;
    WrappedGamaFile modelFile;
    ISyntacticElement modelElement;
    ArrayList<ISyntacticElement> species = new ArrayList();
    ArrayList<ISyntacticElement> experiments = new ArrayList();
    VisitorSpecies visitorSpecies;
    VisitorExperiments visitorExperiments;
    VisitorModel visitorModel;
    Map<String, String> speciesLink = new HashMap<String, String>();
    Map<String, String> experimentsLink = new HashMap<String, String>();
    ISyntacticElement.SyntacticVisitor visitorSpeciesForIndex = iSyntacticElement -> {
        if (iSyntacticElement.isSpecies()) {
            this.mDText.append(MarkdownTools.goBeginLine());
            this.speciesLink.put(iSyntacticElement.getName(), "#" + iSyntacticElement.getKeyword() + "-" + iSyntacticElement.getName());
            this.mDText.append(IParser.MARKDOWN_KEYWORD_LIST + IParser.MARKDOWN_KEYWORD_SPACE + MarkdownTools.addLink(iSyntacticElement.getName(), "#" + iSyntacticElement.getKeyword() + "-" + iSyntacticElement.getName()) + IParser.MARKDOWN_KEYWORD_SPACE + "(" + iSyntacticElement.getKeyword() + ")");
        }
    };
    ISyntacticElement.SyntacticVisitor visitorExperimentsForIndex = iSyntacticElement -> {
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(IParser.MARKDOWN_KEYWORD_LIST + IParser.MARKDOWN_KEYWORD_SPACE + MarkdownTools.addLink(iSyntacticElement.getName(), "#" + iSyntacticElement.getKeyword() + "-" + iSyntacticElement.getName() + "-" + String.valueOf(iSyntacticElement.getExpressionAt(IParser.GAMA_KEYWORD_TYPE)) + "-"));
        this.experimentsLink.put(iSyntacticElement.getName(), "#" + iSyntacticElement.getKeyword() + "-" + iSyntacticElement.getName() + "-" + String.valueOf(iSyntacticElement.getExpressionAt(IParser.GAMA_KEYWORD_TYPE)) + "-");
        if (iSyntacticElement.hasFacet(IParser.GAMA_KEYWORD_TYPE)) {
            this.mDText.append(IParser.MARKDOWN_KEYWORD_SPACE + "(" + String.valueOf(iSyntacticElement.getExpressionAt(IParser.GAMA_KEYWORD_TYPE)) + ")");
        }
    };
    ISyntacticElement.SyntacticVisitor visitorForLoading;

    public MarkdownModelDocumentor(WrappedGamaFile wrappedGamaFile, String string) {
        this.modelFile = wrappedGamaFile;
        this.modelElement = GAML.getContents((URI)URI.createURI((String)((IFile)wrappedGamaFile.getResource()).getLocationURI().toString()));
        this.mDText = new StringBuilder();
        this.visitorForLoading = iSyntacticElement -> {
            if (iSyntacticElement.isSpecies() || iSyntacticElement.getKeyword().equals(IParser.GAMA_KEYWORD_GRID)) {
                this.species.add(iSyntacticElement);
                iSyntacticElement.visitSpecies(this.visitorForLoading);
            }
            if (iSyntacticElement.isExperiment()) {
                this.experiments.add(iSyntacticElement);
            }
        };
        this.loadImports();
        this.loadSpeciesAndExperiments();
        this.visitorModel = new VisitorModel(this.speciesLink, this.experimentsLink);
        this.visitorSpecies = new VisitorSpecies(this.speciesLink, this.experimentsLink);
        this.visitorExperiments = new VisitorExperiments(this.speciesLink, this.experimentsLink);
        this.pathToSave = string;
    }

    public void loadImports() {
        IPath iPath = ((IFile)this.modelFile.getResource()).getRawLocation();
        Map map = GamlResourceIndexer.allImportsOf((URI)URI.createURI((String)((IFile)this.modelFile.getResource()).getRawLocationURI().toString()));
        for (URI uRI : map.keySet()) {
            Object object;
            LightModel lightModel = new LightModel(uRI);
            Path path = new Path(uRI.toFileString().replace("file:", ""));
            IPath iPath2 = path.makeRelativeTo(iPath);
            for (String string : lightModel.speciesLink.keySet()) {
                object = lightModel.speciesLink.get(string);
                object = FilenameUtils.removeExtension((String)iPath2.toString().replaceFirst(".." + File.separator, "")) + ".md#" + (String)object;
                this.speciesLink.put(string, (String)object);
            }
            for (String string : lightModel.experimentsLink.keySet()) {
                object = lightModel.experimentsLink.get(string);
                object = FilenameUtils.removeExtension((String)iPath2.toString().replaceFirst(".." + File.separator, "")) + ".md#" + (String)object;
                this.speciesLink.put(string, (String)object);
            }
            lightModel.dispose();
            lightModel = null;
        }
        map = null;
    }

    public void generateMarkdown() {
        this.mDText.append(MarkdownTools.addHeader("File " + this.modelFile.getName()));
        this.generateIndex();
        this.generateSpecies();
        this.generateExperiments();
    }

    public void saveMarkdown() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter fileWriter = new FileWriter(this.pathToSave);){
                File file = new File(this.pathToSave);
                file.getParentFile().mkdirs();
                fileWriter.write(this.mDText.toString());
                fileWriter.flush();
                this.dispose();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void dispose() {
        this.speciesLink = null;
        this.experimentsLink = null;
        this.modelElement.dispose();
        this.modelFile = null;
        this.modelElement = null;
        this.species = null;
        this.experiments = null;
        this.visitorModel.dispose();
        this.visitorSpecies.dispose();
        this.visitorExperiments.dispose();
        this.visitorModel = null;
        this.visitorSpecies = null;
        this.visitorExperiments = null;
        this.mDText = null;
    }

    public void generateSpecies() {
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addLine());
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addSubHeader(IParser.MARKDOWN_LABEL_SPECIES));
        this.visitorModel.setText(this.mDText);
        this.visitorModel.visit(this.modelElement);
        this.mDText = this.visitorModel.getText();
        this.visitorSpecies.setText(this.mDText);
        for (ISyntacticElement iSyntacticElement : this.species) {
            this.visitorSpecies.visit(iSyntacticElement);
        }
        this.mDText = this.visitorSpecies.getText();
    }

    public void generateExperiments() {
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addLine());
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addSubHeader(IParser.MARKDOWN_LABEL_EXPERIMENTS));
        this.visitorExperiments.setText(this.mDText);
        this.modelElement.visitExperiments((ISyntacticElement.SyntacticVisitor)this.visitorExperiments);
        this.mDText = this.visitorExperiments.getText();
    }

    public void generateIndex() {
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addLine());
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addSubHeader(IParser.MARKDOWN_LABEL_INDEX));
        this.mDText.append(MarkdownTools.addSubSubHeader(IParser.MARKDOWN_LABEL_SPECIES + " (" + this.species.size() + ")"));
        this.species.sort((iSyntacticElement, iSyntacticElement2) -> iSyntacticElement.getName().compareTo(iSyntacticElement2.getName()));
        for (ISyntacticElement iSyntacticElement3 : this.species) {
            this.visitorSpeciesForIndex.visit(iSyntacticElement3);
        }
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.goBeginLine());
        this.mDText.append(MarkdownTools.addSubSubHeader(IParser.MARKDOWN_LABEL_EXPERIMENTS + " (" + this.experiments.size() + ")"));
        this.experiments.sort((iSyntacticElement, iSyntacticElement2) -> iSyntacticElement.getName().compareTo(iSyntacticElement2.getName()));
        for (ISyntacticElement iSyntacticElement3 : this.experiments) {
            this.visitorExperimentsForIndex.visit(iSyntacticElement3);
        }
    }

    public void loadSpeciesAndExperiments() {
        this.modelElement.visitSpecies(this.visitorForLoading);
        this.modelElement.visitGrids(this.visitorForLoading);
        this.modelElement.visitExperiments(this.visitorForLoading);
    }
}

