/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.markdown.visitors;

import gama.experimental.markdown.markdownSyntactic.IParser;
import gama.experimental.markdown.markdownSyntactic.MarkdownTools;
import gama.experimental.markdown.visitors.VisitorActions;
import gama.experimental.markdown.visitors.VisitorAspects;
import gama.experimental.markdown.visitors.VisitorAttributes;
import gama.experimental.markdown.visitors.VisitorDebug;
import gama.experimental.markdown.visitors.VisitorFacets;
import gama.experimental.markdown.visitors.VisitorMicroSpecies;
import gama.experimental.markdown.visitors.VisitorReflexes;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.descriptions.IDescription;
import java.util.Map;

public class VisitorSpecies
implements ISyntacticElement.SyntacticVisitor {
    StringBuilder mDText = new StringBuilder();
    VisitorFacets visitorFacets;
    VisitorMicroSpecies visitorMicroSpecies;
    VisitorAttributes visitorAttributes;
    VisitorActions visitorActions;
    VisitorReflexes visitorReflexes;
    VisitorAspects visitorAspects;
    Map<String, String> speciesLink;
    Map<String, String> experimentsLink;

    public VisitorSpecies(Map<String, String> map, Map<String, String> map2) {
        this.speciesLink = map;
        this.experimentsLink = map2;
        this.visitorFacets = new VisitorFacets(map, map2);
        this.visitorMicroSpecies = new VisitorMicroSpecies();
        this.visitorAttributes = new VisitorAttributes(map, map2);
        this.visitorActions = new VisitorActions(map, map2);
        this.visitorReflexes = new VisitorReflexes();
        this.visitorAspects = new VisitorAspects();
    }

    public void setText(StringBuilder stringBuilder) {
        this.mDText = stringBuilder;
    }

    public StringBuilder getText() {
        return this.mDText;
    }

    public void dispose() {
        this.mDText = null;
        this.visitorFacets.dispose();
        this.visitorMicroSpecies.dispose();
        this.visitorAttributes.dispose();
        this.visitorActions.dispose();
        this.visitorReflexes.dispose();
        this.visitorAspects.dispose();
        this.visitorFacets = null;
        this.visitorMicroSpecies = null;
        this.visitorAttributes = null;
        this.visitorActions = null;
        this.visitorReflexes = null;
        this.visitorAspects = null;
        this.experimentsLink = null;
        this.speciesLink = null;
    }

    public void visit(ISyntacticElement iSyntacticElement) {
        if (iSyntacticElement.isSpecies()) {
            VisitorDebug.DEBUG("  doing species " + iSyntacticElement.getName());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            if (iSyntacticElement.getKeyword().equals(IParser.GAMA_KEYWORD_GRID)) {
                this.mDText.append(MarkdownTools.addSubSubHeader(IParser.MARKDOWN_LABEL_GRID + IParser.MARKDOWN_KEYWORD_SPACE + iSyntacticElement.getName()));
            } else {
                this.mDText.append(MarkdownTools.addSubSubHeader(IParser.MARKDOWN_LABEL_SPECIES + IParser.MARKDOWN_KEYWORD_SPACE + iSyntacticElement.getName()));
            }
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addQuote(MarkdownTools.getCommentsFromElement(iSyntacticElement.getElement())));
            this.visitorFacets.setText(this.mDText);
            iSyntacticElement.visitFacets((IDescription.IFacetVisitor)this.visitorFacets);
            this.mDText = this.visitorFacets.getText();
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_MICROSPECIES));
            this.visitorMicroSpecies.setText(this.mDText);
            iSyntacticElement.visitAllChildren((ISyntacticElement.SyntacticVisitor)this.visitorMicroSpecies);
            this.mDText = this.visitorMicroSpecies.getText();
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_ATTRIBUTES));
            this.visitorAttributes.setText(this.mDText);
            this.visitorAttributes.first = true;
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorAttributes);
            this.mDText = this.visitorAttributes.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_ACTIONS));
            this.visitorActions.setText(this.mDText);
            this.visitorActions.first = true;
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorActions);
            this.mDText = this.visitorActions.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_REFLEXES));
            this.visitorReflexes.setText(this.mDText);
            this.visitorReflexes.first = true;
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorReflexes);
            this.mDText = this.visitorReflexes.getText();
            this.mDText.append(MarkdownTools.endTable());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.goBeginLine());
            this.mDText.append(MarkdownTools.addSubSubSubHeader(IParser.MARKDOWN_LABEL_ASPECTS));
            this.visitorAspects.setText(this.mDText);
            iSyntacticElement.visitChildren((ISyntacticElement.SyntacticVisitor)this.visitorAspects);
            this.mDText = this.visitorAspects.getText();
        }
    }
}

