/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.netcdf.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;

public abstract class Dataset_EVOL {
    static int nx;
    static int ny;
    static int nz;
    static int ipo;
    static int jpo;
    static int nbTimeRecords;
    static NetcdfFile ncIn;
    public static double[][] lonRho;
    public static double[][] latRho;
    static double[][] hRho;
    static byte[][] maskRho;
    static byte[][] masku;
    static byte[][] maskv;
    static float[][] zeta_tp0;
    static float[][] zeta_tp1;
    static float[][][] u_tp0;
    static float[][][] u_tp1;
    static float[][][] v_tp0;
    static float[][][] v_tp1;
    static float[][][] w_tp0;
    static float[][][] w_tp1;
    static float[][] hbl_tp0;
    static float[][] hbl_tp1;
    private static float[][][] salt_tp1;
    private static float[][][] salt_tp0;
    private static float[][][] temp_tp0;
    private static float[][][] temp_tp1;
    private static float[][][] Diatoms_tp0;
    private static float[][][] NanoPhyto_tp0;
    private static float[][][] MicroZoo_tp0;
    private static float[][][] MesoZoo_tp0;
    private static float[][][] O2_tp0;
    private static float[][][] Diatoms_tp1;
    private static float[][][] NanoPhyto_tp1;
    private static float[][][] MicroZoo_tp1;
    private static float[][][] MesoZoo_tp1;
    private static float[][][] O2_tp1;
    private static float[][] Diatoms_integ_tp0;
    private static float[][] NanoPhyto_integ_tp0;
    private static float[][] MicroZoo_integ_tp0;
    private static float[][] MesoZoo_integ_tp0;
    private static float[][] Diatoms_integ_tp1;
    private static float[][] NanoPhyto_integ_tp1;
    private static float[][] MicroZoo_integ_tp1;
    private static float[][] MesoZoo_integ_tp1;
    private static float[][][] Phyto_tp0;
    private static float[][][] Zoo_tp0;
    private static float[][][] Det_tp0;
    private static float[][][] NO3_tp0;
    private static float[][][] Chla_tp0;
    private static float[][][] Phyto_tp1;
    private static float[][][] Zoo_tp1;
    private static float[][][] Det_tp1;
    private static float[][][] NO3_tp1;
    private static float[][][] Chla_tp1;
    private static float[][][] NanoPhytoChl_tp0;
    private static float[][][] DiatomsChl_tp0;
    private static float[][][] NanoPhytoChl_tp1;
    private static float[][][] DiatomsChl_tp1;
    private static float[][][] kv_tp1;
    private static float[][][] kv_tp0;
    static double[][][] z_rho_cst;
    static double[][][] z_w_tp0;
    static double[][][] z_w_tp1;
    static double[][][] z_w_cst;
    private static double latMin;
    private static double lonMin;
    private static double latMax;
    private static double lonMax;
    private static double depthMax;
    public static int dt_HyMo;
    private static ArrayList<String> listInputFiles;
    private static int indexFile;
    static double time_tp1;
    private int rank;
    private static int time_arrow;
    static String strXiDim;
    static String strEtaDim;
    static String strZDim;
    static String strTimeDim;
    static String strU;
    static String strV;
    static String strW;
    static String strOmega;
    static String strHBL;
    static String strTp;
    static String strSal;
    static String strTime;
    static String strZeta;
    static String strLon;
    static String strLat;
    static String strMask_rho;
    static String strBathy;
    static String strKv;
    static String strDiatoms;
    static String strNanoPhyto;
    static String strMicroZoo;
    static String strMesoZoo;
    static String strO2;
    static String strDiatomsChl;
    static String strNanoPhytoChl;
    static String strPhytot;
    static String strZootot;
    static String strDiatoms_int;
    static String strNanoPhyto_int;
    static String strMicroZoo_int;
    static String strMesoZoo_int;
    static String strGoc_int;
    static String strPoc_int;
    static String strPhyto;
    static String strZoo;
    static String strDet;
    static String strNO3;
    static String strCHLA;
    private static boolean FLAG_TP;
    private static boolean FLAG_W;
    private static boolean FLAG_SAL;
    private static boolean FLAG_VDISP;
    private static boolean FLAG_HBL;
    private static boolean FLAG_PLANKTON_PISCES;
    private static boolean FLAG_PLANKTON_NPZD;
    private static boolean FLAG_PLANKTON_PISCES_tot;
    public static String directory_roms;
    public static String sufixe;
    public static String directory_Suplementary_data;
    public static String oxyclin_filename;
    public static String PonteOBS_filename;
    public static String PonteCLM_filename;
    static double[][] pm;
    static double[][] pn;
    String strThetaS;
    String strThetaB;
    String strHc;
    String strPn;
    String strPm;
    public static int[] yearlist100;
    static String filtre_roms_output;
    static int[] prof_potentielles;
    static double prof_ponte_min;
    static double prof_ponte_max;
    public static double lat_min;
    public static double lat_max;
    public static double lon_min;
    public static double lon_max;
    static int prof_talu;
    static int SIMU;
    static int sponge_km;
    public static int bathy_max;
    public static String region;
    public static String main_output_directory;
    public static String Clim_chlaSeaWiFS;

    public void setUp() throws IOException {
        this.getFieldsName();
        this.openLocation(directory_roms);
        this.getDimNC();
        this.readConstantField();
        this.getDimGeogArea();
        this.getCstSigLevels();
        z_w_tp0 = Dataset_EVOL.getSigLevels();
    }

    abstract void getFieldsName();

    static String get_filename(int n, int n2) {
        String string = directory_roms + region + "_Y" + n + "M" + n2 + sufixe;
        return string;
    }

    private void getDimNC() throws IOException {
        try {
            nx = ncIn.findDimension(strXiDim).getLength();
            ny = ncIn.findDimension(strEtaDim).getLength();
            nz = ncIn.findDimension(strZDim).getLength();
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Problem reading dimensions from dataset " + ncIn.getLocation() + " : " + nullPointerException.getMessage());
        }
        System.out.println("nx = " + nx);
        System.out.println("ny = " + ny);
        System.out.println("nz = " + nz);
        jpo = 0;
        ipo = 0;
    }

    double getdxi(int n, int n2) {
        return pm[n][n2] != 0.0 ? 1.0 / pm[n][n2] : 0.0;
    }

    double getdeta(int n, int n2) {
        return pn[n][n2] != 0.0 ? 1.0 / pn[n][n2] : 0.0;
    }

    private double diff2(double[] dArray, int n) {
        int n2 = dArray.length;
        if (n2 < 3) {
            return Double.NaN;
        }
        if (n == 0 || n == n2 - 1) {
            return 0.0;
        }
        return dArray[n + 1] - 2.0 * dArray[n] + dArray[n - 1];
    }

    static double[][][] getSigLevels() {
        double[][][] dArray = new double[nz + 1][ny][nx];
        double[][][] dArray2 = z_w_cst;
        int n = nx;
        while (n-- > 0) {
            int n2 = ny;
            while (n2-- > 0) {
                if (zeta_tp1[n2][n] == 999.0f) {
                    Dataset_EVOL.zeta_tp1[n2][n] = 0.0f;
                }
                int n3 = 0;
                while (n3 < nz + 1) {
                    dArray[n3][n2][n] = dArray2[n3][n2][n] + (double)zeta_tp1[n2][n] * (1.0 + dArray2[n3][n2][n] / hRho[n2][n]);
                    ++n3;
                }
            }
        }
        dArray2 = null;
        return dArray;
    }

    private void getDimGeogArea() {
        double d;
        lonMin = Double.MAX_VALUE;
        lonMax = -lonMin;
        latMin = Double.MAX_VALUE;
        latMax = -latMin;
        depthMax = 0.0;
        int n = nx;
        int n2 = 0;
        while (n-- > 0) {
            n2 = ny;
            while (n2-- > 0) {
                if (lonRho[n2][n] >= lonMax) {
                    lonMax = lonRho[n2][n];
                }
                if (lonRho[n2][n] <= lonMin) {
                    lonMin = lonRho[n2][n];
                }
                if (latRho[n2][n] >= latMax) {
                    latMax = latRho[n2][n];
                }
                if (latRho[n2][n] <= latMin) {
                    latMin = latRho[n2][n];
                }
                if (!(hRho[n2][n] >= depthMax)) continue;
                depthMax = hRho[n2][n];
            }
        }
        if (lonMin > lonMax) {
            d = lonMin;
            lonMin = lonMax;
            lonMax = d;
        }
        if (latMin > latMax) {
            d = latMin;
            latMin = latMax;
            latMax = d;
        }
    }

    public void init() throws IOException {
        System.out.println("initialisation... ");
        time_arrow = 1;
        String string = Dataset_EVOL.get_filename(1980, 1);
        Dataset_EVOL.open(string);
        nbTimeRecords = ncIn.findDimension(strTimeDim).getLength();
        System.out.println("Number of records per month in the ROMS outputs file : " + nbTimeRecords + " (updated each month)");
        if (nbTimeRecords > 1) {
            this.get_dt_HyMo();
        } else {
            dt_HyMo = 30;
            System.out.println("Time step in DAYS between two records in NetCDF dataset : dt_HyMo = " + dt_HyMo);
        }
        FLAG_W = false;
        if (ncIn.findVariable(strW) == null) {
            System.out.println(" ATENTION !!! Il n'y a pas " + strW + " dans les sorties, il sera donc recalcul\u00e9!!! ");
            System.out.println(" 16 avril 2014 : On neglige l'advection verticale --> on ne recalcule plus W ");
        } else {
            System.out.println("**--> La vitesse verticale  " + strW + " POURRAIT ETRE lue dans les sorties (mais elle est recalcul\u00e9e pour l'instant) <--**");
            FLAG_W = true;
        }
        FLAG_SAL = false;
        if (ncIn.findVariable(strSal) == null) {
            throw new IOException("Salinity field " + strSal + " not found in file " + ncIn.getLocation());
        }
        FLAG_SAL = true;
        FLAG_TP = false;
        if (ncIn.findVariable(strTp) == null) {
            throw new IOException("Temperature field " + strTp + " not found in file " + ncIn.getLocation());
        }
        FLAG_TP = true;
        FLAG_HBL = false;
        if (ncIn.findVariable(strHBL) == null) {
            System.out.println("Field " + strHBL + " not found in file " + ncIn.getLocation());
        } else {
            FLAG_HBL = true;
        }
        FLAG_VDISP = false;
        FLAG_PLANKTON_NPZD = false;
        FLAG_PLANKTON_PISCES_tot = true;
        FLAG_PLANKTON_PISCES = false;
        this.rank = 0;
        Dataset_EVOL.setAllFieldsTp1AtTime(0);
    }

    private void get_dt_HyMo() {
        try {
            Array array = ncIn.findVariable(strTime).read();
            time_tp1 = array.getFloat(array.getIndex().set(1));
            double d = array.getFloat(array.getIndex().set(0));
            dt_HyMo = (int)Math.round(Math.abs(time_tp1 - d) / 3600.0 / 24.0);
            System.out.println("Time step in DAYS between two records in NetCDF dataset : dt_HyMo = " + dt_HyMo);
        }
        catch (IOException iOException) {
            System.out.println("Problem extracting dt_HyMo : " + iOException.getMessage());
        }
    }

    public static void setAllFieldsAtTime() throws IOException {
        u_tp0 = u_tp1;
        v_tp0 = v_tp1;
        w_tp0 = w_tp1;
        zeta_tp0 = zeta_tp1;
        temp_tp0 = temp_tp1;
        salt_tp0 = salt_tp1;
        hbl_tp0 = hbl_tp1;
        kv_tp0 = kv_tp1;
        Diatoms_tp0 = Diatoms_tp1;
        NanoPhyto_tp0 = NanoPhyto_tp1;
        MicroZoo_tp0 = MicroZoo_tp1;
        MesoZoo_tp0 = MesoZoo_tp1;
        O2_tp0 = O2_tp1;
        Diatoms_integ_tp0 = Diatoms_integ_tp1;
        NanoPhyto_integ_tp0 = NanoPhyto_integ_tp1;
        MicroZoo_integ_tp0 = MicroZoo_integ_tp1;
        MesoZoo_integ_tp0 = MesoZoo_integ_tp1;
        Phyto_tp0 = Phyto_tp1;
        Zoo_tp0 = Zoo_tp1;
        Det_tp0 = Det_tp1;
        NO3_tp0 = NO3_tp1;
        Chla_tp0 = Chla_tp1;
        NanoPhytoChl_tp0 = NanoPhytoChl_tp1;
        DiatomsChl_tp0 = DiatomsChl_tp1;
        if (z_w_tp1 != null) {
            z_w_tp0 = z_w_tp1;
        }
    }

    static void setAllFieldsTp1AtTime(int n) throws IOException {
        int[] nArray = new int[4];
        nArray[0] = n;
        nArray[2] = jpo;
        nArray[3] = ipo;
        int[] nArray2 = nArray;
        try {
            u_tp1 = (float[][][])ncIn.findVariable(strU).read(nArray2, new int[]{1, nz, ny, nx - 1}).reduce().copyToNDJavaArray();
            v_tp1 = (float[][][])ncIn.findVariable(strV).read(nArray2, new int[]{1, nz, ny - 1, nx}).reduce().copyToNDJavaArray();
            FLAG_W = false;
            if (FLAG_W) {
                w_tp1 = (float[][][])ncIn.findVariable(strW).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            Array array = ncIn.findVariable(strTime).read();
            time_tp1 = array.getFloat(array.getIndex().set(n));
            array = null;
            int[] nArray3 = new int[3];
            nArray3[0] = n;
            zeta_tp1 = (float[][])ncIn.findVariable(strZeta).read(nArray3, new int[]{1, ny, nx}).reduce().copyToNDJavaArray();
            if (FLAG_TP) {
                temp_tp1 = (float[][][])ncIn.findVariable(strTp).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            if (FLAG_SAL) {
                salt_tp1 = (float[][][])ncIn.findVariable(strSal).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            if (FLAG_VDISP) {
                kv_tp1 = (float[][][])ncIn.findVariable(strKv).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            if (FLAG_PLANKTON_PISCES) {
                Diatoms_tp1 = (float[][][])ncIn.findVariable(strDiatoms).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                NanoPhyto_tp1 = (float[][][])ncIn.findVariable(strNanoPhyto).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                MicroZoo_tp1 = (float[][][])ncIn.findVariable(strMicroZoo).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                MesoZoo_tp1 = (float[][][])ncIn.findVariable(strMesoZoo).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            if (FLAG_PLANKTON_PISCES_tot) {
                Phyto_tp1 = (float[][][])ncIn.findVariable(strPhytot).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                Zoo_tp1 = (float[][][])ncIn.findVariable(strZootot).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
            if (FLAG_PLANKTON_NPZD) {
                Phyto_tp1 = (float[][][])ncIn.findVariable(strPhyto).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                Zoo_tp1 = (float[][][])ncIn.findVariable(strZoo).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                Det_tp1 = (float[][][])ncIn.findVariable(strDet).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                NO3_tp1 = (float[][][])ncIn.findVariable(strNO3).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
                Chla_tp1 = (float[][][])ncIn.findVariable(strCHLA).read(nArray2, new int[]{1, nz, ny, nx}).reduce().copyToNDJavaArray();
            }
        }
        catch (IOException iOException) {
            throw new IOException("P1 - Problem extracting fields at location " + ncIn.getLocation().toString() + " : " + iOException.getMessage());
        }
        catch (InvalidRangeException invalidRangeException) {
            throw new IOException("P2 - Problem extracting fields at location " + ncIn.getLocation().toString() + " : " + invalidRangeException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("P3 - Problem extracting fields at location " + ncIn.getLocation().toString() + " : " + nullPointerException.getMessage());
        }
    }

    static float[][][] computeW() {
        int n;
        int n2;
        int n3;
        System.out.println("Compute vertical velocity (ce sera cool quand aurra le w dans les sorties ROMS)");
        double[][][] dArray = new double[nz][ny][nx];
        double[][][] dArray2 = new double[nz][ny][nx];
        double[][][] dArray3 = z_w_tp1;
        int n4 = nz;
        while (n4-- > 0) {
            int n5 = 0;
            while (n5++ < nx - 1) {
                n3 = ny;
                while (n3-- > 0) {
                    dArray[n4][n3][n5] = (dArray3[n4 + 1][n3][n5] - dArray3[n4][n3][n5] + (dArray3[n4 + 1][n3][n5 - 1] - dArray3[n4][n3][n5 - 1])) / (pn[n3][n5] + pn[n3][n5 - 1]) * (double)u_tp1[n4][n3][n5 - 1];
                }
            }
            n5 = nx;
            while (n5-- > 0) {
                n3 = 0;
                while (n3++ < ny - 1) {
                    dArray2[n4][n3][n5] = (dArray3[n4 + 1][n3][n5] - dArray3[n4][n3][n5] + (dArray3[n4 + 1][n3 - 1][n5] - dArray3[n4][n3 - 1][n5])) / (pm[n3][n5] + pm[n3 - 1][n5]) * (double)v_tp1[n4][n3 - 1][n5];
                }
            }
        }
        double[] dArray4 = new double[nx];
        double[][][] dArray5 = new double[nz + 1][ny][nx];
        n3 = ny - 1;
        while (n3-- > 0) {
            n2 = nx;
            while (n2-- > 0) {
                dArray5[0][n3][n2] = 0.0;
            }
            n2 = 0;
            while (n2++ < nz) {
                n = nx - 1;
                while (n-- > 0) {
                    dArray5[n2][n3][n] = dArray5[n2 - 1][n3][n] + (double)((float)(dArray[n2 - 1][n3][n] - dArray[n2 - 1][n3][n + 1] + dArray2[n2 - 1][n3][n] - dArray2[n2 - 1][n3 + 1][n]));
                }
            }
            n2 = nx;
            while (n2-- > 0) {
                dArray4[n2] = dArray5[nz][n3][n2] / (dArray3[nz][n3][n2] - dArray3[0][n3][n2]);
            }
            n2 = nz;
            while (n2-- >= 2) {
                n = nx;
                while (n-- > 0) {
                    double[] dArray6 = dArray5[n2][n3];
                    int n6 = n;
                    dArray6[n6] = dArray6[n6] + -dArray4[n] * (dArray3[n2][n3][n] - dArray3[0][n3][n]);
                }
            }
            n2 = nx;
            while (n2-- > 0) {
                dArray5[Dataset_EVOL.nz][n3][n2] = 0.0;
            }
        }
        n3 = nz + 1;
        while (n3-- > 0) {
            n2 = ny;
            while (n2-- > 0) {
                dArray5[n3][n2][0] = dArray5[n3][n2][1];
                dArray5[n3][n2][Dataset_EVOL.nx - 1] = dArray5[n3][n2][nx - 2];
            }
        }
        n3 = nz + 1;
        while (n3-- > 0) {
            n2 = nx;
            while (n2-- > 0) {
                dArray5[n3][0][n2] = dArray5[n3][1][n2];
                dArray5[n3][Dataset_EVOL.ny - 1][n2] = dArray5[n3][ny - 2][n2];
            }
        }
        float[][][] fArray = new float[nz + 1][ny][nx];
        n2 = nx;
        while (n2-- > 0) {
            n = ny;
            while (n-- > 0) {
                int n7 = nz + 1;
                while (n7-- > 0) {
                    fArray[n7][n][n2] = (float)(dArray5[n7][n][n2] * pm[n][n2] * pn[n][n2]);
                }
            }
        }
        return fArray;
    }

    public static double getDepth(double d, double d2, int n) {
        int n2 = (int)d;
        int n3 = (int)d2;
        double d3 = 0.0;
        double d4 = d - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                if (Dataset_EVOL.isInWater(n2 + n4, n3 + n5)) {
                    d6 = Math.abs(((double)(1 - n4) - d4) * ((double)(1 - n5) - d5));
                    double d7 = 0.0;
                    d7 = z_rho_cst[n][n3 + n5][n2 + n4] + (double)zeta_tp0[n3 + n5][n2 + n4] * (1.0 + z_rho_cst[n][n3 + n5][n2 + n4] / hRho[n3 + n5][n2 + n4]);
                    d3 += d6 * d7;
                }
                ++n5;
            }
            ++n4;
        }
        return d3;
    }

    public static boolean isInWater(int n, int n2) {
        return maskRho[n2][n] > 0;
    }

    public static boolean isInWater(double d, double d2) {
        try {
            return maskRho[(int)Math.round(d2)][(int)Math.round(d)] > 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    static boolean isCloseToCost(double[] dArray) {
        int n;
        int n2 = (int)Math.floor(dArray[0]);
        return !Dataset_EVOL.isInWater(n2, n = (int)Math.floor(dArray[1])) || !Dataset_EVOL.isInWater(n2 + 1, n) || !Dataset_EVOL.isInWater(n2, n + 1) || !Dataset_EVOL.isInWater(n2 + 1, n + 1);
    }

    static boolean isCloseToCost(double d, double d2) {
        int n;
        int n2 = (int)Math.floor(d);
        return !Dataset_EVOL.isInWater(n2, n = (int)Math.floor(d2)) || !Dataset_EVOL.isInWater(n2 + 1, n) || !Dataset_EVOL.isInWater(n2, n + 1) || !Dataset_EVOL.isInWater(n2 + 1, n + 1);
    }

    public static double depth2z(double d, double d2, double d3) {
        double d4 = 0.0;
        int n = nz - 1;
        while (n > 0 && Dataset_EVOL.getDepth(d, d2, n) > d3) {
            --n;
        }
        if (n == nz - 1) {
            d4 = n;
        } else {
            double d5 = Dataset_EVOL.getDepth(d, d2, n);
            d4 = Math.max(0.0, (double)n + (d3 - d5) / (Dataset_EVOL.getDepth(d, d2, n + 1) - d5));
        }
        return d4;
    }

    public static double depth2z(int n, int n2, double d) {
        double d2 = 0.0;
        int n3 = nz - 1;
        while (n3 > 0 && z_rho_cst[n3][n2][n] > d) {
            --n3;
        }
        d2 = n3 == nz - 1 ? (double)n3 : Math.max(0.0, (double)n3 + (d - z_rho_cst[n3][n2][n]) / (z_rho_cst[n3 + 1][n2][n] - z_rho_cst[n3][n2][n]));
        return d2;
    }

    static double z2depth(double d, double d2, double d3) {
        double d4 = Math.max(0.0, Math.min(d3, (double)nz - (double)1.00001f));
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.floor(d4);
        double d5 = 0.0;
        double d6 = d - (double)n;
        double d7 = d2 - (double)n2;
        double d8 = d4 - (double)n3;
        double d9 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    d9 = Math.abs((1.0 - (double)n4 - d6) * (1.0 - (double)n5 - d7) * (1.0 - (double)n6 - d8));
                    if (Dataset_EVOL.isInWater(n + n4, n2 + n5)) {
                        double d10 = z_rho_cst[n3 + n6][n2 + n5][n + n4] + (double)zeta_tp0[n2 + n5][n + n4] * (1.0 + z_rho_cst[n3 + n6][n2 + n5][n + n4] / hRho[n2 + n5][n + n4]);
                        d5 += d9 * d10;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return d5;
    }

    public static double[] grid2Geo(double d, double d2, double d3) {
        double d4 = Math.max(0.0, Math.min(d3, (double)nz - (double)1.00001f));
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.floor(d4);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d - (double)n;
        double d9 = d2 - (double)n2;
        double d10 = d4 - (double)n3;
        double d11 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    d11 = Math.abs((1.0 - (double)n4 - d8) * (1.0 - (double)n5 - d9) * (1.0 - (double)n6 - d10));
                    d5 += d11 * latRho[n2 + n5][n + n4];
                    d6 += d11 * lonRho[n2 + n5][n + n4];
                    if (Dataset_EVOL.isInWater(n + n4, n2 + n5)) {
                        double d12 = z_rho_cst[n3 + n6][n2 + n5][n + n4] + (double)zeta_tp0[n2 + n5][n + n4] * (1.0 + z_rho_cst[n3 + n6][n2 + n5][n + n4] / hRho[n2 + n5][n + n4]);
                        d7 += d11 * d12;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return new double[]{d5, d6, d7};
    }

    public static double[] grid2Geo(double d, double d2) {
        double d3 = Math.max((double)1.0E-5f, Math.min(d, (double)nx - (double)1.00001f));
        double d4 = Math.max((double)1.0E-5f, Math.min(d2, (double)ny - (double)1.00001f));
        int n = (int)Math.floor(d3);
        int n2 = (int)Math.floor(d4);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d3 - (double)n;
        double d8 = d4 - (double)n2;
        double d9 = 0.0;
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 2) {
                d9 = Math.abs(((double)(1 - n3) - d7) * ((double)(1 - n4) - d8));
                d5 += d9 * latRho[n2 + n4][n + n3];
                d6 += d9 * lonRho[n2 + n4][n + n3];
                ++n4;
            }
            ++n3;
        }
        return new double[]{d5, d6};
    }

    public static double[] geo2Grid(double d, double d2) {
        double d3 = -1.0;
        double d4 = -1.0;
        boolean bl = Dataset_EVOL.isInsidePolygone(0, nx - 1, 0, ny - 1, d, d2);
        if (bl) {
            int n = 0;
            int n2 = nx - 1;
            int n3 = 0;
            int n4 = ny - 1;
            while (n2 - n > 1 | n4 - n3 > 1) {
                if (n2 - n > 1) {
                    int n5 = (n + n2) / 2;
                    bl = Dataset_EVOL.isInsidePolygone(n, n5, n3, n4, d, d2);
                    if (bl) {
                        n2 = n5;
                    } else {
                        n = n5;
                    }
                }
                if (n4 - n3 <= 1) continue;
                int n6 = (n4 + n3) / 2;
                bl = Dataset_EVOL.isInsidePolygone(n, n2, n3, n6, d, d2);
                if (bl) {
                    n4 = n6;
                    continue;
                }
                n3 = n6;
            }
            double d5 = latRho[n3 + 1][n] - latRho[n3][n];
            double d6 = lonRho[n3 + 1][n] - lonRho[n3][n];
            double d7 = latRho[n3][n + 1] - latRho[n3][n];
            double d8 = lonRho[n3][n + 1] - lonRho[n3][n];
            double d9 = d * d5 - d2 * d6;
            double d10 = lonRho[n3][n] * d7 - latRho[n3][n] * d8;
            double d11 = (d9 * d8 - d10 * d6) / (d8 * d5 - d7 * d6);
            d11 = (d11 - lonRho[n3][n]) / d8;
            d3 = (double)n + Math.min(Math.max(0.0, d11), 1.0);
            d9 = lonRho[n3][n] * d5 - latRho[n3][n] * d6;
            d10 = d * d7 - d2 * d8;
            double d12 = (d9 * d7 - d10 * d5) / (d8 * d5 - d7 * d6);
            d12 = (d12 - latRho[n3][n]) / d5;
            d4 = (double)n3 + Math.min(Math.max(0.0, d12), 1.0);
        }
        return new double[]{d3, d4};
    }

    public static boolean isInsidePolygone(int n, int n2, int n3, int n4, double d, double d2) {
        boolean bl = true;
        int n5 = 2 * (n4 - n3 + n2 - n);
        double[] dArray = new double[n5 + 1];
        double[] dArray2 = new double[n5 + 1];
        int n6 = 0 - n;
        int n7 = n;
        while (n7 <= n2 - 1) {
            dArray[n7 + n6] = lonRho[n3][n7];
            dArray2[n7 + n6] = latRho[n3][n7];
            ++n7;
        }
        n6 = 0 - n3 + n2 - n;
        n7 = n3;
        while (n7 <= n4 - 1) {
            dArray[n7 + n6] = lonRho[n7][n2];
            dArray2[n7 + n6] = latRho[n7][n2];
            ++n7;
        }
        n6 = n4 - n3 + 2 * n2 - n;
        n7 = n2;
        while (n7 >= n + 1) {
            dArray[n6 - n7] = lonRho[n4][n7];
            dArray2[n6 - n7] = latRho[n4][n7];
            --n7;
        }
        n6 = 2 * n4 - n3 + 2 * (n2 - n);
        n7 = n4;
        while (n7 >= n3 + 1) {
            dArray[n6 - n7] = lonRho[n7][n];
            dArray2[n6 - n7] = latRho[n7][n];
            --n7;
        }
        dArray[n5] = dArray[0];
        dArray2[n5] = dArray2[0];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            if (dArray[n9] != dArray[n9 + 1]) {
                double d3 = d - dArray[n9];
                double d4 = dArray[n9 + 1] - d;
                double d5 = d4 * (d2 - dArray2[n9]) - d3 * (dArray2[n9 + 1] - d2);
                n7 = 0;
                if (dArray[n9] == d & dArray2[n9] == d2) {
                    n8 = 1;
                } else if (d3 == 0.0 & d2 >= dArray2[n9] | d4 == 0.0 & d2 >= dArray2[n9 + 1]) {
                    n7 = 1;
                } else if (d3 * d4 > 0.0 & (dArray[n9 + 1] - dArray[n9]) * d5 >= 0.0) {
                    n7 = 2;
                }
                n8 = dArray[n9 + 1] > dArray[n9] ? (n8 += n7) : (n8 -= n7);
            }
            ++n9;
        }
        if (n8 == 0) {
            bl = false;
        }
        return bl;
    }

    public static double getTemperature(double d, double d2, double d3, double d4) throws ArrayIndexOutOfBoundsException {
        if (!FLAG_TP) {
            return Double.NaN;
        }
        int n = Dataset_EVOL.isCloseToCost(d, d2) ? 1 : 2;
        int n2 = (int)d;
        int n3 = (int)d2;
        double d5 = Math.max(0.0, Math.min(d3, (double)nz - (double)1.00001f));
        int n4 = (int)d5;
        double d6 = d - (double)n2;
        double d7 = d2 - (double)n3;
        double d8 = d5 - (double)n4;
        double d9 = 0.0;
        double d10 = 0.0;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n) {
                    double d11 = Math.abs((1.0 - (double)n7 - d6) * (1.0 - (double)n6 - d7) * (1.0 - (double)n5 - d8));
                    d10 += d11;
                    double d12 = 0.0;
                    try {
                        d12 = (1.0 - d4) * (double)temp_tp0[n4 + n5][n3 + n6][n2 + n7] + d4 * (double)temp_tp1[n4 + n5][n3 + n6][n2 + n7];
                        d9 += d12 * d11;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ArrayIndexOutOfBoundsException("Problem interpolating temperature field : " + arrayIndexOutOfBoundsException.getMessage());
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        if (d10 != 0.0) {
            d9 /= d10;
        }
        return d9;
    }

    public static double getSalinity(double[] dArray, double d) throws ArrayIndexOutOfBoundsException {
        if (!FLAG_SAL) {
            return Double.NaN;
        }
        int n = Dataset_EVOL.isCloseToCost(dArray) ? 1 : 2;
        int n2 = (int)dArray[0];
        int n3 = (int)dArray[1];
        double d2 = Math.max(0.0, Math.min(dArray[2], (double)nz - (double)1.00001f));
        int n4 = (int)d2;
        double d3 = dArray[0] - (double)n2;
        double d4 = dArray[1] - (double)n3;
        double d5 = d2 - (double)n4;
        double d6 = 0.0;
        double d7 = 0.0;
        int n5 = 0;
        while (n5 < 2) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = 0;
                while (n7 < n) {
                    double d8 = Math.abs((1.0 - (double)n7 - d3) * (1.0 - (double)n6 - d4) * (1.0 - (double)n5 - d5));
                    d7 += d8;
                    double d9 = 0.0;
                    try {
                        d9 = (1.0 - d) * (double)salt_tp0[n4 + n5][n3 + n6][n2 + n7] + d * (double)salt_tp1[n4 + n5][n3 + n6][n2 + n7];
                        d6 += d9 * d8;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        if (d7 != 0.0) {
            d6 /= d7;
        }
        return d6;
    }

    public static double getHBL(double d, double d2, double d3) throws ArrayIndexOutOfBoundsException {
        if (!FLAG_HBL) {
            return Double.NaN;
        }
        int n = Dataset_EVOL.isCloseToCost(d, d2) ? 1 : 2;
        int n2 = (int)d;
        int n3 = (int)d2;
        double d4 = d - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                double d8 = Math.abs((1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                d7 += d8;
                double d9 = 0.0;
                try {
                    d9 = (1.0 - d3) * (double)hbl_tp0[n3 + n4][n2 + n5] + d3 * (double)hbl_tp1[n3 + n4][n2 + n5];
                    d6 += d9 * d8;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n5;
            }
            ++n4;
        }
        if (d7 != 0.0) {
            d6 /= d7;
        }
        return d6;
    }

    public static double getZETA(double d, double d2, double d3) throws ArrayIndexOutOfBoundsException {
        int n = Dataset_EVOL.isCloseToCost(d, d2) ? 1 : 2;
        int n2 = (int)d;
        int n3 = (int)d2;
        double d4 = d - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                double d8 = Math.abs((1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                d7 += d8;
                double d9 = 0.0;
                try {
                    d9 = (1.0 - d3) * (double)zeta_tp0[n3 + n4][n2 + n5] + d3 * (double)zeta_tp1[n3 + n4][n2 + n5];
                    d6 += d9 * d8;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n5;
            }
            ++n4;
        }
        if (d7 != 0.0) {
            d6 /= d7;
        }
        return d6;
    }

    public static double[] get_uvw(double[] dArray, double d, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = Dataset_EVOL.isCloseToCost(dArray) ? 1 : 2;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = Math.max(0.0, Math.min(dArray[2], (double)((float)nz - 1.00001f)));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d;
        try {
            double d9;
            double d10;
            int n3;
            int n4;
            int n5 = (int)d2;
            int n6 = (int)d3;
            int n7 = (int)Math.round(d4);
            double d11 = d2 - (double)n5;
            double d12 = d3 - (double)n6;
            double d13 = d4 - (double)n7;
            double d14 = 0.0;
            int n8 = 0;
            while (n8 < n2) {
                n4 = 0;
                while (n4 < n2) {
                    n3 = 0;
                    while (n3 < 2) {
                        d10 = Math.abs((1.0 - (double)n8 - d11) * (1.0 - (double)n4 - d12) * (0.5 - (double)n3 - d13));
                        d14 += d10;
                        d9 = (1.0 - d8) * (double)w_tp0[n7 + n3][n6 + n4][n5 + n8] + d8 * (double)w_tp1[n7 + n3][n6 + n4][n5 + n8];
                        d7 += 2.0 * d9 * d10 / (z_w_tp0[Math.min(n7 + n3 + 1, nz)][n6 + n4][n5 + n8] - z_w_tp0[Math.max(n7 + n3 - 1, 0)][n6 + n4][n5 + n8]);
                        ++n3;
                    }
                    ++n4;
                }
                ++n8;
            }
            if (d14 != 0.0) {
                d7 /= d14;
            }
            n5 = (int)Math.round(d2);
            n7 = (int)d4;
            d11 = d2 - (double)n5;
            d13 = d4 - (double)n7;
            d14 = 0.0;
            n8 = 0;
            while (n8 < 2) {
                n4 = 0;
                while (n4 < n2) {
                    n3 = 0;
                    while (n3 < 2) {
                        d10 = Math.abs((0.5 - (double)n8 - d11) * (1.0 - (double)n4 - d12) * (1.0 - (double)n3 - d13));
                        d14 += d10;
                        d9 = (1.0 - d8) * (double)u_tp0[n7 + n3][n6 + n4][n5 + n8 - 1] + d8 * (double)u_tp1[n7 + n3][n6 + n4][n5 + n8 - 1];
                        d5 += 0.5 * d9 * d10 * (pm[n6 + n4][Math.max(n5 + n8 - 1, 0)] + pm[n6 + n4][n5 + n8]);
                        ++n3;
                    }
                    ++n4;
                }
                ++n8;
            }
            if (d14 != 0.0) {
                d5 /= d14;
            }
            n5 = (int)d2;
            n6 = (int)Math.round(d3);
            d11 = d2 - (double)n5;
            d12 = d3 - (double)n6;
            d14 = 0.0;
            n8 = 0;
            while (n8 < 2) {
                n4 = 0;
                while (n4 < 2) {
                    n3 = 0;
                    while (n3 < n2) {
                        d10 = Math.abs((1.0 - (double)n3 - d11) * (0.5 - (double)n4 - d12) * (1.0 - (double)n8 - d13));
                        d14 += d10;
                        d9 = (1.0 - d8) * (double)v_tp0[n7 + n8][n6 + n4 - 1][n5 + n3] + d8 * (double)v_tp1[n7 + n8][n6 + n4 - 1][n5 + n3];
                        d6 += 0.5 * d9 * d10 * (pn[Math.max(n6 + n4 - 1, 0)][n5 + n3] + pn[n6 + n4][n5 + n3]);
                        ++n3;
                    }
                    ++n4;
                }
                ++n8;
            }
            if (d14 != 0.0) {
                d6 /= d14;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Problem interpolating velocity fields : " + arrayIndexOutOfBoundsException.getMessage() + " --> Pos : ix = " + d2 + "  jy = " + d3 + "  kz = " + d4);
        }
        if (d5 > 1.0) {
            System.err.println("! WARNING : CFL broken for u " + (float)d5);
            System.out.println("ix,jy,kz : " + d2 + " , " + d3 + " , " + d4);
        }
        if (d6 > 1.0) {
            System.err.println("! WARNING : CFL broken for v " + (float)d6);
            System.out.println("ix,jy,kz : " + d2 + " , " + d3 + " , " + d4);
        }
        return new double[]{d5 *= (double)(n * 60), d6 *= (double)(n * 60), d7 *= (double)(n * 60)};
    }

    public static double[] getPlankton_PISCES(double[] dArray, double d) {
        if (!FLAG_PLANKTON_PISCES) {
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        int n = (int)dArray[0];
        int n2 = (int)dArray[1];
        double d2 = Math.max(0.0, Math.min(dArray[2], (double)nz - (double)1.00001f));
        int n3 = (int)d2;
        double d3 = dArray[0] - (double)n;
        double d4 = dArray[1] - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    if (Dataset_EVOL.isInWater(n + n6, n2 + n5)) {
                        double d11 = Math.abs((1.0 - (double)n6 - d3) * (1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                        d10 += d11;
                        double d12 = 0.0;
                        d12 = (1.0 - d) * (double)Diatoms_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Diatoms_tp1[n3 + n4][n2 + n5][n + n6];
                        d6 += d12 * d11;
                        d12 = (1.0 - d) * (double)NanoPhyto_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)NanoPhyto_tp1[n3 + n4][n2 + n5][n + n6];
                        d7 += d12 * d11;
                        d12 = (1.0 - d) * (double)MicroZoo_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)MicroZoo_tp1[n3 + n4][n2 + n5][n + n6];
                        d8 += d12 * d11;
                        d12 = (1.0 - d) * (double)MesoZoo_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)MesoZoo_tp1[n3 + n4][n2 + n5][n + n6];
                        d9 += d12 * d11;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        if (d10 != 0.0) {
            d6 /= d10;
            d7 /= d10;
            d8 /= d10;
            d9 /= d10;
        }
        return new double[]{d6, d7, d8, d9};
    }

    public static double[] getPlankton_PISCES_tot(double[] dArray, double d) {
        int n = (int)dArray[0];
        int n2 = (int)dArray[1];
        double d2 = Math.max(0.0, Math.min(dArray[2], (double)nz - (double)1.00001f));
        int n3 = (int)d2;
        double d3 = dArray[0] - (double)n;
        double d4 = dArray[1] - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    if (Dataset_EVOL.isInWater(n + n6, n2 + n5)) {
                        double d9 = Math.abs((1.0 - (double)n6 - d3) * (1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                        d8 += d9;
                        double d10 = 0.0;
                        d10 = (1.0 - d) * (double)Phyto_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Phyto_tp1[n3 + n4][n2 + n5][n + n6];
                        d6 += d10 * d9;
                        d10 = (1.0 - d) * (double)Zoo_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Zoo_tp1[n3 + n4][n2 + n5][n + n6];
                        d7 += d10 * d9;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        if (d8 != 0.0) {
            d6 /= d8;
            d7 /= d8;
        }
        return new double[]{d6, d7};
    }

    public static double[] getPlankton_NPZD(double[] dArray, double d) {
        if (!FLAG_PLANKTON_NPZD) {
            System.out.println(" PAS DE CHAMPS DE PLANKTON ISSUS DE ROMS_NPZD ");
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        int n = (int)dArray[0];
        int n2 = (int)dArray[1];
        double d2 = Math.max(0.0, Math.min(dArray[2], (double)nz - (double)1.00001f));
        int n3 = (int)d2;
        double d3 = dArray[0] - (double)n;
        double d4 = dArray[1] - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    if (Dataset_EVOL.isInWater(n + n6, n2 + n5)) {
                        double d12 = Math.abs((1.0 - (double)n6 - d3) * (1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                        d11 += d12;
                        double d13 = 0.0;
                        d13 = (1.0 - d) * (double)Phyto_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Phyto_tp1[n3 + n4][n2 + n5][n + n6];
                        d6 += d13 * d12;
                        d13 = (1.0 - d) * (double)Zoo_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Zoo_tp1[n3 + n4][n2 + n5][n + n6];
                        d7 += d13 * d12;
                        d13 = (1.0 - d) * (double)Det_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Det_tp1[n3 + n4][n2 + n5][n + n6];
                        d8 += d13 * d12;
                        d13 = (1.0 - d) * (double)NO3_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)NO3_tp1[n3 + n4][n2 + n5][n + n6];
                        d9 += d13 * d12;
                        d13 = (1.0 - d) * (double)Chla_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)Chla_tp1[n3 + n4][n2 + n5][n + n6];
                        d10 += d13 * d12;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        if (d11 != 0.0) {
            d6 /= d11;
            d7 /= d11;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
        }
        return new double[]{d6, d7, d8, d9, d10};
    }

    public static double[] getChla(double[] dArray, double d) {
        int n = (int)dArray[0];
        int n2 = (int)dArray[1];
        double d2 = Math.max(0.0, Math.min(dArray[2], (double)nz - (double)1.00001f));
        int n3 = (int)d2;
        double d3 = dArray[0] - (double)n;
        double d4 = dArray[1] - (double)n2;
        double d5 = d2 - (double)n3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        while (n4 < 2) {
            int n5 = 0;
            while (n5 < 2) {
                int n6 = 0;
                while (n6 < 2) {
                    if (Dataset_EVOL.isInWater(n + n6, n2 + n5)) {
                        double d9 = Math.abs((1.0 - (double)n6 - d3) * (1.0 - (double)n5 - d4) * (1.0 - (double)n4 - d5));
                        d8 += d9;
                        double d10 = 0.0;
                        d10 = (1.0 - d) * (double)DiatomsChl_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)DiatomsChl_tp1[n3 + n4][n2 + n5][n + n6];
                        d6 += d10 * d9;
                        d10 = (1.0 - d) * (double)NanoPhytoChl_tp0[n3 + n4][n2 + n5][n + n6] + d * (double)NanoPhytoChl_tp1[n3 + n4][n2 + n5][n + n6];
                        d7 += d10 * d9;
                    }
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        if (d8 != 0.0) {
            d6 /= d8;
            d7 /= d8;
        }
        return new double[]{d7, d6};
    }

    private ArrayList<String> getInputList(String string) throws IOException {
        ArrayList arrayList = null;
        filtre_roms_output = "*" + sufixe;
        new File(string);
        if (arrayList.size() > 1) {
            System.out.println("on a un total de " + arrayList.size() + "fichiers " + filtre_roms_output + " disponibles");
        }
        return arrayList;
    }

    private void openLocation(String string) throws IOException {
        URI uRI = new File("").toURI();
        String string2 = uRI.resolve(URI.create(string)).getPath();
        if (this.isDirectory(string2)) {
            listInputFiles = this.getInputList(string2);
            System.out.println("on ouvre le premier fichier netcdf (qui doit contenir les info de grille) pour en extraire les champs constants : ");
        }
        String string3 = Dataset_EVOL.get_filename(1980, 1);
        Dataset_EVOL.open(string3);
    }

    private static void open(String string) throws IOException {
        try {
            if (ncIn == null || new File(ncIn.getLocation()).compareTo(new File(string)) != 0) {
                System.out.println("On ouvre le fichier : " + string);
                ncIn = NetcdfDataset.openFile((String)string, null);
                nbTimeRecords = ncIn.findDimension(strTimeDim).getLength();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Problem opening dataset " + string + " - " + iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Problem reading " + strTimeDim + " dimension at location " + string + " : " + nullPointerException.getMessage());
        }
    }

    static boolean isOnEdge(double d, double d2) {
        return d > (double)((float)nx - 3.0f) || d < 3.0 || d2 > (double)((float)ny - 3.0f) || d2 < 3.0;
    }

    static double geodesicDistance(double d, double d2, double d3, double d4) {
        double d5 = 6367000.0 * Math.sqrt(2.0 - 2.0 * Math.cos(Math.PI * d / 180.0) * Math.cos(Math.PI * d3 / 180.0) * Math.cos(Math.PI * (d2 - d4) / 180.0) - 2.0 * Math.sin(Math.PI * d / 180.0) * Math.sin(Math.PI * d3 / 180.0));
        return d5;
    }

    void readConstantField() throws IOException {
        int[] nArray = new int[]{jpo, ipo};
        int[] nArray2 = new int[]{ny, nx};
        StringBuffer stringBuffer = new StringBuffer(strLon);
        stringBuffer.append(", ");
        stringBuffer.append(strLat);
        stringBuffer.append(", ");
        stringBuffer.append(strMask_rho);
        stringBuffer.append(", ");
        stringBuffer.append(strBathy);
        stringBuffer.append(", ");
        stringBuffer.append(strZeta);
        stringBuffer.append(", ");
        stringBuffer.append(this.strPm);
        stringBuffer.append(", ");
        stringBuffer.append(this.strPn);
        try {
            int n;
            int n2;
            Index index;
            Array array = ncIn.findVariable(strLon).read(nArray, nArray2);
            Array array2 = ncIn.findVariable(strLat).read(nArray, nArray2);
            Array array3 = ncIn.findVariable(strMask_rho).read(nArray, nArray2);
            Array array4 = ncIn.findVariable(strBathy).read(nArray, nArray2);
            int[] nArray3 = new int[3];
            nArray3[1] = jpo;
            nArray3[2] = ipo;
            Array array5 = ncIn.findVariable(strZeta).read(nArray3, new int[]{1, ny, nx}).reduce();
            Array array6 = ncIn.findVariable(this.strPm).read(nArray, nArray2);
            Array array7 = ncIn.findVariable(this.strPn).read(nArray, nArray2);
            if (array.getElementType() == Double.TYPE) {
                lonRho = (double[][])array.copyToNDJavaArray();
                latRho = (double[][])array2.copyToNDJavaArray();
            } else {
                lonRho = new double[ny][nx];
                latRho = new double[ny][nx];
                index = array.getIndex();
                n2 = 0;
                while (n2 < ny) {
                    n = 0;
                    while (n < nx) {
                        index.set(n2, n);
                        Dataset_EVOL.lonRho[n2][n] = array.getDouble(index);
                        Dataset_EVOL.latRho[n2][n] = array2.getDouble(index);
                        ++n;
                    }
                    ++n2;
                }
            }
            if (array3.getElementType() != Byte.TYPE) {
                maskRho = new byte[ny][nx];
                index = array3.getIndex();
                n2 = 0;
                while (n2 < ny) {
                    n = 0;
                    while (n < nx) {
                        Dataset_EVOL.maskRho[n2][n] = array3.getByte(index.set(n2, n));
                        ++n;
                    }
                    ++n2;
                }
            } else {
                maskRho = (byte[][])array3.copyToNDJavaArray();
            }
            if (array6.getElementType() == Double.TYPE) {
                pm = (double[][])array6.copyToNDJavaArray();
                pn = (double[][])array7.copyToNDJavaArray();
            } else {
                pm = new double[ny][nx];
                pn = new double[ny][nx];
                index = array6.getIndex();
                n2 = 0;
                while (n2 < ny) {
                    n = 0;
                    while (n < nx) {
                        index.set(n2, n);
                        Dataset_EVOL.pm[n2][n] = array6.getDouble(index);
                        Dataset_EVOL.pn[n2][n] = array7.getDouble(index);
                        ++n;
                    }
                    ++n2;
                }
            }
            if (array4.getElementType() == Double.TYPE) {
                hRho = (double[][])array4.copyToNDJavaArray();
            } else {
                hRho = new double[ny][nx];
                index = array4.getIndex();
                n2 = 0;
                while (n2 < ny) {
                    n = 0;
                    while (n < nx) {
                        Dataset_EVOL.hRho[n2][n] = array4.getDouble(index.set(n2, n));
                        ++n;
                    }
                    ++n2;
                }
            }
            if (array5.getElementType() == Float.TYPE) {
                zeta_tp0 = (float[][])array5.copyToNDJavaArray();
            } else {
                zeta_tp0 = new float[ny][nx];
                index = array5.getIndex();
                n2 = 0;
                while (n2 < ny) {
                    n = 0;
                    while (n < nx) {
                        Dataset_EVOL.zeta_tp0[n2][n] = array5.getFloat(index.set(n2, n));
                        ++n;
                    }
                    ++n2;
                }
            }
            zeta_tp1 = zeta_tp0;
        }
        catch (IOException iOException) {
            throw new IOException("Problem (1) reading one of the fields " + stringBuffer.toString() + " at location " + ncIn.getLocation().toString() + " : " + iOException.getMessage());
        }
        catch (InvalidRangeException invalidRangeException) {
            throw new IOException("Problem (2) reading one of the fields " + stringBuffer.toString() + " at location " + ncIn.getLocation().toString() + " : " + invalidRangeException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Problem (3) reading one of the fields " + stringBuffer.toString() + " at location " + ncIn.getLocation().toString() + " : " + nullPointerException.getMessage());
        }
    }

    private boolean isDirectory(String string) throws IOException {
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            throw new IOException(string + " is not a valid directory.");
        }
        return file2.isDirectory();
    }

    void getCstSigLevels() throws IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[nz];
        double[] dArray2 = new double[nz];
        double[] dArray3 = new double[nz];
        double[] dArray4 = new double[nz + 1];
        double[] dArray5 = new double[nz + 1];
        double[] dArray6 = new double[nz + 1];
        try {
            if (ncIn.findGlobalAttribute(this.strThetaS) == null) {
                System.out.println("ROMS Rutgers");
                d = ncIn.findVariable(this.strThetaS).readScalarDouble();
                d2 = ncIn.findVariable(this.strThetaB).readScalarDouble();
                d3 = ncIn.findVariable(this.strHc).readScalarDouble();
            } else {
                System.out.println("ROMS UCLA");
                d = ncIn.findGlobalAttribute(this.strThetaS).getNumericValue().doubleValue();
                d2 = ncIn.findGlobalAttribute(this.strThetaB).getNumericValue().doubleValue();
                d3 = ncIn.findGlobalAttribute(this.strHc).getNumericValue().doubleValue();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Problem reading thetaS/thetaB/hc at location " + ncIn.getLocation().toString() + " : " + iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Problem reading thetaS/thetaB/hc at location " + ncIn.getLocation().toString() + " : " + nullPointerException.getMessage());
        }
        double d4 = 1.0 / Dataset_EVOL.sinh(d);
        double d5 = 0.5 / Dataset_EVOL.tanh(0.5 * d);
        int n = nz;
        while (n-- > 0) {
            dArray[n] = ((double)(n - nz) + 0.5) / (double)nz;
            dArray2[n] = (1.0 - d2) * d4 * Dataset_EVOL.sinh(d * dArray[n]) + d2 * (d5 * Dataset_EVOL.tanh(d * (dArray[n] + 0.5)) - 0.5);
            dArray3[n] = d3 * (dArray[n] - dArray2[n]);
        }
        n = nz + 1;
        while (n-- > 0) {
            dArray4[n] = (double)(n - nz) / (double)nz;
            dArray5[n] = (1.0 - d2) * d4 * Dataset_EVOL.sinh(d * dArray4[n]) + d2 * (d5 * Dataset_EVOL.tanh(d * (dArray4[n] + 0.5)) - 0.5);
            dArray6[n] = d3 * (dArray4[n] - dArray5[n]);
        }
        dArray4[0] = -1.0;
        dArray5[0] = -1.0;
        double[][][] dArray7 = new double[nz][ny][nx];
        double[][][] dArray8 = new double[nz + 1][ny][nx];
        int n2 = nx;
        while (n2-- > 0) {
            int n3 = ny;
            while (n3-- > 0) {
                dArray8[0][n3][n2] = -hRho[n3][n2];
                int n4 = nz;
                while (n4-- > 0) {
                    dArray7[n4][n3][n2] = dArray3[n4] + dArray2[n4] * hRho[n3][n2];
                    dArray8[n4 + 1][n3][n2] = dArray6[n4 + 1] + dArray5[n4 + 1] * hRho[n3][n2];
                }
                dArray8[Dataset_EVOL.nz][n3][n2] = 0.0;
            }
        }
        z_rho_cst = dArray7;
        z_w_cst = dArray8;
        z_w_tp0 = new double[nz + 1][ny][nx];
        z_w_tp1 = new double[nz + 1][ny][nx];
    }

    private static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    private static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    private static double tanh(double d) {
        return Dataset_EVOL.sinh(d) / Dataset_EVOL.cosh(d);
    }

    public static double getTimeTp1() {
        return time_tp1;
    }

    public static int get_nx() {
        return nx;
    }

    public static int get_ny() {
        return ny;
    }

    public static int get_nz() {
        return nz;
    }

    public static double getLatMin() {
        return latMin;
    }

    public static double getLatMax() {
        return latMax;
    }

    public static double getLonMin() {
        return lonMin;
    }

    public static double getLonMax() {
        return lonMax;
    }

    public static float getDepthMax() {
        return (float)depthMax;
    }

    public static double getLat(int n, int n2) {
        return latRho[n2][n];
    }

    public static double getLon(int n, int n2) {
        return lonRho[n2][n];
    }

    public static double getBathy(int n, int n2) {
        if (Dataset_EVOL.isInWater(n, n2)) {
            return hRho[n2][n];
        }
        return Double.NaN;
    }

    public static void load_data(int n) throws IOException {
        int n2 = n;
        Dataset_EVOL.setAllFieldsAtTime();
        Dataset_EVOL.setAllFieldsTp1AtTime(n2);
    }

    public static void load_data(int n, int n2) throws IOException {
        String string;
        int n3;
        int n4 = 1 + n / 30 % 12;
        int n5 = n % 30;
        if (n == 360) {
            n5 = 30;
            n4 = 12;
        }
        if ((n3 = n5 / dt_HyMo) < nbTimeRecords) {
            string = Dataset_EVOL.get_filename(n2, n4);
            Dataset_EVOL.open(string);
            Dataset_EVOL.setAllFieldsAtTime();
        }
        if (++n3 == nbTimeRecords) {
            if (++n4 > 12) {
                n4 = 1;
                ++n2;
            }
            string = Dataset_EVOL.get_filename(n2, n4);
            n3 = 0;
            Dataset_EVOL.open(string);
        }
        Dataset_EVOL.setAllFieldsTp1AtTime(n3);
    }

    public static double[] getFields_SaltTemp(double d, double d2, double d3, double d4) throws IOException {
        double[] dArray = new double[]{d, d2, d3};
        double d5 = Dataset_EVOL.getSalinity(dArray, d4);
        double d6 = Dataset_EVOL.getTemperature(d, d2, d3, d4);
        return new double[]{d6, d5};
    }

    public static double[] getFields_uvw(double d, double d2, double d3, double d4, int n) throws IOException {
        double[] dArray = new double[]{d, d2, d3};
        if (!Dataset_EVOL.isOnEdge(d, d2)) {
            double[] dArray2 = Dataset_EVOL.get_uvw(dArray, d4, n);
            return dArray2;
        }
        System.out.println("CATASTROPHE ON THE EDGE");
        return new double[]{0.0, 0.0, 0.0};
    }

    public static double[] getFields_uv(double d, double d2, double d3, double d4, int n) throws IOException {
        double[] dArray = new double[]{d, d2, d3};
        if (!Dataset_EVOL.isOnEdge(d, d2)) {
            double[] dArray2 = Dataset_EVOL.get_uv(dArray, d4, n);
            return dArray2;
        }
        System.out.println("CATASTROPHE ON THE EDGE");
        return new double[]{0.0, 0.0};
    }

    public static double[] get_uv(double[] dArray, double d, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = Dataset_EVOL.isCloseToCost(dArray) ? 1 : 2;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = Math.max(0.0, Math.min(dArray[2], (double)((float)nz - 1.00001f)));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d;
        try {
            double d8;
            double d9;
            int n3;
            int n4;
            int n5 = (int)d2;
            int n6 = (int)d3;
            int n7 = (int)Math.round(d4);
            double d10 = d2 - (double)n5;
            double d11 = d3 - (double)n6;
            double d12 = d4 - (double)n7;
            n5 = (int)Math.round(d2);
            n7 = (int)d4;
            d10 = d2 - (double)n5;
            d12 = d4 - (double)n7;
            double d13 = 0.0;
            d13 = 0.0;
            int n8 = 0;
            while (n8 < 2) {
                n4 = 0;
                while (n4 < n2) {
                    n3 = 0;
                    while (n3 < 2) {
                        d9 = Math.abs((0.5 - (double)n8 - d10) * (1.0 - (double)n4 - d11) * (1.0 - (double)n3 - d12));
                        d13 += d9;
                        d8 = (1.0 - d7) * (double)u_tp0[n7 + n3][n6 + n4][n5 + n8 - 1] + d7 * (double)u_tp1[n7 + n3][n6 + n4][n5 + n8 - 1];
                        d5 += 0.5 * d8 * d9 * (pm[n6 + n4][Math.max(n5 + n8 - 1, 0)] + pm[n6 + n4][n5 + n8]);
                        ++n3;
                    }
                    ++n4;
                }
                ++n8;
            }
            if (d13 != 0.0) {
                d5 /= d13;
            }
            n5 = (int)d2;
            n6 = (int)Math.round(d3);
            d10 = d2 - (double)n5;
            d11 = d3 - (double)n6;
            d13 = 0.0;
            n8 = 0;
            while (n8 < 2) {
                n4 = 0;
                while (n4 < 2) {
                    n3 = 0;
                    while (n3 < n2) {
                        d9 = Math.abs((1.0 - (double)n3 - d10) * (0.5 - (double)n4 - d11) * (1.0 - (double)n8 - d12));
                        d13 += d9;
                        d8 = (1.0 - d7) * (double)v_tp0[n7 + n8][n6 + n4 - 1][n5 + n3] + d7 * (double)v_tp1[n7 + n8][n6 + n4 - 1][n5 + n3];
                        d6 += 0.5 * d8 * d9 * (pn[Math.max(n6 + n4 - 1, 0)][n5 + n3] + pn[n6 + n4][n5 + n3]);
                        ++n3;
                    }
                    ++n4;
                }
                ++n8;
            }
            if (d13 != 0.0) {
                d6 /= d13;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Problem interpolating velocity fields : " + arrayIndexOutOfBoundsException.getMessage() + " --> Pos : ix = " + d2 + "  jy = " + d3 + "  kz = " + d4);
        }
        if (d5 > 1.0) {
            System.err.println("! WARNING : CFL broken for u " + (float)d5);
            System.out.println("ix,jy,kz : " + d2 + " , " + d3 + " , " + d4);
        }
        if (d6 > 1.0) {
            System.err.println("! WARNING : CFL broken for v " + (float)d6);
            System.out.println("ix,jy,kz : " + d2 + " , " + d3 + " , " + d4);
        }
        return new double[]{d5 *= (double)(n * 60), d6 *= (double)(n * 60)};
    }

    public static double[] get_PLANKTON_INTEG(double d, double d2, double d3) throws ArrayIndexOutOfBoundsException {
        double d4;
        double d5;
        int n;
        int n2 = Dataset_EVOL.isCloseToCost(d, d2) ? 1 : 2;
        int n3 = (int)d;
        int n4 = (int)d2;
        double d6 = d - (double)n3;
        double d7 = d2 - (double)n4;
        double d8 = 0.0;
        double d9 = 0.0;
        int n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n2) {
                d5 = Math.abs((1.0 - (double)n - d6) * (1.0 - (double)n5 - d7));
                d9 += d5;
                d4 = 0.0;
                try {
                    d4 = (1.0 - d3) * (double)Diatoms_integ_tp0[n4 + n5][n3 + n] + d3 * (double)Diatoms_integ_tp1[n4 + n5][n3 + n];
                    d8 += d4 * d5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n;
            }
            ++n5;
        }
        if (d9 != 0.0) {
            d8 /= d9;
        }
        double d10 = 0.0;
        d9 = 0.0;
        n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n2) {
                d5 = Math.abs((1.0 - (double)n - d6) * (1.0 - (double)n5 - d7));
                d9 += d5;
                d4 = 0.0;
                try {
                    d4 = (1.0 - d3) * (double)NanoPhyto_integ_tp0[n4 + n5][n3 + n] + d3 * (double)NanoPhyto_integ_tp1[n4 + n5][n3 + n];
                    d10 += d4 * d5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n;
            }
            ++n5;
        }
        if (d9 != 0.0) {
            d10 /= d9;
        }
        double d11 = 0.0;
        d9 = 0.0;
        n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n2) {
                d5 = Math.abs((1.0 - (double)n - d6) * (1.0 - (double)n5 - d7));
                d9 += d5;
                d4 = 0.0;
                try {
                    d4 = (1.0 - d3) * (double)MicroZoo_integ_tp0[n4 + n5][n3 + n] + d3 * (double)MicroZoo_integ_tp1[n4 + n5][n3 + n];
                    d11 += d4 * d5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n;
            }
            ++n5;
        }
        if (d9 != 0.0) {
            d11 /= d9;
        }
        double d12 = 0.0;
        d9 = 0.0;
        n5 = 0;
        while (n5 < n2) {
            n = 0;
            while (n < n2) {
                d5 = Math.abs((1.0 - (double)n - d6) * (1.0 - (double)n5 - d7));
                d9 += d5;
                d4 = 0.0;
                try {
                    d4 = (1.0 - d3) * (double)MesoZoo_integ_tp0[n4 + n5][n3 + n] + d3 * (double)MesoZoo_integ_tp1[n4 + n5][n3 + n];
                    d12 += d4 * d5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ArrayIndexOutOfBoundsException("Problem interpolating salinity field : " + arrayIndexOutOfBoundsException.getMessage());
                }
                ++n;
            }
            ++n5;
        }
        if (d9 != 0.0) {
            d12 /= d9;
        }
        return new double[]{d8, d10, d11, d12};
    }
}

