/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.netcdf.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGridFile;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.List;
import javax.swing.JOptionPane;
import org.geotools.coverage.grid.GridCoverage2D;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.ProjectionRect;

@GamlAnnotations.file(name="netcdf", extensions={"nc"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"grid", "asc", "tif", "file"}, doc={@GamlAnnotations.doc(value="Represents multi-dimensional arrays encoded in NetCDF format")})
public class GamaNetCDFFile
extends GamaGridFile {
    GamaNetCDFReader reader;
    IMatrix coverage;

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    private GamaNetCDFReader createReader(IScope iScope, boolean bl) {
        if (this.reader == null) {
            File file2 = this.getFile(iScope);
            file2.setReadable(true);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            try {
                this.reader = new GamaNetCDFReader(iScope, fileInputStream, bl);
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.warning((String)("The format of " + this.getName(iScope) + " is incorrect. Attempting to read it anyway."), (IScope)iScope), (boolean)false);
            }
        }
        return this.reader;
    }

    private static IMatrix matrixValue(IScope iScope, Array array, int n, int n2) {
        int n3;
        double[][] dArray = new double[n][n2];
        double d = MAMath.getMinimum((Array)array);
        double d2 = MAMath.getMaximum((Array)array);
        double d3 = d2 - d;
        if (d3 > 0.0) {
            d3 = 255.0 / d3;
        }
        IndexIterator indexIterator = array.getIndexIterator();
        int n4 = 0;
        while (n4 < n) {
            n3 = 0;
            while (n3 < n2) {
                double d4;
                double d5 = indexIterator.getDoubleNext();
                dArray[n4][n3] = d4 = (d5 - d) * d3;
                ++n3;
            }
            ++n4;
        }
        double[] dArray2 = new double[dArray.length];
        n3 = 0;
        while (n3 < dArray.length / 2) {
            dArray2 = dArray[dArray.length - n3 - 1];
            dArray[dArray.length - n3 - 1] = dArray[n3];
            dArray[n3] = dArray2;
            ++n3;
        }
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(n2, n);
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                gamaFloatMatrix.set(iScope, n6, n5, (Object)dArray[n5][n6]);
                ++n6;
            }
            ++n5;
        }
        return gamaFloatMatrix;
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\");", isExecutable=false)})
    public GamaNetCDFFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file specifying the coordinates system code, as an int (epsg code)", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\", 32648);", isExecutable=false)})
    public GamaNetCDFFile(IScope iScope, String string, Integer n) throws GamaRuntimeException {
        super(iScope, string, n);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a asc file or a tif (geotif) file specifying the coordinates system code (epg,...,), as a string ", examples={@GamlAnnotations.example(value="file f <- grid_file(\"file.asc\",\"EPSG:32648\");", isExecutable=false)})
    public GamaNetCDFFile(IScope iScope, String string, String string2) {
        super(iScope, string, string2);
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        this.fillBuffer(iScope);
        return this.gis.getProjectedEnvelope();
    }

    public Envelope computeEnvelopeWithoutBuffer(IScope iScope) {
        if (this.gis == null) {
            this.createReader(iScope, false);
        }
        return this.gis.getProjectedEnvelope();
    }

    protected void fillBuffer(IScope iScope) {
        if (this.getBuffer() != null) {
            return;
        }
        this.createReader(iScope, true);
    }

    public int getNbRows(IScope iScope) {
        if (this.reader == null) {
            this.createReader(iScope, true);
        }
        return this.reader.numRows;
    }

    public int getNbCols(IScope iScope) {
        if (this.reader == null) {
            this.createReader(iScope, true);
        }
        return this.reader.numCols;
    }

    public boolean isTiff(IScope iScope) {
        return this.getExtension(iScope).equals("tif");
    }

    public IShape getGeometry(IScope iScope) {
        if (this.reader == null) {
            this.createReader(iScope, true);
        }
        return this.reader.geom;
    }

    /*
     * Exception decompiling
     */
    protected CoordinateReferenceSystem getOwnCRS(IScope var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void invalidateContents() {
        super.invalidateContents();
        this.reader = null;
    }

    public GridCoverage2D getCoverage() {
        return null;
    }

    public Double valueOf(IScope iScope, GamaPoint gamaPoint) {
        if (this.getBuffer() == null) {
            this.fillBuffer(iScope);
        }
        Object object = null;
        try {
            object = this.coverage.get(iScope, (int)gamaPoint.getX(), (int)gamaPoint.getY());
        }
        catch (Exception exception) {
            object = this.reader.noData.doubleValue();
        }
        boolean bl = object instanceof double[];
        boolean bl2 = object instanceof int[];
        boolean bl3 = object instanceof byte[];
        boolean bl4 = object instanceof long[];
        boolean bl5 = object instanceof float[];
        Double d = null;
        if (bl) {
            double[] dArray = (double[])object;
            d = dArray[0];
        } else if (bl2) {
            int[] nArray = (int[])object;
            d = nArray[0];
        } else if (bl4) {
            long[] lArray = (long[])object;
            d = lArray[0];
        } else if (bl5) {
            float[] fArray = (float[])object;
            d = fArray[0];
        } else if (bl3) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 3) {
                int n = byArray[0] < 0 ? 256 + byArray[0] : byArray[0];
                int n2 = byArray[0] < 0 ? 256 + byArray[1] : byArray[1];
                int n3 = byArray[0] < 0 ? 256 + byArray[2] : byArray[2];
                d = (double)(n + n2 + n3) / 3.0;
            } else {
                d = ((byte[])object)[0];
            }
        }
        return d;
    }

    @GamlAnnotations.operator(value={"openDataSet"}, can_be_const=false, category={"Matrix-related operators"})
    @GamlAnnotations.doc(value="general operator to manipylate multidimension netcdf data.")
    public static Boolean openDataSet(IScope iScope, GamaNetCDFFile gamaNetCDFFile) {
        if (gamaNetCDFFile == null || iScope == null) {
            return false;
        }
        if (gamaNetCDFFile.reader == null) {
            gamaNetCDFFile.createReader(iScope, true);
        }
        if (gamaNetCDFFile.reader.ds != null) {
            String string;
            block7: {
                string = gamaNetCDFFile.getFile(iScope).getAbsolutePath();
                gamaNetCDFFile.reader.ds = NetcdfDataset.openDataset((String)string, (boolean)true, null);
                if (gamaNetCDFFile.reader != null) break block7;
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + string);
                return null;
            }
            try {
                gamaNetCDFFile.reader.gridDataset = new GridDataset(gamaNetCDFFile.reader.ds, new Formatter());
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, "NetcdfDataset.open cant open " + string + "\n" + fileNotFoundException.getMessage());
                fileNotFoundException.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"getTimeAxisSize"}, can_be_const=false, category={"Matrix-related operators"})
    @GamlAnnotations.doc(value="general operator to manipylate multidimension netcdf data.")
    public static Integer getTimeAxisSize(IScope iScope, GamaNetCDFFile gamaNetCDFFile, int n) {
        if (gamaNetCDFFile == null || iScope == null) {
            return -1;
        }
        if (gamaNetCDFFile.reader != null) {
            List list = gamaNetCDFFile.reader.gridDataset.getGrids();
            GridDatatype gridDatatype = null;
            if (n >= list.size()) {
                n = 0;
            }
            if (list.size() > 0) {
                gridDatatype = (GridDatatype)list.get(n);
            }
            if (gridDatatype != null) {
                GridCoordSystem gridCoordSystem = gridDatatype.getCoordinateSystem();
                if (gridCoordSystem.getTimeAxis() != null) {
                    gamaNetCDFFile.reader.ntimes = (int)gridCoordSystem.getTimeAxis().getSize();
                }
                return gamaNetCDFFile.reader.ntimes;
            }
        }
        return -1;
    }

    @GamlAnnotations.operator(value={"getGridsSize"}, can_be_const=false, category={"Files-related operators"})
    @GamlAnnotations.doc(value="general operator to manipylate multidimension netcdf data.")
    public static Integer getGridsSize(IScope iScope, GamaNetCDFFile gamaNetCDFFile) {
        if (gamaNetCDFFile == null || iScope == null) {
            return -1;
        }
        if (gamaNetCDFFile.reader != null) {
            List list = gamaNetCDFFile.reader.gridDataset.getGrids();
            return list.size();
        }
        return -1;
    }

    @GamlAnnotations.operator(value={"readDataSlice"}, can_be_const=false, category={"Matrix-related operators"})
    @GamlAnnotations.doc(value="general operator to manipylate multidimension netcdf data.")
    public static IMatrix readDataSlice(IScope iScope, GamaNetCDFFile gamaNetCDFFile, int n, int n2, int n3, int n4, int n5) {
        if (gamaNetCDFFile == null || iScope == null) {
            return new GamaIntMatrix(0, 0);
        }
        if (gamaNetCDFFile.reader != null) {
            List list = gamaNetCDFFile.reader.gridDataset.getGrids();
            GridDatatype gridDatatype = null;
            if (n >= list.size()) {
                n = 0;
            }
            if (list.size() > 0) {
                gridDatatype = (GridDatatype)list.get(n);
            }
            if (gridDatatype != null) {
                GridCoordSystem gridCoordSystem = gridDatatype.getCoordinateSystem();
                if (gridCoordSystem.getTimeAxis() != null) {
                    gamaNetCDFFile.reader.ntimes = (int)gridCoordSystem.getTimeAxis().getSize();
                }
                try {
                    Array array = gridDatatype.readDataSlice(n2, n3, n4, n5);
                    if (array.getRank() == 3) {
                        array = array.reduce();
                    }
                    if (array.getRank() == 3) {
                        array = array.slice(0, 0);
                    }
                    int n6 = array.getShape()[0];
                    int n7 = array.getShape()[1];
                    return GamaNetCDFFile.matrixValue(iScope, array, n6, n7);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return new GamaIntMatrix(0, 0);
    }

    class GamaNetCDFReader {
        int numRows;
        int numCols;
        IShape geom;
        Number noData = -9999;
        NetcdfDataset ds = null;
        private ucar.nc2.dt.GridDataset gridDataset;
        private int ntimes = 1;
        boolean forward = true;

        GamaNetCDFReader(IScope iScope, InputStream inputStream, boolean bl) throws GamaRuntimeException {
            GamaNetCDFFile.this.setBuffer((IAddressableContainer)GamaListFactory.create((IType)Types.GEOMETRY));
            try {
                Envelope3D envelope3D;
                String string;
                if (bl) {
                    iScope.getGui().getStatus().informStatus("Reading file " + GamaNetCDFFile.this.getName(iScope), "status/status.simulation");
                }
                GamaNetCDFFile.this.getExistingCRS(iScope);
                ProjectionRect projectionRect = null;
                if (this.ds == null) {
                    string = GamaNetCDFFile.this.getFile(iScope).getAbsolutePath();
                    this.ds = NetcdfDataset.openDataset((String)string, (boolean)true, null);
                    if (this.ds != null) {
                        this.ds.getCoordinateSystems().get(0);
                        this.gridDataset = new GridDataset(this.ds, new Formatter());
                        envelope3D = null;
                        List list = this.gridDataset.getGrids();
                        GridDatatype gridDatatype = null;
                        int n = 0;
                        if (n >= list.size()) {
                            n = 0;
                        }
                        if (list.size() > 0) {
                            gridDatatype = (GridDatatype)list.get(n);
                        }
                        if (gridDatatype != null) {
                            GridCoordSystem gridCoordSystem = gridDatatype.getCoordinateSystem();
                            if (gridCoordSystem.getTimeAxis() != null) {
                                this.ntimes = (int)gridCoordSystem.getTimeAxis().getSize();
                            }
                            projectionRect = gridCoordSystem.getBoundingBox();
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = -1;
                            int n5 = -1;
                            envelope3D = gridDatatype.readDataSlice(n2, n3, n4, n5);
                            if (envelope3D.getRank() == 3) {
                                envelope3D = envelope3D.reduce();
                            }
                            if (envelope3D.getRank() == 3) {
                                envelope3D = envelope3D.slice(0, 0);
                            }
                            this.numCols = envelope3D.getShape()[1];
                            this.numRows = envelope3D.getShape()[0];
                            GamaNetCDFFile.this.coverage = GamaNetCDFFile.matrixValue(iScope, (Array)envelope3D, this.numRows, this.numCols);
                        }
                    }
                }
                string = Envelope3D.of((double)projectionRect.getMinX(), (double)projectionRect.getMaxX(), (double)projectionRect.getMinY(), (double)projectionRect.getMaxY(), (double)0.0, (double)0.0);
                GamaNetCDFFile.this.computeProjection(iScope, (Envelope3D)string);
                envelope3D = GamaNetCDFFile.this.gis.getProjectedEnvelope();
                double d = envelope3D.getHeight() / (double)this.numRows;
                double d2 = envelope3D.getWidth() / (double)this.numCols;
                IList iList = GamaListFactory.create((IType)Types.GEOMETRY);
                double d3 = envelope3D.getMinX();
                double d4 = envelope3D.getMinY();
                double d5 = envelope3D.getMaxY();
                double d6 = envelope3D.getMaxX();
                iList.add((Object)new GamaPoint(d3, d4));
                iList.add((Object)new GamaPoint(d6, d4));
                iList.add((Object)new GamaPoint(d6, d5));
                iList.add((Object)new GamaPoint(d3, d5));
                iList.add((Object)((IShape)iList.get(0)));
                this.geom = GamaGeometryType.buildPolygon((List)iList);
                if (!bl) {
                    return;
                }
                try {
                    GamaPoint gamaPoint = new GamaPoint(0.0, 0.0);
                    double d7 = d2 / 2.0;
                    double d8 = d / 2.0;
                    int n = 0;
                    int n6 = this.numRows * this.numCols;
                    while (n < n6) {
                        iScope.getGui().getStatus().informStatus("" + (double)n / (double)n6, "status/status.simulation");
                        int n7 = n / this.numCols;
                        int n8 = n - n7 * this.numCols;
                        gamaPoint.x = d3 + (double)n8 * d2 + d7;
                        gamaPoint.y = d5 - ((double)n7 * d + d8);
                        GamaShape gamaShape = (GamaShape)GamaGeometryType.buildRectangle((double)d2, (double)d, (GamaPoint)gamaPoint);
                        double d9 = (Double)GamaNetCDFFile.this.coverage.get(iScope, n8, n7);
                        gamaShape = GamaNetCDFFile.this.gis == null ? GamaShapeFactory.createFrom((Geometry)gamaShape.getInnerGeometry()) : GamaShapeFactory.createFrom((Geometry)GamaNetCDFFile.this.gis.transform(gamaShape.getInnerGeometry()));
                        gamaShape.setAttribute("grid_value", (Object)d9);
                        gamaShape.setAttribute("bands", (Object)GamaListFactory.create((IScope)iScope, (IType)Types.FLOAT, (Object[])new Double[]{d9}));
                        GamaNetCDFFile.this.nbBands = 1;
                        ((IList)GamaNetCDFFile.this.getBuffer()).add((Object)gamaShape);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                iScope.getGui().getStatus().informStatus("Opening file " + GamaNetCDFFile.this.getName(iScope), "status/status.simulation");
            }
        }
    }
}

