/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.Tools;

public class PictureCache {
    private static Hashtable pictureCache = new Hashtable();
    public static Vector cacheLoadsInProgress = new Vector();
    private static Vector removalQueue = new Vector();
    private static int maxCache = 10;

    public static synchronized void removeLeastPopular() {
        String string;
        Tools.log("PictureCache.removeLeastPopular:");
        Enumeration<Object> enumeration = removalQueue.elements();
        while (enumeration.hasMoreElements() && pictureCache.size() >= maxCache) {
            string = (String)enumeration.nextElement();
            Tools.log("PictureCache.remove: " + string);
            pictureCache.remove(string);
            removalQueue.remove(string);
        }
        enumeration = pictureCache.keys();
        while (pictureCache.size() >= maxCache && enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Tools.log("PictureCache.remove: " + string);
            pictureCache.remove(string);
        }
        System.gc();
    }

    public static synchronized boolean isInCache(URL uRL) {
        return PictureCache.isInCache(uRL.toString());
    }

    public static synchronized boolean isInCache(String string) {
        return pictureCache.containsKey(string);
    }

    public static synchronized void add(URL uRL, SourcePicture sourcePicture) {
        Tools.log("PictureCache.add: " + uRL.toString());
        if (sourcePicture.getSourceBufferedImage() == null) {
            Tools.log("PictureCache.add: invoked with a null picture! Not cached!");
            return;
        }
        if (maxCache < 1) {
            Tools.log("PictureCache.add: cache is diabled. Not adding picture.");
            return;
        }
        if (PictureCache.isInCache(uRL)) {
            Tools.log("Picture " + uRL.toString() + " is already in the cache. Not adding again.");
            return;
        }
        if (pictureCache.size() >= maxCache) {
            PictureCache.removeLeastPopular();
        }
        if (pictureCache.size() < maxCache) {
            pictureCache.put(uRL.toString(), sourcePicture);
        }
    }

    public static synchronized void remove(String string) {
        if (PictureCache.isInCache(string)) {
            pictureCache.remove(string);
        }
    }

    public static synchronized SourcePicture getSourcePicture(URL uRL) {
        return (SourcePicture)pictureCache.get(uRL.toString());
    }

    public static void clear() {
        Tools.log("PictureCache.clear: Zapping entire cache");
        pictureCache.clear();
    }

    public static void reportCache() {
        Tools.log("   PictureCache.reportCache: cache contains: " + Integer.toString(pictureCache.size()) + " max: " + Integer.toString(maxCache));
        Enumeration enumeration = pictureCache.keys();
        while (enumeration.hasMoreElements()) {
            Tools.log("   Cache contains: " + (String)enumeration.nextElement());
        }
        Tools.log("  End of cache contents");
    }

    public static void stopBackgroundLoading() {
        Enumeration enumeration = cacheLoadsInProgress.elements();
        while (enumeration.hasMoreElements()) {
            ((SourcePicture)enumeration.nextElement()).stopLoading();
        }
    }

    public static boolean stopBackgroundLoadingExcept(URL uRL) {
        String string = uRL.toString();
        Enumeration enumeration = cacheLoadsInProgress.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            SourcePicture sourcePicture = (SourcePicture)enumeration.nextElement();
            if (!sourcePicture.getUrlString().equals(string)) {
                sourcePicture.stopLoading();
                continue;
            }
            Tools.log("PictureCache.stopBackgroundLoading: picture was already loading");
            bl = true;
        }
        return bl;
    }
}

