/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.image;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import ucar.nc2.ui.image.ScalablePicture;
import ucar.nc2.ui.image.ScalablePictureListener;
import ucar.nc2.ui.image.SourcePicture;
import ucar.nc2.ui.image.Tools;

class PicturePane
extends JComponent
implements ScalablePictureListener {
    private boolean scaleToFit = true;
    public ScalablePicture sclPic = new ScalablePicture();
    private boolean Dragging = false;
    private boolean centerWhenScaled;
    private Point focusPoint = new Point();
    private int last_x;
    private int last_y;
    private String legend = null;
    private Point infoPoint = new Point(15, 15);
    private int lineSpacing = 12;
    private Font infoFont = new Font("Arial", 0, 10);
    private boolean showInfo = false;
    private DecimalFormat twoDecimalFormatter = new DecimalFormat("###0.00");
    private boolean pictureViewerFastScale = true;
    private int maximumPictureSize = 5000;
    protected Vector picturePaneListeners = new Vector();

    public PicturePane() {
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.setDoubleBuffered(false);
        this.sclPic.addStatusListener(this);
        if (this.pictureViewerFastScale) {
            this.sclPic.setFastScale();
        } else {
            this.sclPic.setQualityScale();
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PicturePane.this.zoomToFit();
            }
        });
        this.setFont(this.infoFont);
    }

    public void setPicture(URL uRL, String string, double d) {
        this.legend = string;
        this.centerWhenScaled = true;
        this.sclPic.setScaleSize(this.getSize());
        this.sclPic.stopLoadingExcept(uRL);
        this.sclPic.loadAndScalePictureInThread(uRL, 10, d);
    }

    public void setBufferedImage(BufferedImage bufferedImage, String string) {
        this.legend = string;
        this.centerWhenScaled = true;
        Dimension dimension = this.getSize();
        this.sclPic.setScaleSize(dimension);
        SourcePicture sourcePicture = new SourcePicture();
        sourcePicture.setSourceBufferedImage(bufferedImage, string);
        this.sclPic.setSourcePicture(sourcePicture);
        if (!this.scaleToFit) {
            this.sclPic.setScaleFactor(1.0);
        }
        this.sclPic.scalePicture();
        this.repaint();
    }

    public void setDragging(boolean bl) {
        this.Dragging = bl;
    }

    public void zoomIn() {
        double d = this.sclPic.getScaleFactor();
        double d2 = d * 1.5;
        if (d < 1.0 && d2 > 1.0) {
            d2 = 1.0;
        }
        if ((double)this.sclPic.getOriginalWidth() * this.sclPic.getScaleFactor() < (double)this.maximumPictureSize && (double)this.sclPic.getOriginalHeight() * this.sclPic.getScaleFactor() < (double)this.maximumPictureSize) {
            this.sclPic.setScaleFactor(d2);
            this.sclPic.createScaledPictureInThread(10);
        }
    }

    public void zoomOut() {
        this.sclPic.setScaleFactor(this.sclPic.getScaleFactor() / 1.5);
        this.sclPic.createScaledPictureInThread(10);
    }

    public void zoomToFit() {
        this.sclPic.setScaleSize(this.getSize());
        if (this.sclPic.getStatusCode() == 11 || this.sclPic.getStatusCode() == 13) {
            this.sclPic.createScaledPictureInThread(10);
        }
    }

    public void centerImage() {
        if (this.sclPic.getOriginalImage() != null) {
            this.setCenterLocation(this.sclPic.getOriginalWidth() / 2, this.sclPic.getOriginalHeight() / 2);
            this.repaint();
        }
    }

    public void scrollUp() {
        if ((double)(this.sclPic.getOriginalHeight() - this.focusPoint.y) * this.sclPic.getScaleFactor() + (double)(this.getSize().height / 2) > (double)this.getSize().height) {
            this.focusPoint.y += (int)((double)this.getSize().height * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scrollup rejected because bottom of picture is already showing.");
        }
    }

    public void scrollDown() {
        if ((double)(this.getSize().height / 2) - (double)this.focusPoint.y * this.sclPic.getScaleFactor() < 0.0) {
            this.focusPoint.y -= (int)((double)this.getSize().height * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scroll down rejected because top edge is aready visible");
        }
    }

    public void scrollLeft() {
        if ((double)(this.sclPic.getOriginalWidth() - this.focusPoint.x) * this.sclPic.getScaleFactor() + (double)(this.getSize().width / 2) > (double)this.getSize().width) {
            this.focusPoint.x += (int)((double)this.getSize().width * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scrollup rejected because right edge of picture is already showing.");
        }
    }

    public void scrollRight() {
        if ((double)(this.getSize().width / 2) - (double)this.focusPoint.x * this.sclPic.getScaleFactor() < 0.0) {
            this.focusPoint.x -= (int)((double)this.getSize().width * 0.1 / this.sclPic.getScaleFactor());
            this.repaint();
        } else {
            Tools.log("Scroll left rejected because left edge is aready visible");
        }
    }

    public void setCenterLocation(int n, int n2) {
        Tools.log("setCenterLocation invoked with " + n + " x " + n2);
        this.focusPoint.setLocation(n, n2);
    }

    public void setScaleToFit(boolean bl) {
        this.scaleToFit = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Tools.log("paintComponent called");
        if (!this.Dragging) {
            this.setCursor(new Cursor(3));
        }
        if (this.sclPic.getScaledPicture() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n3 = (int)((double)(n / 2) - (double)this.focusPoint.x * this.sclPic.getScaleFactor());
            int n4 = (int)((double)(n2 / 2) - (double)this.focusPoint.y * this.sclPic.getScaleFactor());
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.drawRenderedImage(this.sclPic.getScaledPicture(), AffineTransform.getTranslateInstance(n3, n4));
            if (this.showInfo) {
                graphics2D.setColor(Color.white);
                graphics2D.drawString(this.legend, this.infoPoint.x, this.infoPoint.y);
                graphics2D.drawString("Size: " + Integer.toString(this.sclPic.getOriginalWidth()) + " x " + Integer.toString(this.sclPic.getOriginalHeight()) + " Mid: " + Integer.toString(this.focusPoint.x) + " x " + Integer.toString(this.focusPoint.y) + " Scale: " + this.twoDecimalFormatter.format(this.sclPic.getScaleFactor()), this.infoPoint.x, this.infoPoint.y + this.lineSpacing);
                graphics2D.drawString("File: " + this.sclPic.getFilename(), this.infoPoint.x, this.infoPoint.y + 2 * this.lineSpacing);
                graphics2D.drawString("Loaded in: " + this.twoDecimalFormatter.format((float)this.sclPic.getSourcePicture().loadTime / 1000.0f) + " Seconds", this.infoPoint.x, this.infoPoint.y + 3 * this.lineSpacing);
                graphics2D.drawString("Free memory: " + Long.toString(Runtime.getRuntime().freeMemory() / 1024L / 1024L, 0) + " MB", this.infoPoint.x, this.infoPoint.y + 4 * this.lineSpacing);
            }
        } else {
            graphics.setClip(0, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n, n2);
        }
        if (!this.Dragging) {
            this.setCursor(new Cursor(0));
        }
    }

    public void showInfoPanel() {
        this.showInfo = !this.showInfo;
        this.repaint();
    }

    @Override
    public void scalableStatusChange(int n, String string) {
        Tools.log("PicturePane.scalableStatusChange: got a status change: " + string);
        if (n == 13) {
            Tools.log("PicturePane.scalableStatusChange: a READY status");
            string = this.legend;
            if (this.centerWhenScaled) {
                Tools.log("PicturePane.scalableStatusChange: centering image");
                this.centerImage();
            }
            Tools.log("PicturePane.scalableStatusChange: forcing Panel repaint");
            this.repaint();
        }
        Enumeration enumeration = this.picturePaneListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ScalablePictureListener)enumeration.nextElement()).scalableStatusChange(n, string);
        }
    }

    @Override
    public void sourceLoadProgressNotification(int n, int n2) {
        Enumeration enumeration = this.picturePaneListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ScalablePictureListener)enumeration.nextElement()).sourceLoadProgressNotification(n, n2);
        }
    }

    public void addStatusListener(ScalablePictureListener scalablePictureListener) {
        this.picturePaneListeners.add(scalablePictureListener);
    }

    public void removeStatusListener(ScalablePictureListener scalablePictureListener) {
        this.picturePaneListeners.remove(scalablePictureListener);
    }

    public ScalablePicture getScalablePicture() {
        return this.sclPic;
    }

    class Listener
    extends MouseInputAdapter {
        Listener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                PicturePane.this.centerWhenScaled = false;
                PicturePane.this.zoomOut();
            }
            if (mouseEvent.getButton() == 2) {
                PicturePane.this.zoomToFit();
                PicturePane.this.centerWhenScaled = true;
            }
            if (mouseEvent.getButton() == 1) {
                int n = PicturePane.this.getSize().width;
                int n2 = PicturePane.this.getSize().height;
                int n3 = mouseEvent.getX() - n / 2;
                int n4 = mouseEvent.getY() - n2 / 2;
                PicturePane.this.setCenterLocation(PicturePane.this.focusPoint.x + (int)((double)n3 / PicturePane.this.sclPic.getScaleFactor()), PicturePane.this.focusPoint.y + (int)((double)n4 / PicturePane.this.sclPic.getScaleFactor()));
                PicturePane.this.centerWhenScaled = false;
                PicturePane.this.zoomIn();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (PicturePane.this.Dragging) {
                PicturePane.this.Dragging = false;
                PicturePane.this.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!PicturePane.this.Dragging) {
                PicturePane.this.last_x = mouseEvent.getX();
                PicturePane.this.last_y = mouseEvent.getY();
                PicturePane.this.Dragging = true;
                PicturePane.this.setCursor(new Cursor(13));
            } else {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                PicturePane.this.focusPoint.setLocation((int)((double)PicturePane.this.focusPoint.x + (double)(PicturePane.this.last_x - n) / PicturePane.this.sclPic.getScaleFactor()), (int)((double)PicturePane.this.focusPoint.y + (double)(PicturePane.this.last_y - n2) / PicturePane.this.sclPic.getScaleFactor()));
                PicturePane.this.last_x = n;
                PicturePane.this.last_y = n2;
                PicturePane.this.Dragging = true;
                PicturePane.this.repaint();
            }
            PicturePane.this.centerWhenScaled = false;
        }
    }
}

