/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.qrcode.operators;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.experimental.webcam.operators.WebcamOperators;
import gama.experimental.webcam.types.GamaWebcam;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;

public class Operators {
    private static IMatrix matrixValueFromImage(IScope iScope, BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = bufferedImage;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                gamaIntMatrix.set(iScope, n3, n4, (Object)bufferedImage2.getRGB(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return gamaIntMatrix;
    }

    @GamlAnnotations.operator(value={"encodeQR"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="encode a given message into a QR code with the given resolution (width, height) as matrix of bool")
    public static GamaMatrix encodeQRcode(IScope iScope, String string, int n, int n2) {
        GamaObjectMatrix gamaObjectMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = null;
        try {
            gamaObjectMatrix = new Hashtable(2);
            gamaObjectMatrix.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            bitMatrix = multiFormatWriter.encode(string, BarcodeFormat.QR_CODE, n, n2, gamaObjectMatrix);
        }
        catch (WriterException writerException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when encoding the message \"" + string + "\": " + writerException.getMessage()), (IScope)iScope), (boolean)true);
        }
        gamaObjectMatrix = new GamaObjectMatrix(n, n2, (IType)Types.BOOL);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n) {
                gamaObjectMatrix.set(iScope, n3, n4, (Object)bitMatrix.get(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return gamaObjectMatrix;
    }

    @GamlAnnotations.operator(value={"decodeQR"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="decode a QR code from a photoshot with the given resolution (width, height) in pixels from the given webcam - autoclose or not the webcam after")
    public static String decodeQRcode(IScope iScope, GamaWebcam gamaWebcam, GamaPair<Integer, Integer> gamaPair, boolean bl) {
        BufferedImage bufferedImage = WebcamOperators.CamShotAct((IScope)iScope, (GamaWebcam)gamaWebcam, gamaPair, (boolean)false, (boolean)false, (boolean)bl);
        if (bufferedImage == null) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)"Could not decode the image", (IScope)iScope), (boolean)true);
        }
        BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)bufferedImageLuminanceSource));
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        String string = "";
        try {
            EnumMap<DecodeHintType, Serializable> enumMap = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
            enumMap.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            enumMap.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
            enumMap.put(DecodeHintType.PURE_BARCODE, Boolean.FALSE);
            Result result = multiFormatReader.decode(binaryBitmap);
            string = String.valueOf(result.getText());
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        catch (Exception exception) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("BarCodeUtil.decode Excpt err - " + exception.toString() + " - " + exception.getMessage()), (IScope)iScope), (boolean)true);
        }
        return string;
    }

    @GamlAnnotations.operator(value={"decodeQR"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="decode a QR code from a photoshot from the given webcam - autoclose or not the webcam after")
    public static String decodeQRcode(IScope iScope, GamaWebcam gamaWebcam, boolean bl) {
        return Operators.decodeQRcode(iScope, gamaWebcam, null, bl);
    }

    @GamlAnnotations.operator(value={"decodeQRFile"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="decode the QR code from an image file")
    public static String decodeQRcodeFile(IScope iScope, String string) {
        return (String)Operators.decodeQRcodeFile(iScope, string, false).keySet().stream().findFirst().get();
    }

    @GamlAnnotations.operator(value={"decodeMultiQRFile"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="decode multiple QR code from an image file")
    public static Map<String, GamaShape> decodeMultiQRcodeFile(IScope iScope, String string) {
        return Operators.decodeQRcodeFile(iScope, string, true);
    }

    public static GamaShape toShape(IScope iScope, Result result) {
        ResultPoint resultPoint;
        ResultPoint[] resultPointArray = result.getResultPoints();
        IList iList = GamaListFactory.create();
        ResultPoint[] resultPointArray2 = resultPointArray;
        int n = resultPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            resultPoint = resultPointArray2[n2];
            iList.add((Object)new GamaPoint((double)resultPoint.getX(), (double)resultPoint.getY()));
            ++n2;
        }
        resultPoint = (GamaShape)SpatialCreation.polygon((IScope)iScope, (IContainer)iList);
        return resultPoint;
    }

    public static Map<String, GamaShape> decodeQRcodeFile(IScope iScope, String string, boolean bl) {
        String string2 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)string, (boolean)true);
        File file = new File(string2);
        if (file == null || file.getName().trim().isEmpty()) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        if (bufferedImage == null) {
            GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("Problem when reading file " + string), (IScope)iScope), (boolean)true);
        }
        BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)bufferedImageLuminanceSource));
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        IMap iMap = GamaMapFactory.create();
        if (bl) {
            GenericMultipleBarcodeReader genericMultipleBarcodeReader = new GenericMultipleBarcodeReader((Reader)multiFormatReader);
            try {
                Result[] resultArray = genericMultipleBarcodeReader.decodeMultiple(binaryBitmap);
                int n = resultArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Result result = resultArray[n2];
                    iMap.put(result.getText(), Operators.toShape(iScope, result));
                    ++n2;
                }
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
            catch (Error error) {
                GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("BarCodeUtil.decode Excpt err - " + error.toString() + " - " + error.getMessage()), (IScope)iScope), (boolean)true);
            }
        } else {
            try {
                Result result = multiFormatReader.decode(binaryBitmap);
                iMap.put(result.getText(), Operators.toShape(iScope, result));
            }
            catch (NotFoundException notFoundException) {
                return null;
            }
            catch (Error error) {
                GAMA.reportError((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.error((String)("BarCodeUtil.decode Excpt err - " + error.toString() + " - " + error.getMessage()), (IScope)iScope), (boolean)true);
            }
        }
        return iMap;
    }
}

