/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.switchproject.gaml.skills.scheduling;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.GamaMap;
import gama.experimental.switchproject.gaml.architecure.event_manager.EventManagerArchitecture;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.skills.Skill;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="event_manager", type=11, doc={@GamlAnnotations.doc(value="The event manager, must be defined in another species with \"control: event_manager\"")}), @GamlAnnotations.variable(name="event_date", type=23, doc={@GamlAnnotations.doc(value="The date of the previous event")}), @GamlAnnotations.variable(name="refer_to", type=11, doc={@GamlAnnotations.doc(value="The agent to refer when the event is triggered")})})
@GamlAnnotations.skill(name="scheduling", concept={"scheduling", "skill"}, internal=true)
public class SchedulingSkill
extends Skill {
    @GamlAnnotations.setter(value="event_manager")
    public void setEventManager(IAgent iAgent, IAgent iAgent2) {
        if (iAgent == null || iAgent2 == null) {
            return;
        }
        iAgent.setAttribute("event_manager", (Object)iAgent2);
    }

    @GamlAnnotations.getter(value="event_manager")
    public IAgent getEventManager(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (IAgent)iAgent.getAttribute("event_manager");
    }

    @GamlAnnotations.getter(value="event_date")
    public GamaDate getAt(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (GamaDate)iAgent.getAttribute("event_date");
    }

    @GamlAnnotations.getter(value="refer_to")
    public IAgent getReferTo(IAgent iAgent) {
        if (iAgent == null) {
            return null;
        }
        return (IAgent)iAgent.getAttribute("refer_to");
    }

    @GamlAnnotations.action(name="later", args={@GamlAnnotations.arg(name="the_action", type=4, optional=false, doc={@GamlAnnotations.doc(value="The name of an action or a primitive")}), @GamlAnnotations.arg(name="with_arguments", type=10, optional=true, doc={@GamlAnnotations.doc(value="A map expression containing the parameters of the action")}), @GamlAnnotations.arg(name="at", type=23, optional=true, doc={@GamlAnnotations.doc(value="Call date")}), @GamlAnnotations.arg(name="refer_to", type=11, optional=true, doc={@GamlAnnotations.doc(value="The agent to refer")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do later execute: my_action arguments: map((\"test\"::2)) date: starting_date")}, value="Do action when the date is reached.")})
    public String register(IScope iScope) throws GamaRuntimeException {
        GamaDate gamaDate = (GamaDate)iScope.getArg("at", 23);
        IAgent iAgent = iScope.getAgent();
        GamaMap gamaMap = (GamaMap)iScope.getArg("with_arguments", 10);
        IAgent iAgent2 = (IAgent)iScope.getArg("refer_to", 11);
        String string = (String)iScope.getArg("the_action", 4);
        ActionDescription actionDescription = iAgent2 == null ? iAgent.getSpecies().getDescription().getAction(string) : iAgent2.getSpecies().getDescription().getAction(string);
        IAgent iAgent3 = (IAgent)iScope.getAgent().getAttribute("event_manager");
        if (iAgent3 == null) {
            throw GamaRuntimeException.error((String)"The manager must be defined if you have to use the action \"later\"", (IScope)iScope);
        }
        EventManagerArchitecture eventManagerArchitecture = (EventManagerArchitecture)iAgent3.getSpecies().getArchitecture();
        if (eventManagerArchitecture == null) {
            throw GamaRuntimeException.error((String)"The manager must use the control \"event_manager\" to execute the action \"later\"", (IScope)iScope);
        }
        return eventManagerArchitecture.register(iScope, iAgent, actionDescription, (GamaMap<String, Object>)gamaMap, gamaDate, iAgent2);
    }

    @GamlAnnotations.action(name="kill_event", args={@GamlAnnotations.arg(name="id", type=4, optional=false, doc={@GamlAnnotations.doc(value="The event ID")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do kill_event(\"123e4567-e89b-12d3-a456-426655440000\")")}, value="Kill event.")})
    public Object kill(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)iScope.getAgent().getAttribute("event_manager");
        String string = (String)iScope.getArg("id", 4);
        if (iAgent == null) {
            throw GamaRuntimeException.error((String)"The manager must be defined if you have to use the action \"later\"", (IScope)iScope);
        }
        EventManagerArchitecture eventManagerArchitecture = (EventManagerArchitecture)iAgent.getSpecies().getArchitecture();
        if (eventManagerArchitecture == null) {
            throw GamaRuntimeException.error((String)"The manager must use the control \"event_manager\" to execute the action \"later\"", (IScope)iScope);
        }
        return eventManagerArchitecture.kill(iScope, string);
    }
}

