/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.weka.algorithms;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Statistics;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class CHAID
extends Classifier
implements OptionHandler {
    private boolean m_binarySplits = false;
    private double split = 0.05;
    private CHAID[] m_Successors;
    private Instances originalData;
    private Attribute m_Attribute;
    private double m_ClassValue;
    private double[] m_Distribution;
    private Attribute m_ClassAttribute;
    private Attribute af;
    private double[] indexFTest;

    public String globalInfo() {
        return "CHAID ";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        vector.addElement(new Option("\tSplit point.\n\t(default 0.05)", "S", 1, "-S <spit point>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption((char)'S', (String[])stringArray);
        this.split = string.length() != 0 ? Double.parseDouble(string) : 0.05;
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.split;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the trees.";
    }

    public void setBinarySplits(boolean bl) {
        this.m_binarySplits = bl;
    }

    public double getSplitPoint() {
        return this.split;
    }

    public String splitTipText() {
        return "split point.";
    }

    public void setSplitPoint(double d) {
        this.split = d;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("CHAID: nominal class, please.");
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            if (!((Instance)enumeration.nextElement()).hasMissingValue()) continue;
            throw new NoSupportForMissingValuesException("CHAID: no missing values, please.");
        }
        this.originalData = new Instances(instances);
        instances = new Instances(instances);
        this.makeTree(instances);
    }

    private void setAttributeFather(Attribute attribute) {
        this.af = attribute;
    }

    private void setOriginalData(Instances instances) {
        this.originalData = instances;
    }

    private void makeTree(Instances instances) throws Exception {
        Object object;
        if (instances.numInstances() == 0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[instances.numClasses()];
            return;
        }
        if (instances.numAttributes() == 1) {
            instances.insertAttributeAt(this.af, 0);
        }
        double[] dArray = new double[instances.numAttributes() - 1];
        this.indexFTest = new double[instances.numAttributes() - 1];
        int n = 0;
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements() && n < instances.numAttributes() - 1) {
            ++n;
            object = (Attribute)enumeration.nextElement();
            dArray[object.index()] = object.isNominal() ? this.computeFChi(instances, (Attribute)object, 0.0) : this.computeFChiNumeric(instances, (Attribute)object);
        }
        this.m_Attribute = instances.attribute(Utils.minIndex((double[])dArray));
        if (this.split != 0.0 && dArray[this.m_Attribute.index()] > this.split || dArray[this.m_Attribute.index()] == 0.0 || dArray[this.m_Attribute.index()] == 1.0) {
            this.m_Attribute = null;
            this.m_Distribution = new double[instances.numClasses()];
            object = instances.enumerateInstances();
            while (object.hasMoreElements()) {
                Instance instance = (Instance)object.nextElement();
                int n2 = (int)instance.classValue();
                this.m_Distribution[n2] = this.m_Distribution[n2] + 1.0;
            }
            Utils.normalize((double[])this.m_Distribution);
            this.m_ClassValue = Utils.maxIndex((double[])this.m_Distribution);
            this.m_ClassAttribute = instances.classAttribute();
        } else {
            if (this.m_Attribute.isNominal()) {
                object = this.splitData(instances, this.m_Attribute);
                this.m_Successors = new CHAID[this.m_Attribute.numValues()];
            } else {
                object = this.splitNumeric(instances, this.m_Attribute, this.indexFTest[this.m_Attribute.index()]);
                this.m_Successors = new CHAID[2];
            }
            int n3 = 0;
            while (n3 < this.m_Successors.length) {
                this.m_Successors[n3] = new CHAID();
                this.m_Successors[n3].setAttributeFather(this.m_Attribute);
                this.m_Successors[n3].setOriginalData(this.originalData);
                this.m_Successors[n3].setSplitPoint(this.split);
                object[n3].deleteAttributeAt(this.m_Attribute.index());
                this.m_Successors[n3].makeTree((Instances)object[n3]);
                ++n3;
            }
        }
    }

    private double computeFChi(Instances instances, Attribute attribute, double d) throws Exception {
        int n;
        int n2;
        int[][] nArray;
        Instances[] instancesArray;
        if (attribute.isNominal()) {
            instancesArray = this.splitData(instances, attribute);
            nArray = new int[instances.numClasses() + 1][attribute.numValues() + 1];
        } else {
            instancesArray = this.splitNumeric(instances, attribute, d);
            nArray = new int[instances.numClasses() + 1][3];
        }
        int n3 = 0;
        while (n3 < instancesArray.length) {
            int[] nArray2 = this.countInstances(instancesArray[n3]);
            n2 = 0;
            while (n2 < instances.numClasses()) {
                nArray[n2][n3] = nArray2[n2];
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray.length - 1) {
            int n4 = 0;
            while (n4 < nArray[0].length - 1) {
                int[] nArray3 = nArray[n3];
                int n5 = nArray[0].length - 1;
                nArray3[n5] = nArray3[n5] + nArray[n3][n4];
                int[] nArray4 = nArray[instances.numClasses()];
                int n6 = n4;
                nArray4[n6] = nArray4[n6] + nArray[n3][n4];
                ++n4;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray.length - 1) {
            if (nArray[n3][nArray[0].length - 1] == instances.numInstances()) {
                return 0.0;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < nArray.length - 1) {
            int[] nArray5 = nArray[instances.numClasses()];
            int n7 = nArray[0].length - 1;
            nArray5[n7] = nArray5[n7] + nArray[n3][nArray[0].length - 1];
            ++n3;
        }
        double[][] dArray = new double[instances.numClasses() + 1][nArray[0].length - 1 + 1];
        int n8 = 0;
        while (n8 < nArray.length - 1) {
            n2 = 0;
            while (n2 < nArray[0].length - 1) {
                if (nArray[instances.numClasses()][nArray[0].length - 1] != 0) {
                    dArray[n8][n2] = ((double)nArray[n8][nArray[0].length - 1] + 0.0) * (double)nArray[instances.numClasses()][n2] / (double)nArray[instances.numClasses()][nArray[0].length - 1];
                }
                ++n2;
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < nArray.length - 1) {
            n2 = 0;
            while (n2 < nArray[0].length - 1) {
                double[] dArray2 = dArray[n8];
                int n9 = nArray[0].length - 1;
                dArray2[n9] = dArray2[n9] + dArray[n8][n2];
                double[] dArray3 = dArray[instances.numClasses()];
                int n10 = n2;
                dArray3[n10] = dArray3[n10] + dArray[n8][n2];
                ++n2;
            }
            ++n8;
        }
        n8 = 0;
        while (n8 < nArray.length - 1) {
            double[] dArray4 = dArray[instances.numClasses()];
            int n11 = nArray[0].length - 1;
            dArray4[n11] = dArray4[n11] + dArray[n8][nArray[0].length - 1];
            ++n8;
        }
        double[][] dArray5 = new double[instances.numClasses() + 1][nArray[0].length - 1 + 1];
        n2 = 0;
        while (n2 < nArray.length - 1) {
            n = 0;
            while (n < nArray[0].length - 1) {
                if (dArray[n2][n] != 0.0) {
                    dArray5[n2][n] = Math.pow((double)nArray[n2][n] - dArray[n2][n], 2.0) / dArray[n2][n];
                }
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length - 1) {
            n = 0;
            while (n < nArray[0].length - 1) {
                double[] dArray6 = dArray5[n2];
                int n12 = nArray[0].length - 1;
                dArray6[n12] = dArray6[n12] + dArray5[n2][n];
                double[] dArray7 = dArray5[instances.numClasses()];
                int n13 = n;
                dArray7[n13] = dArray7[n13] + dArray5[n2][n];
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length - 1) {
            double[] dArray8 = dArray5[instances.numClasses()];
            int n14 = nArray[0].length - 1;
            dArray8[n14] = dArray8[n14] + dArray5[n2][nArray[0].length - 1];
            ++n2;
        }
        double d2 = Statistics.chiSquaredProbability((double)dArray5[instances.numClasses()][nArray[0].length - 1], (double)(nArray[0].length - 1 - 1));
        return d2;
    }

    private Instances[] splitData(Instances instances, Attribute attribute) {
        Instances[] instancesArray = new Instances[attribute.numValues()];
        int[] nArray = new int[attribute.numValues()];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n = (int)instance.value(attribute);
            nArray[n] = nArray[n] + 1;
        }
        int n = 0;
        while (n < attribute.numValues()) {
            instancesArray[n] = new Instances(instances, nArray[n]);
            ++n;
        }
        Enumeration enumeration2 = instances.enumerateInstances();
        while (enumeration2.hasMoreElements()) {
            Instance instance = (Instance)enumeration2.nextElement();
            instancesArray[(int)instance.value(attribute)].add(instance);
        }
        int n2 = 0;
        while (n2 < instancesArray.length) {
            instancesArray[n2].compactify();
            ++n2;
        }
        return instancesArray;
    }

    private int[] countInstances(Instances instances) throws Exception {
        int[] nArray = new int[instances.numClasses()];
        int n = 0;
        while (n < instances.numClasses()) {
            nArray[n] = 0;
            ++n;
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n2 = (int)instance.classValue();
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel((Classifier)new CHAID(), (String[])stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public double classifyInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("CHAID: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_ClassValue;
        }
        Attribute attribute = this.originalData.attribute(this.m_Attribute.name());
        if (this.m_Attribute.isNominal()) {
            return this.m_Successors[(int)instance.value(attribute)].classifyInstance(instance);
        }
        if (instance.value(this.m_Attribute) <= this.indexFTest[this.m_Attribute.index()]) {
            return this.m_Successors[0].classifyInstance(instance);
        }
        return this.m_Successors[1].classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException("CHAID: no missing values, please.");
        }
        if (this.m_Attribute == null) {
            return this.m_Distribution;
        }
        Attribute attribute = this.originalData.attribute(this.m_Attribute.name());
        if (this.m_Attribute.isNominal()) {
            return this.m_Successors[(int)instance.value(attribute)].distributionForInstance(instance);
        }
        if (instance.value(this.m_Attribute) <= this.indexFTest[this.m_Attribute.index()]) {
            return this.m_Successors[0].distributionForInstance(instance);
        }
        return this.m_Successors[1].distributionForInstance(instance);
    }

    private String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue((double)this.m_ClassValue)) {
                stringBuffer.append(": null");
            } else {
                stringBuffer.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
        } else if (this.m_Attribute.isNominal()) {
            int n2 = 0;
            while (n2 < this.m_Attribute.numValues()) {
                stringBuffer.append("\n");
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("|  ");
                    ++n3;
                }
                stringBuffer.append(this.m_Attribute.name() + " = " + this.m_Attribute.value(n2));
                stringBuffer.append(this.m_Successors[n2].toString(n + 1));
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < 2) {
                stringBuffer.append("\n");
                int n5 = 0;
                while (n5 < n) {
                    stringBuffer.append("| ");
                    ++n5;
                }
                if (n4 == 0) {
                    stringBuffer.append(this.m_Attribute.name() + " <= " + this.indexFTest[this.m_Attribute.index()]);
                } else {
                    stringBuffer.append(this.m_Attribute.name() + " > " + this.indexFTest[this.m_Attribute.index()]);
                }
                stringBuffer.append(this.m_Successors[n4].toString(n + 1));
                ++n4;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return "CHAID: No model built yet.";
        }
        return "CHAID\n\n" + this.toString(0);
    }

    public double computeFChiNumeric(Instances instances, Attribute attribute) throws Exception {
        double d;
        instances.sort(attribute);
        Instance instance = instances.instance(0);
        double d2 = d = instance.value(attribute);
        double d3 = this.computeFChi(instances, attribute, d);
        this.indexFTest[attribute.index()] = d;
        int n = 1;
        while (n < instances.numInstances()) {
            instance = instances.instance(n);
            d = instance.value(attribute);
            if (d != d2) {
                double d4 = this.computeFChi(instances, attribute, d);
                if (d4 < d3) {
                    d3 = d4;
                    this.indexFTest[attribute.index()] = d;
                }
                d2 = d;
            }
            ++n;
        }
        return d3;
    }

    public Instances[] splitNumeric(Instances instances, Attribute attribute, double d) {
        Object object;
        Instances[] instancesArray = new Instances[2];
        int n = 0;
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            object = (Instance)enumeration.nextElement();
            double d2 = object.value(attribute);
            if (!(d2 <= d)) continue;
            ++n;
        }
        instancesArray[0] = new Instances(instances, n);
        instancesArray[1] = new Instances(instances, instances.numInstances() - n);
        object = instances.enumerateInstances();
        while (object.hasMoreElements()) {
            Instance instance = (Instance)object.nextElement();
            double d3 = instance.value(attribute);
            if (d3 <= d) {
                instancesArray[0].add(instance);
                continue;
            }
            instancesArray[1].add(instance);
        }
        return instancesArray;
    }
}

