/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.weka.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.experimental.weka.operators.InstanceManagement;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import weka.clusterers.Clusterer;
import weka.clusterers.Cobweb;
import weka.clusterers.DBSCAN;
import weka.clusterers.EM;
import weka.clusterers.FarthestFirst;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.XMeans;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.ManhattanDataObject;
import weka.core.ChebyshevDistance;
import weka.core.DistanceFunction;
import weka.core.EditDistance;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ManhattanDistance;

public class Clustering {
    private static IList<IList<IAgent>> clusteringUsingWeka(IScope iScope, Clusterer clusterer, IList<String> iList, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer) throws GamaRuntimeException {
        Instances instances = InstanceManagement.convertToInstances(iScope, null, iList, null, iAddressableContainer.listValue(iScope, Types.AGENT, false));
        try {
            clusterer.buildClusterer(instances);
            IList iList2 = GamaListFactory.create((IType)Types.LIST.of(Types.AGENT));
            int n = 0;
            while (n < clusterer.numberOfClusters()) {
                iList2.add((Object)GamaListFactory.create((IType)Types.AGENT));
                ++n;
            }
            n = 0;
            while (n < instances.numInstances()) {
                Instance instance = instances.instance(n);
                int n2 = -1;
                n2 = clusterer.clusterInstance(instance);
                IList iList3 = (IList)iList2.get(n2);
                iList3.add((Object)((IAgent)iAddressableContainer.get(iScope, (Object)n)));
                ++n;
            }
            return iList2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GamlAnnotations.operator(value={"clustering_xmeans"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by X-Means Algorithm based on the given attributes. Some paremeters can be defined: bin_value: value given for true value of boolean attributes; cut_off_factor: the cut-off factor to use;distance_f: The distance function to use. 4 possible distance functions: euclidean (by default) ; 'chebyshev', 'manhattan' or 'levenshtein'; max_iterations: the maximum number of iterations to perform; max_kmeans: the maximum number of iterations to perform in KMeans; max_kmeans_for_children: the maximum number of iterations KMeans that is performed on the child centers;max_num_clusters: the maximum number of clusters; min_num_clusters: the minimal number of clusters", examples={@GamlAnnotations.example(value="clustering_xmeans([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\", \"is_male\"],[\"bin_value\"::1.0, \"distance_f\"::\"manhattan\", \"max_num_clusters\"::10, \"min_num_clusters\"::2])", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_simple_kmeans", "clustering_em", "clustering_farthestFirst", "clustering_DBScan", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringXMeans(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) throws GamaRuntimeException {
        Object object;
        XMeans xMeans = new XMeans();
        xMeans.setSeed(Cast.asInt((IScope)iScope, (Object)iScope.getRandom().getSeed()).intValue());
        if (iMap != null) {
            if (iMap.containsKey((Object)"bin_value")) {
                xMeans.setBinValue(Cast.asFloat((IScope)iScope, (Object)iMap.get((Object)"bin_value")).doubleValue());
            }
            if (iMap.containsKey((Object)"cut_off_factor")) {
                xMeans.setCutOffFactor(Cast.asFloat((IScope)iScope, (Object)iMap.get((Object)"cut_off_factor")).doubleValue());
            }
            if (iMap.containsKey((Object)"distance_f")) {
                object = Cast.asString((IScope)iScope, (Object)iMap.get((Object)"distance_f"));
                if (((String)object).equals("chebyshev")) {
                    xMeans.setDistanceF((DistanceFunction)new ChebyshevDistance());
                } else if (((String)object).equals("manhattan")) {
                    xMeans.setDistanceF((DistanceFunction)new ManhattanDistance());
                } else if (((String)object).equals("levenshtein")) {
                    xMeans.setDistanceF((DistanceFunction)new EditDistance());
                }
            }
            if (iMap.containsKey((Object)"max_iterations")) {
                try {
                    xMeans.setMaxIterations(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_iterations")).intValue());
                }
                catch (Exception exception) {}
            }
            if (iMap.containsKey((Object)"max_kmeans")) {
                xMeans.setMaxKMeans(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_kmeans")).intValue());
            }
            if (iMap.containsKey((Object)"max_kmeans_for_children")) {
                xMeans.setMaxKMeansForChildren(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_kmeans_for_children")).intValue());
            }
            if (iMap.containsKey((Object)"max_num_clusters")) {
                xMeans.setMaxNumClusters(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_num_clusters")).intValue());
            }
            if (iMap.containsKey((Object)"min_num_clusters")) {
                xMeans.setMinNumClusters(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"min_num_clusters")).intValue());
            }
        }
        object = Clustering.clusteringUsingWeka(iScope, (Clusterer)xMeans, iList, iAddressableContainer);
        return object;
    }

    @GamlAnnotations.operator(value={"clustering_simple_kmeans"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by K-Means Algorithm based on the given attributes. Some paremeters can be defined: distance_f: The distance function to use. 4 possible distance functions: euclidean (by default) ; 'chebyshev', 'manhattan' or 'levenshtein'; dont_replace_missing_values: if false, replace missing values globally with mean/mode; max_iterations: the maximum number of iterations to perform;num_clusters: the number of clusters", examples={@GamlAnnotations.example(value="clustering_simple_kmeans([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\"],[\"distance_f\"::\"manhattan\", \"num_clusters\"::3])", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_xmeans", "clustering_em", "clustering_farthestFirst", "clustering_DBScan", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringSimpleKMeans(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) {
        Object object;
        SimpleKMeans simpleKMeans = new SimpleKMeans();
        simpleKMeans.setSeed(Cast.asInt((IScope)iScope, (Object)iScope.getRandom().getSeed()).intValue());
        if (iMap != null) {
            try {
                if (iMap.containsKey((Object)"distance_f")) {
                    object = Cast.asString((IScope)iScope, (Object)iMap.get((Object)"distance_f"));
                    if (((String)object).equals("chebyshev")) {
                        simpleKMeans.setDistanceFunction((DistanceFunction)new ChebyshevDistance());
                    } else if (((String)object).equals("manhattan")) {
                        simpleKMeans.setDistanceFunction((DistanceFunction)new ManhattanDistance());
                    } else if (((String)object).equals("levenshtein")) {
                        simpleKMeans.setDistanceFunction((DistanceFunction)new EditDistance());
                    }
                }
                if (iMap.containsKey((Object)"dont_replace_missing_values")) {
                    simpleKMeans.setDontReplaceMissingValues(Cast.asBool((IScope)iScope, (Object)iMap.get((Object)"dont_replace_missing_values")).booleanValue());
                }
                if (iMap.containsKey((Object)"max_iterations")) {
                    simpleKMeans.setMaxIterations(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_iterations")).intValue());
                }
                if (iMap.containsKey((Object)"num_clusters")) {
                    simpleKMeans.setNumClusters(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"num_clusters")).intValue());
                }
            }
            catch (Exception exception) {}
        }
        object = Clustering.clusteringUsingWeka(iScope, (Clusterer)simpleKMeans, iList, iAddressableContainer);
        return object;
    }

    @GamlAnnotations.operator(value={"clustering_em"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by EM Algorithm based on the given attributes. Some paremeters can be defined: max_iterations: the maximum number of iterations to perform;num_clusters: the number of clusters; minStdDev: minimum allowable standard deviation", examples={@GamlAnnotations.example(value="clustering_em([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\"],[\"max_iterations\"::10, \"num_clusters\"::3])", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_xmeans", "clustering_simple_kmeans", "clustering_farthestFirst", "clustering_DBScan", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringEM(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) {
        EM eM = new EM();
        eM.setSeed(Cast.asInt((IScope)iScope, (Object)iScope.getRandom().getSeed()).intValue());
        if (iMap != null) {
            try {
                if (iMap.containsKey((Object)"max_iterations")) {
                    eM.setMaxIterations(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"max_iterations")).intValue());
                }
                if (iMap.containsKey((Object)"num_clusters")) {
                    eM.setNumClusters(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"num_clusters")).intValue());
                }
                if (iMap.containsKey((Object)"minStdDev")) {
                    eM.setMinStdDev(Cast.asFloat((IScope)iScope, (Object)iMap.get((Object)"minStdDev")).doubleValue());
                }
            }
            catch (Exception exception) {}
        }
        IList<IList<IAgent>> iList2 = Clustering.clusteringUsingWeka(iScope, (Clusterer)eM, iList, iAddressableContainer);
        return iList2;
    }

    @GamlAnnotations.operator(value={"clustering_farthestFirst"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by Farthest First Algorithm based on the given attributes. Some paremeters can be defined: num_clusters: the number of clusters", examples={@GamlAnnotations.example(value="clustering_farthestFirst([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\"],[\"num_clusters\"::3])", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_xmeans", "clustering_simple_kmeans", "clustering_em", "clustering_DBScan", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringFarthestFirst(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) {
        FarthestFirst farthestFirst = new FarthestFirst();
        farthestFirst.setSeed(Cast.asInt((IScope)iScope, (Object)iScope.getRandom().getSeed()).intValue());
        if (iMap != null) {
            try {
                if (iMap.containsKey((Object)"num_clusters")) {
                    farthestFirst.setNumClusters(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"num_clusters")).intValue());
                }
            }
            catch (Exception exception) {}
        }
        IList<IList<IAgent>> iList2 = Clustering.clusteringUsingWeka(iScope, (Clusterer)farthestFirst, iList, iAddressableContainer);
        return iList2;
    }

    @GamlAnnotations.operator(value={"clustering_DBScan"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clustered by DBScan Algorithm based on the given attributes. Some paremeters can be defined: distance_f: The distance function to use for instances comparison (euclidean or manhattan); min_points: minimun number of DataObjects required in an epsilon-range-queryepsilon: epsilon -- radius of the epsilon-range-queries", examples={@GamlAnnotations.example(value="clustering_DBScan([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\"],[\"distance_f\"::\"manhattan\"])", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_xmeans", "clustering_em", "clustering_farthestFirst", "clustering_simple_kmeans", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringDBScan(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) {
        Object object;
        DBSCAN dBSCAN = new DBSCAN();
        if (iMap != null) {
            try {
                if (iMap.containsKey((Object)"distance_f")) {
                    object = Cast.asString((IScope)iScope, (Object)iMap.get((Object)"distance_f"));
                    if (((String)object).equals("manhattan")) {
                        dBSCAN.setDatabase_distanceType(ManhattanDataObject.class.getName());
                    } else {
                        dBSCAN.setDatabase_distanceType(EuclideanDistance.class.getName());
                    }
                }
                if (iMap.containsKey((Object)"min_points")) {
                    dBSCAN.setMinPoints(Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"min_points")).intValue());
                }
                if (iMap.containsKey((Object)"epsilon")) {
                    dBSCAN.setEpsilon((double)Cast.asInt((IScope)iScope, (Object)iMap.get((Object)"epsilon")).intValue());
                }
            }
            catch (Exception exception) {}
        }
        object = Clustering.clusteringUsingWeka(iScope, (Clusterer)dBSCAN, iList, iAddressableContainer);
        return object;
    }

    @GamlAnnotations.operator(value={"clustering_cobweb"}, content_type=5, category={"Statistical operators"}, concept={"statistic"})
    @GamlAnnotations.doc(value="A list of agent groups clusteredby CobWeb Algorithm based on the given attributes. Some paremeters can be defined: acuity: minimum standard deviation for numeric attributes; cutoff: category utility threshold by which to prune nodes seed", examples={@GamlAnnotations.example(value="clustering_cobweb([ag1, ag2, ag3, ag4, ag5],[\"size\",\"age\", \"weight\"],[\"acuity\"::3.0, \"cutoff\"::0.5)", equals="for example, can return [[ag1, ag3], [ag2], [ag4, ag5]]", isExecutable=false)}, see={"clustering_xmeans", "clustering_em", "clustering_farthestFirst", "clustering_simple_kmeans", "clustering_cobweb"})
    public static IList<IList<IAgent>> primClusteringCobweb(IScope iScope, IAddressableContainer<Integer, IAgent, Integer, IAgent> iAddressableContainer, IList<String> iList, IMap<String, Object> iMap) {
        Cobweb cobweb = new Cobweb();
        cobweb.setSeed(Cast.asInt((IScope)iScope, (Object)iScope.getRandom().getSeed()).intValue());
        if (iMap != null) {
            try {
                if (iMap.containsKey((Object)"acuity")) {
                    cobweb.setAcuity(Cast.asFloat((IScope)iScope, (Object)iMap.get((Object)"acuity")).doubleValue());
                }
                if (iMap.containsKey((Object)"cutoff")) {
                    cobweb.setCutoff(Cast.asFloat((IScope)iScope, (Object)iMap.get((Object)"cutoff")).doubleValue());
                }
            }
            catch (Exception exception) {}
        }
        IList<IList<IAgent>> iList2 = Clustering.clusteringUsingWeka(iScope, (Clusterer)cobweb, iList, iAddressableContainer);
        return iList2;
    }
}

