/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.editor;

import gama.core.kernel.model.IModel;
import gama.core.runtime.GAMA;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.interfaces.INamed;
import gama.ui.diagram.editor.GamaDiagramBehavior;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EActionLink;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EExperiment;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.ELayer;
import gama.ui.diagram.metamodel.ELayerAspect;
import gama.ui.diagram.metamodel.EMonitor;
import gama.ui.diagram.metamodel.EParameter;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.ESubSpeciesLink;
import gama.ui.diagram.metamodel.EVariable;
import gama.ui.shared.resources.IGamaColors;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.Statement;
import gaml.compiler.gaml.impl.ArgumentDefinitionImpl;
import gaml.compiler.gaml.impl.BlockImpl;
import gaml.compiler.gaml.impl.FacetImpl;
import gaml.compiler.gaml.impl.S_ActionImpl;
import gaml.compiler.gaml.impl.S_DefinitionImpl;
import gaml.compiler.gaml.impl.S_DisplayImpl;
import gaml.compiler.gaml.impl.S_ExperimentImpl;
import gaml.compiler.gaml.impl.S_ReflexImpl;
import gaml.compiler.gaml.impl.S_SpeciesImpl;
import gaml.compiler.gaml.impl.StatementImpl;
import gaml.compiler.gaml.impl.VariableRefImpl;
import gaml.compiler.gaml.impl.speciesOrGridDisplayStatementImpl;
import gaml.compiler.gaml.resource.GamlResource;
import gaml.compiler.gaml.resource.GamlResourceServices;
import gaml.compiler.gaml.validation.IGamlBuilderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;

public class GamaDiagramEditor
extends DiagramEditor
implements IGamlBuilderListener {
    private static final int INITIAL_BUTTONS = 20;
    public static final Color COLOR_TEXT = Display.getDefault().getSystemColor(2);
    private static Font labelFont;
    GamlResource resource;
    List<String> abbreviations = new ArrayList<String>();
    List<String> completeNamesOfExperiments = new ArrayList<String>();
    boolean wasOK = true;
    boolean inited = false;
    Composite toolbar;
    Composite parent;
    Composite indicator;
    Button[] buttons = new Button[20];
    CLabel status;
    Button menu;
    Diagram diagram;
    List<GamlCompilationError> errors;
    List<String> facets = Arrays.asList("torus:", "width:", "height:", "neighbours:", "refresh_every:", "background:", "among:", "->", "<-", "step:", "min:", "max:", "update:", "refresh:", "size:", "position:", "background:", "transparency:", "color:", "empty:", "rotate:", "schedules:", "at:", "depth:", "texture:");
    boolean toRefresh = true;
    Map<List<String>, EObject> idsEObjects = GamaMapFactory.create();
    Map<List<String>, Map<String, String>> errorsLoc = GamaMapFactory.create();
    Map<List<String>, Map<String, String>> syntaxErrorsLoc = GamaMapFactory.create();
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent evt) {
            IModel model;
            GamaDiagramEditor.this.diagram = GamaDiagramEditor.this.getDiagram();
            String xp = ((Button)evt.getSource()).getText();
            if (GamaDiagramEditor.this.diagram != null && !GamaDiagramEditor.this.diagram.getChildren().isEmpty() && (model = ModelGenerator.modelGeneration(GamaDiagramEditor.this.getDiagramTypeProvider().getFeatureProvider(), GamaDiagramEditor.this.diagram)) != null) {
                GAMA.runGuiExperiment((String)xp, (IModel)model);
            }
        }
    };

    static {
        FontData fd = Display.getDefault().getSystemFont().getFontData()[0];
        fd.setStyle(1);
        labelFont = new Font((Device)Display.getDefault(), fd);
    }

    public void validationEnded(ModelDescription model, Iterable<? extends IDescription> experiments, ValidationContext status) {
        this.updateExperiments(experiments, status.hasErrors());
        this.toRefresh = true;
    }

    private <T extends IDescription> void updateExperiments(Iterable<T> experiments, boolean withErrors) {
        if (withErrors && !this.wasOK) {
            return;
        }
        LinkedHashSet<String> oldNames = new LinkedHashSet<String>(this.completeNamesOfExperiments);
        if (this.inited && this.wasOK && !withErrors && oldNames.equals(experiments)) {
            return;
        }
        ArrayList<IDescription> exps = new ArrayList<IDescription>();
        for (IDescription desc : experiments) {
            exps.add(desc);
        }
        this.inited = true;
        this.wasOK = !withErrors;
        this.completeNamesOfExperiments = exps.stream().map(INamed::getName).collect(Collectors.toList());
        this.buildAbbreviations();
        this.updateToolbar(this.wasOK);
    }

    private void buildAbbreviations() {
        int size = this.completeNamesOfExperiments.size();
        this.abbreviations.clear();
        if (size > 6) {
            for (String s : this.completeNamesOfExperiments) {
                this.abbreviations.add(s.replaceFirst("Experiment ", ""));
            }
        } else if (size > 4) {
            for (String s : this.completeNamesOfExperiments) {
                this.abbreviations.add(s.replaceFirst("Experiment", "Exp."));
            }
        } else {
            this.abbreviations.addAll(this.completeNamesOfExperiments);
        }
    }

    public void updateToolbar(boolean ok) {
        Display.getDefault().asyncExec(() -> {
            if (this.toolbar == null || this.toolbar.isDisposed()) {
                return;
            }
            Button[] buttonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button b = buttonArray[n2];
                if (b.isVisible()) {
                    this.hideButton(b);
                }
                ++n2;
            }
            if (ok) {
                int size = this.abbreviations.size();
                if (size == 0) {
                    this.setStatus("Model is functional, but no experiments have been defined.", ok);
                } else {
                    this.setStatus(size == 1 ? "Run :" : "Run :", ok);
                }
                int i = 0;
                for (String e : this.abbreviations) {
                    this.enableButton(i++, e);
                }
            } else {
                StringBuilder textError = new StringBuilder();
                for (GamlCompilationError err : this.errors) {
                    if (err == null) continue;
                    textError.append(err.toString()).append("; ");
                }
                this.setStatus("Error(s) detected: " + textError.toString(), ok);
            }
            this.toolbar.layout(true);
        });
    }

    private void enableButton(int index, String text) {
        if (text == null) {
            return;
        }
        ((GridData)this.buttons[index].getLayoutData()).exclude = false;
        this.buttons[index].setVisible(true);
        this.buttons[index].setText(text);
        this.buttons[index].pack();
    }

    private void hideButton(Button b) {
        ((GridData)b.getLayoutData()).exclude = true;
        b.setVisible(false);
    }

    private void setStatus(String text, boolean ok) {
        Color c = ok ? (this.abbreviations.size() == 0 ? IGamaColors.WARNING.inactive() : IGamaColors.OK.inactive()) : IGamaColors.ERROR.inactive();
        this.indicator.setBackground(c);
        this.status.setText(text);
    }

    public void createPartControlXP(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.toolbar = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 26;
        data.horizontalIndent = 10;
        this.toolbar.setLayoutData((Object)data);
        layout = new GridLayout(22, false);
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.toolbar.setLayout((Layout)layout);
        Composite others = new Composite(parent, 0);
        data = new GridData(131072, 4, false, false);
        data.heightHint = 26;
        others.setLayoutData((Object)data);
        layout = new GridLayout(2, false);
        others.setLayout((Layout)layout);
        this.indicator = new Composite(parent, 0);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        data.heightHint = 8;
        this.indicator.setLayoutData((Object)data);
        FillLayout layout2 = new FillLayout();
        layout2.marginWidth = 12;
        layout2.marginHeight = 0;
        this.indicator.setLayout((Layout)layout2);
        this.status = new CLabel(this.toolbar, 0);
        this.status.setFont(labelFont);
        data = new GridData(4, 0x1000000, false, false);
        data.minimumHeight = -1;
        this.status.setLayoutData((Object)data);
        this.status.setForeground(COLOR_TEXT);
        int i = 0;
        while (i < 20) {
            this.buttons[i] = new Button(this.toolbar, 8);
            data = new GridData(16384, 0x1000000, false, false);
            this.buttons[i].setLayoutData((Object)data);
            this.buttons[i].setText("Experiment " + i);
            this.buttons[i].addSelectionListener(this.listener);
            this.hideButton(this.buttons[i]);
            ++i;
        }
        Composite parent2 = new Composite(parent, 0);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        parent2.setLayoutData((Object)data);
        parent2.setLayout((Layout)new FillLayout());
        super.createPartControl(parent2);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void initGamlResource() {
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        URI uri = URI.createPlatformResourceURI((String)("toto/" + this.getTitle() + ".gaml"), (boolean)true);
        this.resource = (GamlResource)rs.createResource(uri);
    }

    public Diagram getDiagram() {
        Diagram diag = this.diagram;
        if (this.diagram == null) {
            this.diagram = diag = this.getDiagramTypeProvider().getDiagram();
        }
        return diag;
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.initGamlResource();
        if (this.getDiagram() != null) {
            ModelGenerator.modelValidation(this.getDiagramTypeProvider().getFeatureProvider(), this.getDiagram());
            this.doSave(null);
        }
    }

    public void createPartControl(Composite parent) {
        this.createPartControlXP(parent);
    }

    public GamlResource getResource() {
        return this.resource;
    }

    public void setResource(GamlResource resource) {
        this.resource = resource;
        if (resource != null) {
            GamlResourceServices.addResourceListener((URI)resource.getURI(), (IGamlBuilderListener)this);
        }
    }

    public List<GamlCompilationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<GamlCompilationError> errors) {
        this.errors = errors;
        for (GamlCompilationError error : errors) {
            EObject toto = error.getStatement();
            ArrayList<String> ids = new ArrayList<String>();
            String fist_obj = this.buildLocation(toto, ids);
            while (!ids.isEmpty()) {
                if (this.idsEObjects.containsKey(ids)) break;
                ids.remove(ids.size() - 1);
            }
            IMap locs = this.errorsLoc.get(ids);
            if (locs == null) {
                locs = GamaMapFactory.create();
            }
            String key = "gaml.duplicate.definition.issue".equals(error.getCode()) || "gaml.duplicate.name.issue".equals(error.getCode()) ? "name" : fist_obj;
            locs.put(key, (locs.containsKey(key) ? (String)locs.get(key) : "") + "\n" + error.toString());
            if ("Syntax errors detected ".equals(error.toString())) {
                if (!this.syntaxErrorsLoc.isEmpty()) continue;
                this.syntaxErrorsLoc.put(ids, (Map<String, String>)locs);
                continue;
            }
            this.errorsLoc.put(ids, (Map<String, String>)locs);
        }
        this.toRefresh = false;
        this.updateEObjectErrors();
    }

    public String buildLocation(EObject toto, List<String> ids) {
        String fist_obj = null;
        do {
            if (toto instanceof S_ReflexImpl) {
                S_ReflexImpl vv = (S_ReflexImpl)toto;
                if (vv.getName() != null) {
                    ids.add(0, vv.getName());
                }
                if (fist_obj == null) {
                    if (vv.getName() != null) {
                        fist_obj = vv.getName();
                    } else if (vv.getKey() != null) {
                        fist_obj = vv.getKey();
                    }
                }
            } else if (toto instanceof S_SpeciesImpl) {
                S_SpeciesImpl vv = (S_SpeciesImpl)toto;
                ids.add(0, vv.getName());
                if (fist_obj == null) {
                    fist_obj = vv.getName();
                }
            } else if (toto instanceof FacetImpl) {
                FacetImpl vv = (FacetImpl)toto;
                if (fist_obj == null && this.facets.contains(vv.getKey())) {
                    fist_obj = vv.getKey();
                }
            } else if (toto instanceof S_ActionImpl) {
                S_ActionImpl vv = (S_ActionImpl)toto;
                ids.add(0, vv.getName());
                if (fist_obj == null) {
                    fist_obj = vv.getName();
                }
            } else if (toto instanceof speciesOrGridDisplayStatementImpl) {
                speciesOrGridDisplayStatementImpl vv = (speciesOrGridDisplayStatementImpl)toto;
                ids.add(0, vv.getKey());
            } else if (toto instanceof S_DisplayImpl) {
                S_DisplayImpl vv = (S_DisplayImpl)toto;
                ids.add(0, vv.getName());
                if (fist_obj == null) {
                    fist_obj = vv.getName();
                }
            } else if (toto instanceof BlockImpl) {
                BlockImpl vv = (BlockImpl)toto;
                if (vv.getStatements() != null) {
                    for (Statement st : vv.getStatements()) {
                        if (st == null || st.getKey() == null) continue;
                        "parameter".equals(st.getKey());
                    }
                }
            } else if (toto instanceof S_DefinitionImpl) {
                S_DefinitionImpl vv = (S_DefinitionImpl)toto;
                ids.add(0, vv.getName());
            } else if (toto instanceof ArgumentDefinitionImpl) {
                ArgumentDefinitionImpl vv = (ArgumentDefinitionImpl)toto;
                ids.add(0, vv.getName());
            } else if (toto instanceof S_ExperimentImpl) {
                S_ExperimentImpl vv = (S_ExperimentImpl)toto;
                ids.add(0, vv.getName());
                if (fist_obj == null) {
                    fist_obj = vv.getName();
                }
            } else if (toto instanceof StatementImpl) {
                StatementImpl vv = (StatementImpl)toto;
                if ("text".equals(vv.getKey()) || "image".equals(vv.getKey()) || "chart".equals(vv.getKey()) || "draw".equals(vv.getKey())) {
                    ids.add(0, vv.getKey());
                }
            } else if (!(toto instanceof VariableRefImpl) && toto instanceof EGamaObject) {
                EGamaObject vv = (EGamaObject)toto;
                if (toto instanceof ELayer) {
                    ids.add(0, ((ELayer)vv).getType() == null ? "species" : ((ELayer)vv).getType());
                } else if (toto instanceof ELayerAspect) {
                    ids.add(0, "draw");
                } else {
                    ids.add(0, vv.getName());
                }
                if (fist_obj == null) {
                    fist_obj = vv.getName();
                }
            }
            if (toto instanceof EAction) {
                toto = ((EActionLink)((EAction)toto).getActionLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof EReflex) {
                toto = ((EReflexLink)((EReflex)toto).getReflexLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof ELayer) {
                toto = ((ELayer)toto).getDisplay();
                continue;
            }
            if (toto instanceof ELayerAspect) {
                toto = ((ELayerAspect)toto).getAspect();
                continue;
            }
            if (toto instanceof EAspect) {
                toto = ((EAspectLink)((EAspect)toto).getAspectLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof EExperiment) {
                toto = ((EExperiment)toto).getExperimentLink().getSpecies();
                continue;
            }
            if (toto instanceof EDisplay) {
                toto = ((EDisplay)toto).getDisplayLink().getExperiment();
                continue;
            }
            if (toto instanceof ESpecies) {
                if (!"world".equals(((ESpecies)toto).getName())) {
                    toto = ((ESubSpeciesLink)((ESpecies)toto).getMacroSpeciesLinks().get(0)).getMacro();
                    continue;
                }
                toto = null;
                continue;
            }
            EObject eObject = toto = toto != null ? toto.eContainer() : toto;
        } while (toto != null && !(toto instanceof Model));
        if (!ids.contains("world")) {
            ids.add(0, "world");
        }
        return fist_obj;
    }

    public String containErrors(List<String> location, String name, List<String> uselessName) {
        boolean noName = "".equals(name);
        if (this.errorsLoc == null || this.errorsLoc.isEmpty() || !this.errorsLoc.containsKey(location)) {
            return "";
        }
        if (noName) {
            Map<String, String> er = this.errorsLoc.get(location);
            if (uselessName != null) {
                for (String val : uselessName) {
                    er.remove(val);
                }
            }
            if (!er.isEmpty()) {
                ArrayList<String> l = new ArrayList<String>(er.values());
                return (String)l.get(0);
            }
        } else if (this.errorsLoc.get(location).containsKey(name)) {
            return this.errorsLoc.get(location).get(name);
        }
        return "";
    }

    public List<String> computeIds(EObject obj) {
        EObject toto = obj;
        ArrayList<String> ids = new ArrayList<String>();
        do {
            if (toto == null) continue;
            if (toto instanceof EGamaObject) {
                if (toto instanceof ELayer) {
                    ids.add(0, ((ELayer)toto).getType());
                }
                if (toto instanceof ELayerAspect) {
                    ids.add(0, "draw");
                } else {
                    ids.add(0, ((EGamaObject)toto).getName());
                }
            } else if (toto instanceof EVariable) {
                ids.add(0, ((EVariable)toto).getName());
            } else if (toto instanceof EFacet) {
                ids.add(0, ((EFacet)toto).getName());
            }
            if (toto instanceof EAction) {
                toto = ((EActionLink)((EAction)toto).getActionLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof EReflex) {
                toto = ((EReflexLink)((EReflex)toto).getReflexLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof EAspect) {
                toto = ((EAspectLink)((EAspect)toto).getAspectLinks().get(0)).getSpecies();
                continue;
            }
            if (toto instanceof EExperiment) {
                toto = ((EExperiment)toto).getExperimentLink().getSpecies();
                continue;
            }
            if (toto instanceof EDisplay) {
                toto = ((EDisplay)toto).getDisplayLink().getExperiment();
                continue;
            }
            if (toto instanceof ELayer) {
                toto = ((ELayer)toto).getDisplay();
                continue;
            }
            if (toto instanceof ELayerAspect) {
                toto = ((ELayerAspect)toto).getAspect();
                continue;
            }
            if (toto instanceof ESpecies) {
                if (!"world".equals(((ESpecies)toto).getName())) {
                    toto = ((ESubSpeciesLink)((ESpecies)toto).getMacroSpeciesLinks().get(0)).getMacro();
                    continue;
                }
                toto = null;
                continue;
            }
            toto = toto.eContainer();
        } while (toto != null && !(toto instanceof Model));
        if (!ids.contains("world")) {
            ids.add(0, "world");
        }
        return ids;
    }

    public void addEOject(EObject obj) {
        List<String> ids = this.computeIds(obj);
        if (obj instanceof EVariable) {
            this.idsEObjects.put(ids, ((EVariable)obj).eContainer());
        } else if (obj instanceof EParameter) {
            this.idsEObjects.put(ids, ((EParameter)obj).eContainer());
        } else if (obj instanceof EFacet) {
            this.idsEObjects.put(ids, ((EFacet)obj).eContainer());
        } else if (obj instanceof EMonitor) {
            this.idsEObjects.put(ids, ((EMonitor)obj).eContainer());
        } else {
            this.idsEObjects.put(ids, obj);
        }
    }

    public void addEOject(EObject obj, String name) {
        List<String> ids = this.computeIds(obj);
        ids.add(name);
        this.idsEObjects.put(ids, obj);
    }

    public void removeEOject(EObject obj) {
        List<String> ids = this.computeIds(obj);
        this.idsEObjects.remove(ids);
    }

    public void updateEObjectErrors() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    GamaDiagramEditor.this.initIdsEObjects();
                    ArrayList<List<String>> vals = new ArrayList<List<String>>(GamaDiagramEditor.this.idsEObjects.keySet());
                    IMap valM = GamaMapFactory.create();
                    for (EObject eObject : valM.values()) {
                        if (eObject instanceof EGamaObject) {
                            ((EGamaObject)eObject).setHasError(false);
                            continue;
                        }
                        if (!(eObject instanceof EVariable)) continue;
                        ((EVariable)eObject).setHasError(false);
                    }
                    for (List list : vals) {
                        boolean val;
                        EObject obj = (EObject)valM.get(list);
                        if (obj == null) continue;
                        boolean bl = val = GamaDiagramEditor.this.syntaxErrorsLoc.containsKey(list) || GamaDiagramEditor.this.errorsLoc.containsKey(list);
                        if (!val || !(obj instanceof EGamaObject)) continue;
                        ((EGamaObject)obj).setHasError(val);
                    }
                }
            });
        }
    }

    public Map<List<String>, Map<String, String>> getErrorsLoc() {
        return this.errorsLoc;
    }

    public Map<List<String>, Map<String, String>> getSyntaxErrorsLoc() {
        return this.syntaxErrorsLoc;
    }

    public Map<List<String>, EObject> getIdsEObjects() {
        return this.idsEObjects;
    }

    public void initIdsEObjects() {
        if (this.diagram != null && !this.diagram.getChildren().isEmpty() && this.idsEObjects.isEmpty()) {
            for (Shape obj : this.getDiagram().getChildren()) {
                Object bo = this.getDiagramTypeProvider().getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)obj);
                if (bo instanceof EObject) {
                    this.addEOject((EObject)bo);
                }
                if (bo instanceof ESpecies) {
                    boolean shape = false;
                    boolean location = false;
                    for (EVariable v : ((ESpecies)bo).getVariables()) {
                        this.addEOject(v);
                        if (location || "location".equals(v.getName())) {
                            location = true;
                        }
                        if (!shape && !"shape".equals(v.getName())) continue;
                        shape = true;
                    }
                    if (!shape) {
                        this.addEOject((EObject)bo, "shape");
                    }
                    if (location) continue;
                    this.addEOject((EObject)bo, "location");
                    continue;
                }
                if (bo instanceof EAspect) {
                    this.addEOject((EObject)bo, "draw");
                    continue;
                }
                if (bo instanceof EDisplay) {
                    for (ELayer lay : ((EDisplay)bo).getLayers()) {
                        this.addEOject((EObject)bo, lay.getType());
                    }
                    continue;
                }
                if (!(bo instanceof EExperiment)) continue;
                for (EParameter v : ((EExperiment)bo).getParameters()) {
                    this.addEOject(v);
                }
                for (EMonitor v : ((EExperiment)bo).getMonitors()) {
                    this.addEOject(v);
                }
            }
        }
    }

    public void updateErrors(List<String> oldId, List<String> newId) {
        EObject obj;
        Map<String, String> eMap2;
        Map<String, String> eMap = this.errorsLoc.remove(oldId);
        if (eMap != null) {
            this.errorsLoc.put(newId, eMap);
        }
        if ((eMap2 = this.syntaxErrorsLoc.remove(oldId)) != null) {
            this.syntaxErrorsLoc.put(newId, eMap2);
        }
        if ((obj = this.idsEObjects.remove(oldId)) != null) {
            this.idsEObjects.put(newId, obj);
        }
    }

    public boolean isWasOK() {
        return this.wasOK;
    }

    protected DiagramBehavior createDiagramBehavior() {
        return new GamaDiagramBehavior((IDiagramContainerUI)this);
    }
}

