/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.editor;

import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.model.IModel;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.SimulationOutputManager;
import gama.extension.bdi.PerceiveStatement;
import gama.extension.bdi.RuleStatement;
import gama.extension.bdi.SimpleBdiPlanStatement;
import gama.extension.maths.ode.statements.SystemOfEquationsStatement;
import gama.gaml.architecture.finite_state_machine.FsmStateStatement;
import gama.gaml.architecture.reflex.ReflexStatement;
import gama.gaml.architecture.weighted_tasks.WeightedTaskStatement;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.Facets;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.variables.IVariable;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.add.AddActionFeature;
import gama.ui.diagram.features.add.AddActionLinkFeature;
import gama.ui.diagram.features.add.AddAspectFeature;
import gama.ui.diagram.features.add.AddAspectLinkFeature;
import gama.ui.diagram.features.add.AddBatchExperimentFeature;
import gama.ui.diagram.features.add.AddDisplayFeature;
import gama.ui.diagram.features.add.AddDisplayLinkFeature;
import gama.ui.diagram.features.add.AddEExperimentLinkFeature;
import gama.ui.diagram.features.add.AddEquationFeature;
import gama.ui.diagram.features.add.AddEquationLinkFeature;
import gama.ui.diagram.features.add.AddGridFeature;
import gama.ui.diagram.features.add.AddGuiExperimentFeature;
import gama.ui.diagram.features.add.AddInheritingLinkFeature;
import gama.ui.diagram.features.add.AddPerceiveFeature;
import gama.ui.diagram.features.add.AddPerceiveLinkFeature;
import gama.ui.diagram.features.add.AddPlanFeature;
import gama.ui.diagram.features.add.AddPlanLinkFeature;
import gama.ui.diagram.features.add.AddReflexFeature;
import gama.ui.diagram.features.add.AddReflexLinkFeature;
import gama.ui.diagram.features.add.AddRuleFeature;
import gama.ui.diagram.features.add.AddRuleLinkFeature;
import gama.ui.diagram.features.add.AddSpeciesFeature;
import gama.ui.diagram.features.add.AddStateFeature;
import gama.ui.diagram.features.add.AddStateLinkFeature;
import gama.ui.diagram.features.add.AddSubSpecieLinkFeature;
import gama.ui.diagram.features.add.AddTaskFeature;
import gama.ui.diagram.features.add.AddTaskLinkFeature;
import gama.ui.diagram.features.add.AddWorldFeature;
import gama.ui.diagram.features.create.CreateActionLinkFeature;
import gama.ui.diagram.features.create.CreateAspectLinkFeature;
import gama.ui.diagram.features.create.CreateBatchExperimentLinkFeature;
import gama.ui.diagram.features.create.CreateDisplayLinkFeature;
import gama.ui.diagram.features.create.CreateEquationLinkFeature;
import gama.ui.diagram.features.create.CreateGuiExperimentLinkFeature;
import gama.ui.diagram.features.create.CreateInheritingLinkFeature;
import gama.ui.diagram.features.create.CreatePerceiveLinkFeature;
import gama.ui.diagram.features.create.CreatePlanLinkFeature;
import gama.ui.diagram.features.create.CreateReflexLinkFeature;
import gama.ui.diagram.features.create.CreateRuleLinkFeature;
import gama.ui.diagram.features.create.CreateStateLinkFeature;
import gama.ui.diagram.features.create.CreateSubGridLinkFeature;
import gama.ui.diagram.features.create.CreateSubSpeciesLinkFeature;
import gama.ui.diagram.features.create.CreateTaskLinkFeature;
import gama.ui.diagram.features.layout.LayoutCommonFeature;
import gama.ui.diagram.features.layout.LayoutDiagramFeature;
import gama.ui.diagram.features.layout.LayoutEExperimentFeature;
import gama.ui.diagram.features.layout.LayoutESpeciesFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerationFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.features.others.ChangeColorEGamaObjectFeature;
import gama.ui.diagram.features.others.CustomDeleteFeature;
import gama.ui.diagram.features.others.EmptyRemoveFeature;
import gama.ui.diagram.features.others.UpdateEGamaObjectFeature;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EActionLink;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.EBatchExperiment;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EDisplayLink;
import gama.ui.diagram.metamodel.EEquation;
import gama.ui.diagram.metamodel.EEquationLink;
import gama.ui.diagram.metamodel.EExperiment;
import gama.ui.diagram.metamodel.EExperimentLink;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.EGUIExperiment;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.EGrid;
import gama.ui.diagram.metamodel.EInheritLink;
import gama.ui.diagram.metamodel.EPerceive;
import gama.ui.diagram.metamodel.EPerceiveLink;
import gama.ui.diagram.metamodel.EPlan;
import gama.ui.diagram.metamodel.EPlanLink;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ERule;
import gama.ui.diagram.metamodel.ERuleLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EState;
import gama.ui.diagram.metamodel.EStateLink;
import gama.ui.diagram.metamodel.ESubSpeciesLink;
import gama.ui.diagram.metamodel.ETask;
import gama.ui.diagram.metamodel.ETaskLink;
import gama.ui.diagram.metamodel.EVariable;
import gama.ui.diagram.metamodel.EWorldAgent;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.datatypes.impl.LocationImpl;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

public class GamaFeatureProvider
extends DefaultFeatureProvider {
    private String typeOfModel;
    private IModel gamaModel;
    private final GamaFeatureProvider fp;
    private final List<String> built_in_species = Arrays.asList("osm_node", "osm_building", "osm_road", "graph_edge", "graph_node", "AgentDB", "Physical3DWorld", "cluster_builder", "experimentator", "agent", "multicriteria_analyzer", "base_node", "base_edge", "world", "node", "edge", "platform", "abstract_unity_linker", "abstract_unity_player", "physical_world");
    private final List<String> built_in_variables = Arrays.asList("name", "peers", "host", "members", "agents", "rng_usage", "starting_date", "current_date", "paused", "rng", "seed", "average_duration", "total_duration", "duration", "time", "cycle", "machine_time");
    private final List<String> built_in_actions;

    public GamaFeatureProvider(IDiagramTypeProvider dtp) {
        super(dtp);
        this.fp = this;
        this.built_in_actions = new ArrayList<String>();
        for (IDescription desc : GAML.getAllActions()) {
            this.built_in_actions.add(desc.getName());
        }
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context.getNewObject() instanceof EWorldAgent) {
            return new AddWorldFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EAction) {
            return new AddActionFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EReflex) {
            return new AddReflexFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EPlan) {
            return new AddPlanFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ETask) {
            return new AddTaskFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EState) {
            return new AddStateFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ERule) {
            return new AddRuleFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EEquation) {
            return new AddEquationFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EPerceive) {
            return new AddPerceiveFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EAspect) {
            return new AddAspectFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EGUIExperiment) {
            return new AddGuiExperimentFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EBatchExperiment) {
            return new AddBatchExperimentFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EDisplay) {
            return new AddDisplayFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ESubSpeciesLink) {
            return new AddSubSpecieLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EActionLink) {
            return new AddActionLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EReflexLink) {
            return new AddReflexLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EEquationLink) {
            return new AddEquationLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EPlanLink) {
            return new AddPlanLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EStateLink) {
            return new AddStateLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ETaskLink) {
            return new AddTaskLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ERuleLink) {
            return new AddRuleLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EPerceiveLink) {
            return new AddPerceiveLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EAspectLink) {
            return new AddAspectLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EDisplayLink) {
            return new AddDisplayLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EExperimentLink) {
            return new AddEExperimentLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EInheritLink) {
            return new AddInheritingLinkFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof EGrid) {
            return new AddGridFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof ESpecies) {
            return new AddSpeciesFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        return new ICreateFeature[0];
    }

    public void init() {
        final Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        if (diagram.getChildren().isEmpty()) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    EWorldAgent newClass = GamaFactory.eINSTANCE.createEWorldAgent();
                    diagram.eResource().getContents().add((Object)newClass);
                    newClass.setName("world");
                    CreateContext ac = new CreateContext();
                    ac.setLocation(100, 50);
                    ac.setSize(0, 0);
                    ac.setTargetContainer((ContainerShape)diagram);
                    GamaDiagramEditor diagramEditor = (GamaDiagramEditor)GamaFeatureProvider.this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
                    diagramEditor.addEOject(newClass);
                    PictogramElement worldPE = GamaFeatureProvider.this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)newClass));
                    if ("skeleton".equals(GamaFeatureProvider.this.typeOfModel)) {
                        GamaFeatureProvider.this.initSkeleton(newClass, diagram);
                    } else if ("custom".equals(GamaFeatureProvider.this.typeOfModel)) {
                        GamaFeatureProvider.this.initCustom(newClass, worldPE, diagram);
                        LayoutDiagramFeature.execute(diagram);
                        UpdateContext context = new UpdateContext((PictogramElement)diagram);
                        IUpdateFeature dfp = GamaFeatureProvider.this.fp.getUpdateFeature((IUpdateContext)context);
                        dfp.execute((IContext)context);
                    } else {
                        GamaFeatureProvider.this.initSimple(newClass, diagram);
                    }
                    ModelGenerator.modelValidation((IFeatureProvider)GamaFeatureProvider.this.fp, diagram);
                    diagramEditor.updateEObjectErrors();
                }
            });
        }
    }

    public void initSimple(EWorldAgent world, Diagram diagram) {
        CreateGuiExperimentLinkFeature cXp = new CreateGuiExperimentLinkFeature((IFeatureProvider)this);
        new CreateDisplayLinkFeature((IFeatureProvider)this);
        PictogramElement worldPe = this.getPictogramElementForBusinessObject(world);
        CreateConnectionContext context = new CreateConnectionContext();
        context.setSourcePictogramElement(worldPe);
        context.setSourceAnchor(Graphiti.getPeService().getChopboxAnchor((AnchorContainer)worldPe));
        context.setTargetLocation((ILocation)new LocationImpl(600, 50));
        Connection link = cXp.create((ICreateConnectionContext)context, false);
        AddConnectionContext cont = new AddConnectionContext(null, null);
        cont.setNewObject((Object)link);
        this.addIfPossible((IAddContext)cont);
    }

    public void initSkeleton(EWorldAgent world, Diagram diagram) {
        CreateGuiExperimentLinkFeature cXp = new CreateGuiExperimentLinkFeature((IFeatureProvider)this);
        CreateDisplayLinkFeature cDisp = new CreateDisplayLinkFeature((IFeatureProvider)this);
        PictogramElement worldPe = this.getPictogramElementForBusinessObject(world);
        CreateConnectionContext context = new CreateConnectionContext();
        context.setSourcePictogramElement(worldPe);
        context.setSourceAnchor(Graphiti.getPeService().getChopboxAnchor((AnchorContainer)worldPe));
        context.setTargetLocation((ILocation)new LocationImpl(600, 50));
        Connection link = cXp.create((ICreateConnectionContext)context, false);
        AddConnectionContext cont = new AddConnectionContext(null, null);
        cont.setNewObject((Object)link);
        this.addIfPossible((IAddContext)cont);
        CreateConnectionContext contextDisp = new CreateConnectionContext();
        Shape xp = null;
        EList contents = diagram.getChildren();
        for (Shape obj : contents) {
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)obj);
            if (!(bo instanceof EExperiment)) continue;
            xp = obj;
            break;
        }
        contextDisp.setSourcePictogramElement(xp);
        contextDisp.setSourceAnchor(Graphiti.getPeService().getChopboxAnchor((AnchorContainer)xp));
        contextDisp.setTargetLocation((ILocation)new LocationImpl(800, 50));
        Connection linkDisp = cDisp.create((ICreateConnectionContext)contextDisp, false);
        AddConnectionContext contDisp = new AddConnectionContext(null, null);
        contDisp.setNewObject((Object)linkDisp);
        this.addIfPossible((IAddContext)contDisp);
    }

    public void addVariable(IVariable var, ESpecies target, List<String> listSpecies) {
        if (this.built_in_variables.contains(var.getName()) || this.built_in_species.contains(var.getName()) || listSpecies.contains(var.getName())) {
            return;
        }
        EVariable eVar = GamaFactory.eINSTANCE.createEVariable();
        eVar.setType(var.getType().toString());
        eVar.setName(var.getName());
        if (var.hasFacet("init")) {
            eVar.setInit(var.getFacet(new String[]{"init"}).serializeToGaml(false).replace("\\/", "/"));
        }
        if (var.hasFacet("update")) {
            eVar.setUpdate(var.getFacet(new String[]{"update"}).serializeToGaml(false).replace("\\/", "/"));
        }
        if (var.hasFacet("min")) {
            eVar.setMin(var.getFacet(new String[]{"min"}).serializeToGaml(false));
        }
        if (var.hasFacet("max")) {
            eVar.setMax(var.getFacet(new String[]{"max"}).serializeToGaml(false));
        }
        if (var.hasFacet("function")) {
            eVar.setFunction(var.getFacet(new String[]{"function"}).serializeToGaml(false).replace("\\/", "/"));
        }
        if (var.hasFacet("value")) {
            eVar.setFunction(var.getFacet(new String[]{"value"}).serializeToGaml(false).replace("\\/", "/"));
        }
        target.getVariables().add((Object)eVar);
    }

    public ESpecies createMicroSpecies(ESpecies source, PictogramElement sourceE, ISpecies species, Diagram diagram, List<String> listSpecies) {
        ESpecies target = species.isGrid() ? GamaFactory.eINSTANCE.createEGrid() : GamaFactory.eINSTANCE.createESpecies();
        diagram.eResource().getContents().add((Object)target);
        Iterable skills = species.getDescription().getSkillsNames();
        for (String string : skills) {
            if ("reflex".equals(string) || "grid".equals(string) || GamaSkillRegistry.INSTANCE.getArchitectureNames().contains(string)) continue;
            target.getSkills().add((Object)string.toString());
        }
        target.setName(species.getName());
        for (Object object : this.getFacets((ISymbol)species)) {
            if (!(object instanceof String)) continue;
            String name = (String)object;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"species");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(species.getName().replace("\\/", "/"));
        }
        for (IVariable iVariable : species.getVars()) {
            if ("shape".equals(iVariable.getName()) && !iVariable.getDescription().hasFacet("init") || "location".equals(iVariable.getName()) && !iVariable.getDescription().hasFacet("init") || "color".equals(iVariable.getName()) && !iVariable.getDescription().hasFacet("init")) continue;
            this.addVariable(iVariable, target, listSpecies);
        }
        CreateContext createContext = new CreateContext();
        createContext.setLocation(0, 0);
        createContext.setSize(0, 0);
        createContext.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)createContext, (Object)target));
        ESubSpeciesLink eReference = GamaFactory.eINSTANCE.createESubSpeciesLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setMacro(source);
        eReference.setMicro(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getMicroSpeciesLinks().add((Object)eReference);
        target.getMacroSpeciesLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (ActionStatement action : species.getActions()) {
            if (this.built_in_actions.contains(action.getName())) continue;
            this.createAction(target, targetE, action, diagram);
        }
        for (IStatement stat : species.getBehaviors()) {
            if (stat instanceof ReflexStatement) {
                if (stat.getName() != null && !stat.getName().isEmpty() && !stat.getName().startsWith("_internal_init")) {
                    this.createReflex(target, targetE, (ReflexStatement)stat, diagram);
                    continue;
                }
                StringBuilder gmlCode = new StringBuilder();
                ReflexStatement rs = (ReflexStatement)stat;
                if (rs.getCommands() != null) {
                    IStatement[] iStatementArray = rs.getCommands();
                    int n = iStatementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatement st = iStatementArray[n2];
                        if (st != null) {
                            gmlCode.append(st.serializeToGaml(false));
                        }
                        ++n2;
                    }
                }
                target.setInit(this.cleanWhere(gmlCode.toString()));
                continue;
            }
            if (stat instanceof FsmStateStatement) {
                this.createState(target, targetE, (FsmStateStatement)stat, diagram);
                continue;
            }
            if (stat instanceof WeightedTaskStatement) {
                this.createTask(target, targetE, (WeightedTaskStatement)stat, diagram);
                continue;
            }
            if (stat instanceof SimpleBdiPlanStatement) {
                this.createPlan(target, targetE, (SimpleBdiPlanStatement)stat, diagram);
                continue;
            }
            if (stat instanceof PerceiveStatement) {
                this.createPerception(target, targetE, (PerceiveStatement)stat, diagram);
                continue;
            }
            if (stat instanceof RuleStatement) {
                this.createRule(target, targetE, (RuleStatement)stat, diagram);
                continue;
            }
            if (!(stat instanceof SystemOfEquationsStatement)) continue;
            this.createEquation(target, targetE, (SystemOfEquationsStatement)stat, diagram);
        }
        for (IExecutable asp : species.getAspects()) {
            if (!(asp instanceof AspectStatement)) continue;
            this.createAspect(target, targetE, (AspectStatement)asp, diagram);
        }
        return target;
    }

    public EExperiment createXP(ESpecies source, PictogramElement sourceE, IExperimentPlan xp, Diagram diagram) {
        EExperiment target = null;
        target = !xp.isBatch() ? GamaFactory.eINSTANCE.createEGUIExperiment() : GamaFactory.eINSTANCE.createEBatchExperiment();
        diagram.eResource().getContents().add((Object)target);
        target.setName(xp.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EExperimentLink eReference = GamaFactory.eINSTANCE.createEExperimentLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setExperiment(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getExperimentLinks().add((Object)eReference);
        target.setExperimentLink(eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        if (!xp.isBatch() && xp.getExperimentOutputs() != null) {
            for (IOutput iOutput : (SimulationOutputManager)xp.getOriginalSimulationOutputs()) {
                if (!(iOutput instanceof LayeredDisplayOutput)) continue;
                this.createDisplay((EGUIExperiment)target, targetE, iOutput, diagram);
            }
        }
        for (Object e : this.getFacets((ISymbol)xp)) {
            if (!(e instanceof String)) continue;
            String name = (String)e;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"experiment");
            if (proto.getFacet((String)name).internal || "type".equals(name) || "name".equals(name)) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(xp.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        return target;
    }

    public EAction createAction(ESpecies source, PictogramElement sourceE, ActionStatement action, Diagram diagram) {
        if (action == null) {
            return null;
        }
        EAction target = GamaFactory.eINSTANCE.createEAction();
        diagram.eResource().getContents().add((Object)target);
        target.setName(action.getName());
        Object gmlCode = "";
        if (action.getCommands() != null) {
            IStatement[] iStatementArray = action.getCommands();
            int n = iStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement st = iStatementArray[n2];
                gmlCode = (String)gmlCode + st.serializeToGaml(false) + System.lineSeparator();
                ++n2;
            }
        }
        gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
        target.setGamlCode((String)gmlCode);
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EActionLink eReference = GamaFactory.eINSTANCE.createEActionLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setAction(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getActionLinks().add((Object)eReference);
        target.getActionLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        return target;
    }

    public EDisplay createDisplay(EGUIExperiment source, PictogramElement sourceE, IOutput display, Diagram diagram) {
        if (display == null) {
            return null;
        }
        EDisplay target = GamaFactory.eINSTANCE.createEDisplay();
        diagram.eResource().getContents().add((Object)target);
        target.setName(display.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EDisplayLink eReference = GamaFactory.eINSTANCE.createEDisplayLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setExperiment(source);
        eReference.setDisplay(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getDisplayLinks().add((Object)eReference);
        target.setDisplayLink(eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        target.setDefineGamlCode(true);
        for (String facetN : this.getFacets((ISymbol)display)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"display");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(display.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        String gmlCode = this.cleanDelegate(display.serializeToGaml(false));
        if (gmlCode.contains("{")) {
            gmlCode = gmlCode.substring(gmlCode.indexOf("{") + 1);
            gmlCode = gmlCode.substring(0, gmlCode.lastIndexOf("}"));
        } else {
            gmlCode = "";
        }
        gmlCode = this.cleanWhere(gmlCode.replace("\\/", "/"));
        target.setGamlCode(gmlCode);
        return target;
    }

    public EAspect createAspect(ESpecies source, PictogramElement sourceE, AspectStatement aspect, Diagram diagram) {
        if (aspect == null) {
            return null;
        }
        EAspect target = GamaFactory.eINSTANCE.createEAspect();
        diagram.eResource().getContents().add((Object)target);
        target.setName(aspect.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EAspectLink eReference = GamaFactory.eINSTANCE.createEAspectLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setAspect(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getAspectLinks().add((Object)eReference);
        target.getAspectLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        target.setDefineGamlCode(true);
        for (String facetN : this.getFacets((ISymbol)aspect)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"aspect");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(aspect.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        String gmlCode = this.cleanDelegate(aspect.serializeToGaml(false));
        if (gmlCode.contains("{")) {
            gmlCode = gmlCode.substring(gmlCode.indexOf("{") + 1);
            gmlCode = gmlCode.substring(0, gmlCode.lastIndexOf("}"));
        } else {
            gmlCode = "";
        }
        gmlCode = this.cleanWhere(gmlCode.replace("\\/", "/"));
        target.setGamlCode(gmlCode);
        return target;
    }

    private String cleanWhere(String gmlCode) {
        if (gmlCode.contains("where")) {
            return gmlCode.replace("where('each',", "where(");
        }
        return gmlCode;
    }

    private String cleanDelegate(String gmlCode) {
        if (gmlCode.contains("delegate")) {
            Object res = "";
            List<String> de = List.of(gmlCode.split(" "));
            int index = -1;
            int i = 0;
            while (i < de.size()) {
                if ("delegate:".equals(de.get(i))) {
                    index = i;
                }
                if (i != index && i != index + 1) {
                    res = (String)res + de.get(i) + " ";
                }
                ++i;
            }
            return res;
        }
        return gmlCode;
    }

    public EEquation createEquation(ESpecies source, PictogramElement sourceE, SystemOfEquationsStatement equation, Diagram diagram) {
        if (equation == null) {
            return null;
        }
        EEquation target = GamaFactory.eINSTANCE.createEEquation();
        diagram.eResource().getContents().add((Object)target);
        target.setName(equation.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EEquationLink eReference = GamaFactory.eINSTANCE.createEEquationLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setEquation(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getEquationLinks().add((Object)eReference);
        target.getEquationLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)equation)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"equation");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(equation.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        String gmlCode = this.cleanWhere(equation.serializeToGaml(false));
        if (gmlCode.contains("{")) {
            gmlCode = gmlCode.substring(gmlCode.indexOf("{") + 1);
            gmlCode = gmlCode.substring(0, gmlCode.lastIndexOf("}"));
            gmlCode = gmlCode.replace("\\/", "/");
        } else {
            gmlCode = "";
        }
        target.setGamlCode(gmlCode);
        return target;
    }

    public EState createState(ESpecies source, PictogramElement sourceE, FsmStateStatement state, Diagram diagram) {
        if (state == null) {
            return null;
        }
        EState target = GamaFactory.eINSTANCE.createEState();
        diagram.eResource().getContents().add((Object)target);
        target.setName(state.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EStateLink eReference = GamaFactory.eINSTANCE.createEStateLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setState(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getStateLinks().add((Object)eReference);
        target.getStateLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)state)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"state");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(state.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        Object gmlCode = "";
        if (state.getCommands() != null) {
            IStatement[] iStatementArray = state.getCommands();
            int n = iStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement st = iStatementArray[n2];
                if (st != null) {
                    gmlCode = (String)gmlCode + st.serializeToGaml(false);
                }
                ++n2;
            }
        }
        gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
        target.setGamlCode((String)gmlCode);
        return target;
    }

    public ETask createTask(ESpecies source, PictogramElement sourceE, WeightedTaskStatement task, Diagram diagram) {
        if (task == null) {
            return null;
        }
        ETask target = GamaFactory.eINSTANCE.createETask();
        diagram.eResource().getContents().add((Object)target);
        target.setName(task.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        ETaskLink eReference = GamaFactory.eINSTANCE.createETaskLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setTask(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getTaskLinks().add((Object)eReference);
        target.getTaskLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)task)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"task");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(task.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        Object gmlCode = "";
        if (task.getCommands() != null) {
            IStatement[] iStatementArray = task.getCommands();
            int n = iStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement st = iStatementArray[n2];
                if (st != null) {
                    gmlCode = (String)gmlCode + st.serializeToGaml(false);
                }
                ++n2;
            }
        }
        gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
        target.setGamlCode((String)gmlCode);
        return target;
    }

    public EPlan createPlan(ESpecies source, PictogramElement sourceE, SimpleBdiPlanStatement plan, Diagram diagram) {
        if (plan == null) {
            return null;
        }
        EPlan target = GamaFactory.eINSTANCE.createEPlan();
        diagram.eResource().getContents().add((Object)target);
        target.setName(plan.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EPlanLink eReference = GamaFactory.eINSTANCE.createEPlanLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setPlan(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getPlanLinks().add((Object)eReference);
        target.getPlanLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)plan)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"plan");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(plan.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        Object gmlCode = "";
        if (plan.getCommands() != null) {
            IStatement[] iStatementArray = plan.getCommands();
            int n = iStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement st = iStatementArray[n2];
                if (st != null) {
                    gmlCode = (String)gmlCode + st.serializeToGaml(false);
                }
                ++n2;
            }
        }
        gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
        target.setGamlCode((String)gmlCode);
        return target;
    }

    public EPerceive createPerception(ESpecies source, PictogramElement sourceE, PerceiveStatement perception, Diagram diagram) {
        if (perception == null) {
            return null;
        }
        EPerceive target = GamaFactory.eINSTANCE.createEPerceive();
        diagram.eResource().getContents().add((Object)target);
        target.setName(perception.getName());
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EPerceiveLink eReference = GamaFactory.eINSTANCE.createEPerceiveLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setPerceive(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getPerceiveLinks().add((Object)eReference);
        target.getPerceiveLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)perception)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"perceive");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(perception.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        Object gmlCode = "";
        if (perception.getCommands() != null) {
            IStatement[] iStatementArray = perception.getCommands();
            int n = iStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatement st = iStatementArray[n2];
                if (st != null) {
                    gmlCode = (String)gmlCode + st.serializeToGaml(false);
                }
                ++n2;
            }
        }
        gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
        target.setGamlCode((String)gmlCode);
        return target;
    }

    public ERule createRule(ESpecies source, PictogramElement sourceE, RuleStatement rule, Diagram diagram) {
        String[] nR;
        if (rule == null) {
            return null;
        }
        ERule target = GamaFactory.eINSTANCE.createERule();
        diagram.eResource().getContents().add((Object)target);
        String[] stringArray = nR = rule.getName() == null ? null : rule.getName().split(" ");
        if (nR.length == 1) {
            target.setName(rule.getName());
        } else {
            target.setName(nR[nR.length - 1]);
        }
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        ERuleLink eReference = GamaFactory.eINSTANCE.createERuleLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setRule(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getRuleLinks().add((Object)eReference);
        target.getRuleLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        for (String facetN : this.getFacets((ISymbol)rule)) {
            if (!(facetN instanceof String)) continue;
            String name = facetN;
            SymbolProto proto = DescriptionFactory.getStatementProto((String)"rule");
            if (proto.getFacet((String)name).internal) continue;
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setName(name);
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setValue(rule.getFacet(new String[]{name}).serializeToGaml(false).replace("\\/", "/"));
        }
        return target;
    }

    public EReflex createReflex(ESpecies source, PictogramElement sourceE, ReflexStatement reflex, Diagram diagram) {
        if (reflex == null) {
            return null;
        }
        EReflex target = GamaFactory.eINSTANCE.createEReflex();
        diagram.eResource().getContents().add((Object)target);
        target.setName(reflex.getName());
        String gmlCode = this.cleanWhere(reflex.serializeToGaml(false));
        if (gmlCode.contains("{")) {
            gmlCode = gmlCode.substring(gmlCode.indexOf("{") + 1);
            gmlCode = gmlCode.substring(0, gmlCode.lastIndexOf("}"));
            gmlCode = gmlCode.replace("\\/", "/");
        } else {
            gmlCode = "";
        }
        target.setGamlCode(gmlCode);
        if (reflex.hasFacet("when")) {
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
            facet.setName("when");
            facet.setValue(reflex.getFacet(new String[]{"when"}).serializeToGaml(false));
        }
        CreateContext ac = new CreateContext();
        ac.setLocation(0, 0);
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)diagram);
        PictogramElement targetE = this.addIfPossible((IAddContext)new AddContext((IAreaContext)ac, (Object)target));
        EReflexLink eReference = GamaFactory.eINSTANCE.createEReflexLink();
        diagram.eResource().getContents().add((Object)eReference);
        AddConnectionContext addContext = new AddConnectionContext(this.getAnchor(sourceE), this.getAnchor(targetE));
        addContext.setNewObject((Object)eReference);
        this.addIfPossible((IAddContext)addContext);
        eReference.setSpecies(source);
        eReference.setReflex(target);
        eReference.setSource(source);
        eReference.setTarget(target);
        source.getReflexLinks().add((Object)eReference);
        target.getReflexLinks().add((Object)eReference);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
        diagramEditor.addEOject(target);
        return target;
    }

    protected Anchor getAnchor(PictogramElement targetpe) {
        Anchor ret = null;
        if (targetpe instanceof Anchor) {
            ret = (Anchor)targetpe;
        } else if (targetpe instanceof AnchorContainer) {
            ret = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)targetpe);
        }
        return ret;
    }

    public void initCustom(EWorldAgent eWorld, PictogramElement worldPE, Diagram diagram) {
        ArrayList<String> listSpecies = new ArrayList<String>();
        listSpecies.addAll(this.gamaModel.getMicroSpeciesNames());
        for (IVariable var : this.gamaModel.getVars()) {
            if ("experiment".equals(var.getName()) || "world".equals(var.getName()) || "location".equals(var.getName()) || "shape".equals(var.getName()) && !var.getDescription().hasFacet("init") || "step".equals(var.getName()) && !var.getDescription().hasFacet("init") || "color".equals(var.getName()) && !var.getDescription().hasFacet("init")) continue;
            this.addVariable(var, eWorld, listSpecies);
        }
        for (ActionStatement action : this.gamaModel.getActions()) {
            if (this.built_in_actions.contains(action.getName())) continue;
            this.createAction(eWorld, worldPE, action, diagram);
        }
        for (IStatement stat : this.gamaModel.getBehaviors()) {
            if (!(stat instanceof ReflexStatement)) continue;
            if (stat.getName() != null && !stat.getName().isEmpty() && !stat.getName().startsWith("_internal_init")) {
                this.createReflex(eWorld, worldPE, (ReflexStatement)stat, diagram);
                continue;
            }
            Object gmlCode = "";
            ReflexStatement rs = (ReflexStatement)stat;
            if (rs.getCommands() != null) {
                IStatement[] iStatementArray = rs.getCommands();
                int n = iStatementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatement st = iStatementArray[n2];
                    if (st != null) {
                        gmlCode = (String)gmlCode + st.serializeToGaml(false);
                    }
                    ++n2;
                }
            }
            gmlCode = this.cleanWhere(((String)gmlCode).replace("\\/", "/"));
            eWorld.setInit((String)gmlCode);
        }
        this.buildAgent(this.gamaModel, eWorld, worldPE, diagram, listSpecies);
    }

    public void buildAgent(IModel gamaSpecies, ESpecies species, PictogramElement speciesE, Diagram diagram, List<String> listSpecies) {
        Set xpNames = gamaSpecies.getDescription().getModelDescription().getExperimentNames();
        for (String xpN : xpNames) {
            this.createXP(species, speciesE, gamaSpecies.getExperiment(xpN), diagram);
        }
        for (ISpecies sp : gamaSpecies.getMicroSpecies()) {
            if (this.built_in_species.contains(sp.getName())) continue;
            this.createMicroSpecies(species, speciesE, sp, diagram, listSpecies);
        }
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof ESpecies) {
            return new LayoutESpeciesFeature((IFeatureProvider)this);
        }
        if (bo instanceof EExperiment) {
            return new LayoutEExperimentFeature((IFeatureProvider)this);
        }
        if (bo instanceof EGamaObject) {
            return new LayoutCommonFeature((IFeatureProvider)this);
        }
        return super.getLayoutFeature(context);
    }

    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        return this.getCreateConnectionFeatures();
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateSubSpeciesLinkFeature((IFeatureProvider)this), new CreateSubGridLinkFeature((IFeatureProvider)this), new CreateInheritingLinkFeature((IFeatureProvider)this), new CreateActionLinkFeature((IFeatureProvider)this), new CreateReflexLinkFeature((IFeatureProvider)this), new CreateAspectLinkFeature((IFeatureProvider)this), new CreateDisplayLinkFeature((IFeatureProvider)this), new CreateBatchExperimentLinkFeature((IFeatureProvider)this), new CreateGuiExperimentLinkFeature((IFeatureProvider)this), new CreatePlanLinkFeature((IFeatureProvider)this), new CreateTaskLinkFeature((IFeatureProvider)this), new CreateStateLinkFeature((IFeatureProvider)this), new CreateRuleLinkFeature((IFeatureProvider)this), new CreateEquationLinkFeature((IFeatureProvider)this), new CreatePerceiveLinkFeature((IFeatureProvider)this)};
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        return new ICustomFeature[]{new ModelGenerationFeature((IFeatureProvider)this), new LayoutDiagramFeature((IFeatureProvider)this), new ChangeColorEGamaObjectFeature((IFeatureProvider)this)};
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        return new EmptyRemoveFeature((IFeatureProvider)this);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return new CustomDeleteFeature((IFeatureProvider)this);
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        Object bo;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pictogramElement)) instanceof EGamaObject) {
            return new UpdateEGamaObjectFeature((IFeatureProvider)this);
        }
        return super.getUpdateFeature(context);
    }

    public String getTypeOfModel() {
        return this.typeOfModel;
    }

    public void setTypeOfModel(String typeOfModel) {
        this.typeOfModel = typeOfModel;
    }

    public IModel getGamaModel() {
        return this.gamaModel;
    }

    public void setGamaModel(IModel gamaModel) {
        this.gamaModel = gamaModel;
    }

    public List<String> getFacets(ISymbol statement) {
        Facets fs = statement.getDescription().getFacets();
        ArrayList<String> a = new ArrayList<String>();
        fs.forEach((key, value) -> a.add((String)key));
        return a;
    }
}

