/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.editor;

import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EActionLink;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EEquation;
import gama.ui.diagram.metamodel.EEquationLink;
import gama.ui.diagram.metamodel.EPerceive;
import gama.ui.diagram.metamodel.EPerceiveLink;
import gama.ui.diagram.metamodel.EPlan;
import gama.ui.diagram.metamodel.EPlanLink;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ERule;
import gama.ui.diagram.metamodel.ERuleLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EState;
import gama.ui.diagram.metamodel.EStateLink;
import gama.ui.diagram.metamodel.ETask;
import gama.ui.diagram.metamodel.ETaskLink;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public class ModelStructure {
    Diagram diagram;
    final IFeatureProvider fp;
    String prefix;
    String text;
    String suffix;
    boolean inModel;

    public ModelStructure(Diagram diagram, IFeatureProvider fp) {
        this.diagram = diagram;
        this.fp = fp;
    }

    public void writeModelWithoutElement(EObject element) {
        this.prefix = "";
        this.text = "";
        this.suffix = "";
        String id = ModelStructure.getElementId(element);
        this.inModel = id != null;
        String model = ModelGenerator.generateModel(this.fp, this.diagram, id);
        if (this.inModel) {
            String[] mds = model.split(id);
            if (mds.length < 3) {
                this.inModel = false;
                this.text = model;
            } else {
                this.text = mds[1];
                int str = this.text.indexOf("{");
                if (str == -1) {
                    this.prefix = mds[0];
                    this.text = mds[1];
                    this.suffix = mds[2];
                    return;
                }
                this.prefix = mds[0] + this.text.substring(0, str + 1) + "\n//generated";
                int end = this.text.lastIndexOf("}");
                if (end >= this.text.length()) {
                    end = this.text.length() - 1;
                }
                this.suffix = end < 0 ? "" : this.text.substring(end) + mds[2];
                this.text = str + 2 >= end ? "" : this.text.substring(str + 2, end);
            }
        } else {
            this.text = model;
        }
        while (this.text.indexOf("\n") == 0) {
            this.text = this.text.replaceFirst("\n", "");
        }
    }

    public static String getElementId(EObject newElement) {
        if (newElement instanceof EAction) {
            EAction action = (EAction)newElement;
            return "action:" + ((EActionLink)action.getActionLinks().get(0)).getSpecies().getName() + ":" + action.getName();
        }
        if (newElement instanceof EReflex) {
            EReflex reflex = (EReflex)newElement;
            return "reflex:" + ((EReflexLink)reflex.getReflexLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof ESpecies) {
            ESpecies species = (ESpecies)newElement;
            return "species:" + species.getName();
        }
        if (newElement instanceof EEquation) {
            EEquation equation = (EEquation)newElement;
            return "equation:" + ((EEquationLink)equation.getEquationLinks().get(0)).getSpecies().getName() + ":" + equation.getName();
        }
        if (newElement instanceof EState) {
            EState reflex = (EState)newElement;
            return "state:" + ((EStateLink)reflex.getStateLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof ETask) {
            ETask reflex = (ETask)newElement;
            return "task:" + ((ETaskLink)reflex.getTaskLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof EPlan) {
            EPlan reflex = (EPlan)newElement;
            return "plan:" + ((EPlanLink)reflex.getPlanLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof EPerceive) {
            EPerceive reflex = (EPerceive)newElement;
            return "perceive:" + ((EPerceiveLink)reflex.getPerceiveLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof ERule) {
            ERule reflex = (ERule)newElement;
            return "rule:" + ((ERuleLink)reflex.getRuleLinks().get(0)).getSpecies().getName() + ":" + reflex.getName();
        }
        if (newElement instanceof EAspect) {
            EAspect aspect = (EAspect)newElement;
            return "aspect:" + ((EAspectLink)aspect.getAspectLinks().get(0)).getSpecies().getName() + ":" + aspect.getName();
        }
        if (newElement instanceof EDisplay) {
            EDisplay display = (EDisplay)newElement;
            return "display:" + display.getDisplayLink().getExperiment().getName() + ":" + display.getName();
        }
        return "";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isInModel() {
        return this.inModel;
    }

    public void setInModel(boolean inModel) {
        this.inModel = inModel;
    }
}

