/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.add;

import gama.ui.diagram.features.add.ColorDisplay;
import gama.ui.diagram.metamodel.EGrid;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EVariable;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class AddGridFeature
extends AbstractAddShapeFeature {
    public static final int INIT_WIDTH = 220;
    public static final int INIT_HEIGHT = 100;
    private static final List<Integer> GRID_BACKGROUND = Arrays.asList(255, 204, 150);

    public AddGridFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof EGrid && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        ESpecies addedClass = (ESpecies)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        boolean error = addedClass.getHasError() != null && addedClass.getHasError() != false;
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        int width = context.getWidth() <= 0 ? 220 : context.getWidth();
        int height = context.getHeight() <= 0 ? Math.max(100, addedClass.getVariables().size() * 15 + 40) : context.getHeight();
        IGaService gaService = Graphiti.getGaService();
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)containerShape, 5, 5);
        roundedRectangle.setForeground(this.manageColor(error ? ColorDisplay.CLASS_FOREGROUND_ERROR : ColorDisplay.CLASS_FOREGROUND_OK));
        if (addedClass.getColorPicto().isEmpty()) {
            addedClass.getColorPicto().addAll(GRID_BACKGROUND);
        }
        EList<Integer> currentColor = addedClass.getColorPicto();
        Color color = gaService.manageColor(this.getDiagram(), ((Integer)currentColor.get(0)).intValue(), ((Integer)currentColor.get(1)).intValue(), ((Integer)currentColor.get(2)).intValue());
        roundedRectangle.setBackground(color);
        roundedRectangle.setLineWidth(Integer.valueOf(error ? 4 : 2));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, context.getX(), context.getY(), width, height);
        if (addedClass.eResource() == null) {
            this.getDiagram().eResource().getContents().add((Object)addedClass);
        }
        this.link((PictogramElement)containerShape, addedClass);
        Shape shape = peCreateService.createShape(containerShape, false);
        int[] nArray = new int[4];
        nArray[1] = 20;
        nArray[2] = width;
        nArray[3] = 20;
        Polyline polyline = gaService.createPolyline((GraphicsAlgorithmContainer)shape, nArray);
        polyline.setForeground(this.manageColor(ColorDisplay.BLACK));
        polyline.setLineWidth(Integer.valueOf(2));
        shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)shape, addedClass.getName());
        text.setForeground(this.manageColor(ColorDisplay.CLASS_TEXT_FOREGROUND));
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(gaService.manageFont(this.getDiagram(), "Arial", 12, false, true));
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, width, 20);
        this.link((PictogramElement)shape, addedClass);
        Shape shape2 = peCreateService.createShape(containerShape, false);
        Object variables = "";
        for (EVariable var : addedClass.getVariables()) {
            variables = (String)variables + (var.getType().isEmpty() ? "var" : var.getType()) + " " + var.getName() + "\n";
        }
        Text text2 = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)shape2, (String)variables);
        text2.setForeground(this.manageColor(ColorDisplay.CLASS_TEXT_FOREGROUND));
        text2.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text2.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        text2.setFont(gaService.manageFont(this.getDiagram(), "Arial", 12, false, false));
        gaService.setLocationAndSize((GraphicsAlgorithm)text2, 5, 25, text2.getWidth(), 25 + addedClass.getVariables().size() * 20);
        this.link((PictogramElement)shape2, addedClass);
        Shape shape3 = peCreateService.createShape(containerShape, false);
        Image icon1 = gaService.createImage((GraphicsAlgorithmContainer)shape3, "gama.ui.diagram.subgridlink");
        gaService.setLocationAndSize((GraphicsAlgorithm)icon1, 20 - width / 2, 3, 30, 15);
        this.link((PictogramElement)shape3, addedClass);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }
}

