/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.add;

import gama.ui.diagram.features.add.ColorDisplay;
import gama.ui.diagram.metamodel.ERule;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class AddRuleFeature
extends AbstractAddShapeFeature {
    public static final int INIT_WIDTH = 150;
    public static final int INIT_HEIGHT = 50;
    private static final List<Integer> CLASS_BACKGROUND = Arrays.asList(255, 180, 28);

    public AddRuleFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof ERule && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        ERule addedClass = (ERule)context.getNewObject();
        boolean error = addedClass.getHasError() != null && addedClass.getHasError() != false;
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        int width = context.getWidth() <= 0 ? 150 : context.getWidth();
        int height = context.getHeight() <= 0 ? 50 : context.getHeight();
        IGaService gaService = Graphiti.getGaService();
        Ellipse ellipse = gaService.createEllipse((GraphicsAlgorithmContainer)containerShape);
        ellipse.setForeground(this.manageColor(error ? ColorDisplay.CLASS_FOREGROUND_ERROR : ColorDisplay.CLASS_FOREGROUND_OK));
        if (addedClass.getColorPicto().isEmpty()) {
            addedClass.getColorPicto().addAll(CLASS_BACKGROUND);
        }
        EList<Integer> currentColor = addedClass.getColorPicto();
        Color color = gaService.manageColor(this.getDiagram(), ((Integer)currentColor.get(0)).intValue(), ((Integer)currentColor.get(1)).intValue(), ((Integer)currentColor.get(2)).intValue());
        ellipse.setBackground(color);
        ellipse.setLineWidth(Integer.valueOf(error ? 4 : 2));
        gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, context.getX(), context.getY(), width, height);
        if (addedClass.eResource() == null) {
            this.getDiagram().eResource().getContents().add((Object)addedClass);
        }
        this.link((PictogramElement)containerShape, addedClass);
        Shape shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)shape, addedClass.getName());
        text.setForeground(this.manageColor(ColorDisplay.CLASS_TEXT_FOREGROUND));
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(gaService.manageFont(this.getDiagram(), "Arial", 12, false, false));
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, width, height);
        this.link((PictogramElement)shape, addedClass);
        Shape shape3 = peCreateService.createShape(containerShape, false);
        Image icon1 = gaService.createImage((GraphicsAlgorithmContainer)shape3, "gama.ui.diagram.reflexlink");
        gaService.setLocationAndSize((GraphicsAlgorithm)icon1, 100, 100, 15, 15);
        this.link((PictogramElement)shape3, addedClass);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }
}

