/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EActionLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateActionLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create action";
    private static final String USER_QUESTION = "Enter new action name";

    public CreateActionLinkFeature(IFeatureProvider fp) {
        super(fp, "has the action", "Create action link");
    }

    private EAction createEAction(ICreateConnectionContext context, ESpecies source) {
        Object newActionName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_action");
        if (newActionName == null || ((String)newActionName).trim().length() == 0) {
            return null;
        }
        String initName = newActionName;
        ArrayList<String> names = new ArrayList<String>();
        for (EActionLink li : source.getActionLinks()) {
            names.add(li.getAction().getName());
        }
        int cpt = 2;
        while (names.contains(newActionName)) {
            newActionName = initName + cpt;
            ++cpt;
        }
        EAction newAction = GamaFactory.eINSTANCE.createEAction();
        newAction.setError("");
        newAction.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newAction);
        newAction.setName((String)newActionName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newAction;
    }

    private PictogramElement addEAction(ICreateConnectionContext context, EAction action) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)action));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        EAction target = this.createEAction(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEAction(context, target);
            EActionLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setAction(target);
            source.getActionLinks().add((Object)eReference);
            target.getActionLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private EActionLink createEReference(ESpecies source, EAction target) {
        EActionLink eReference = GamaFactory.eINSTANCE.createEActionLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.actionlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }
}

