/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateAspectLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create aspect";
    private static final String USER_QUESTION = "Enter new aspect name";

    public CreateAspectLinkFeature(IFeatureProvider fp) {
        super(fp, "has the aspect", "Create aspect link");
    }

    private EAspect createEAspect(ICreateConnectionContext context, ESpecies source) {
        Object newAspectName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_aspect");
        if (newAspectName == null || ((String)newAspectName).trim().length() == 0) {
            return null;
        }
        String initName = newAspectName;
        ArrayList<String> names = new ArrayList<String>();
        for (EAspectLink li : source.getAspectLinks()) {
            names.add(li.getAspect().getName());
        }
        int cpt = 2;
        while (names.contains(newAspectName)) {
            newAspectName = initName + cpt;
            ++cpt;
        }
        EAspect newAspect = GamaFactory.eINSTANCE.createEAspect();
        newAspect.setDefineGamlCode(false);
        newAspect.setError("");
        newAspect.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newAspect);
        newAspect.setName((String)newAspectName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newAspect;
    }

    private PictogramElement addEAspect(ICreateConnectionContext context, EAspect aspect) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)aspect));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        EAspect target = this.createEAspect(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEAspect(context, target);
            EAspectLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setAspect(target);
            source.getAspectLinks().add((Object)eReference);
            target.getAspectLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private EAspectLink createEReference(ESpecies source, EAspect target) {
        EAspectLink eReference = GamaFactory.eINSTANCE.createEAspectLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.aspectlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }
}

