/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EBatchExperiment;
import gama.ui.diagram.metamodel.EExperiment;
import gama.ui.diagram.metamodel.EExperimentLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.ESubSpeciesLink;
import gama.ui.diagram.metamodel.EWorldAgent;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class CreateBatchExperimentLinkFeature
extends AbstractCreateConnectionFeature {
    private static final String TITLE = "Create a batch experiment";
    private static final String USER_QUESTION = "Enter new batch experiment name";

    public CreateBatchExperimentLinkFeature(IFeatureProvider fp) {
        super(fp, "is composed of a batch experiment", "Create a new batch experiment");
    }

    private EBatchExperiment createEBatchExperiment(ICreateConnectionContext context, ESpecies source) {
        Object newBatchName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_batch_xp");
        if (newBatchName == null || ((String)newBatchName).length() == 0) {
            return null;
        }
        String initName = newBatchName;
        ArrayList<String> names = new ArrayList<String>();
        for (ESubSpeciesLink li : source.getMicroSpeciesLinks()) {
            names.add(li.getMicro().getName());
        }
        int cpt = 2;
        while (names.contains(newBatchName)) {
            newBatchName = initName + cpt;
            ++cpt;
        }
        EBatchExperiment newBatchExp = GamaFactory.eINSTANCE.createEBatchExperiment();
        newBatchExp.setError("");
        newBatchExp.setHasError(false);
        newBatchExp.setName((String)newBatchName);
        this.getDiagram().eResource().getContents().add((Object)newBatchExp);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newBatchExp;
    }

    private PictogramElement addEBatchExperiment(ICreateConnectionContext context, EBatchExperiment batchExp) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 150, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)batchExp));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        EWorldAgent source = this.getEWorldAgent(context.getSourceAnchor());
        EBatchExperiment target = this.createEBatchExperiment(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEBatchExperiment(context, target);
            EExperimentLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setExperiment(target);
            eReference.setSpecies(source);
            source.getExperimentLinks().add((Object)eReference);
            target.setExperimentLink(eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        EWorldAgent source = this.getEWorldAgent(context.getSourceAnchor());
        return source != null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getEWorldAgent(context.getSourceAnchor()) != null;
    }

    protected EWorldAgent getEWorldAgent(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof EWorldAgent) {
            return (EWorldAgent)object;
        }
        return null;
    }

    protected Anchor getAnchor(PictogramElement targetpe) {
        Anchor ret = null;
        if (targetpe instanceof Anchor) {
            ret = (Anchor)targetpe;
        } else if (targetpe instanceof AnchorContainer) {
            ret = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)targetpe);
        }
        return ret;
    }

    private EExperimentLink createEReference(EWorldAgent source, EExperiment target) {
        EExperimentLink eReference = GamaFactory.eINSTANCE.createEExperimentLink();
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.batchxplink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }
}

