/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EDisplayLink;
import gama.ui.diagram.metamodel.EExperiment;
import gama.ui.diagram.metamodel.EGUIExperiment;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public class CreateDisplayLinkFeature
extends AbstractCreateConnectionFeature {
    private static final String TITLE = "Create display";
    private static final String USER_QUESTION = "Enter new display name";

    public CreateDisplayLinkFeature(IFeatureProvider fp) {
        super(fp, "has the display", "Create display link");
    }

    public boolean canCreate(ICreateConnectionContext context) {
        EGUIExperiment source = this.getEExperiment(context.getSourceAnchor());
        return source != null;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getEExperiment(context.getSourceAnchor()) != null;
    }

    private EDisplay createEDisplay(ICreateConnectionContext context, boolean askName, EExperiment source) {
        Object newDisplayName = "my_display";
        if (askName && ((newDisplayName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_display")) == null || ((String)newDisplayName).trim().length() == 0)) {
            return null;
        }
        String initName = newDisplayName;
        ArrayList<String> names = new ArrayList<String>();
        for (EDisplayLink li : source.getDisplayLinks()) {
            names.add(li.getDisplay().getName());
        }
        int cpt = 2;
        while (names.contains(newDisplayName)) {
            newDisplayName = initName + cpt;
            ++cpt;
        }
        EDisplay newDisplay = GamaFactory.eINSTANCE.createEDisplay();
        newDisplay.setDefineGamlCode(false);
        newDisplay.setError("");
        newDisplay.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newDisplay);
        newDisplay.setName((String)newDisplayName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newDisplay;
    }

    private PictogramElement addEDisplay(ICreateConnectionContext context, EDisplay Display2) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 70, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)Display2));
    }

    public Connection create(ICreateConnectionContext context) {
        return this.create(context, true);
    }

    public Connection create(ICreateConnectionContext context, boolean askName) {
        Connection newConnection = null;
        EGUIExperiment source = this.getEExperiment(context.getSourceAnchor());
        EDisplay target = this.createEDisplay(context, askName, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEDisplay(context, target);
            EDisplayLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setExperiment(source);
            eReference.setDisplay(target);
            source.getDisplayLinks().add((Object)eReference);
            target.setDisplayLink(eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private EGUIExperiment getEExperiment(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof EGUIExperiment) {
            return (EGUIExperiment)object;
        }
        return null;
    }

    protected Anchor getAnchor(PictogramElement targetpe) {
        Anchor ret = null;
        if (targetpe instanceof Anchor) {
            ret = (Anchor)targetpe;
        } else if (targetpe instanceof AnchorContainer) {
            ret = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)targetpe);
        }
        return ret;
    }

    private EDisplayLink createEReference(EGUIExperiment source, EDisplay target) {
        EDisplayLink eReference = GamaFactory.eINSTANCE.createEDisplayLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.displaylink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }
}

