/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.EPlan;
import gama.ui.diagram.metamodel.EPlanLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreatePlanLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create plan";
    private static final String USER_QUESTION = "Enter new plan name";

    public CreatePlanLinkFeature(IFeatureProvider fp) {
        super(fp, "has the plan", "Create plan link");
    }

    private EPlan createEPlan(ICreateConnectionContext context, ESpecies source) {
        Object newPlanName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_plan");
        if (newPlanName == null || ((String)newPlanName).trim().length() == 0) {
            return null;
        }
        String initName = newPlanName;
        ArrayList<String> names = new ArrayList<String>();
        for (EPlanLink li : source.getPlanLinks()) {
            names.add(li.getPlan().getName());
        }
        int cpt = 2;
        while (names.contains(newPlanName)) {
            newPlanName = initName + cpt;
            ++cpt;
        }
        EPlan newPlan = GamaFactory.eINSTANCE.createEPlan();
        newPlan.setError("");
        newPlan.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newPlan);
        newPlan.setName((String)newPlanName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newPlan;
    }

    private PictogramElement addEPlan(ICreateConnectionContext context, EPlan plan) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)plan));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        EPlan target = this.createEPlan(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEPlan(context, target);
            EPlanLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setPlan(target);
            source.getPlanLinks().add((Object)eReference);
            target.getPlanLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private EPlanLink createEReference(ESpecies source, EPlan target) {
        EPlanLink eReference = GamaFactory.eINSTANCE.createEPlanLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.reflexlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }

    @Override
    protected ESpecies getESpecies(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof ESpecies) {
            ESpecies species = (ESpecies)object;
            for (EFacet facet : species.getFacets()) {
                if (!facet.getName().equals("control")) continue;
                if (!"simple_bdi".equals(facet.getValue()) && !"parallel_bdi".equals(facet.getValue())) break;
                return (ESpecies)object;
            }
        }
        return null;
    }
}

