/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateReflexLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create reflex";
    private static final String USER_QUESTION = "Enter new reflex name";

    public CreateReflexLinkFeature(IFeatureProvider fp) {
        super(fp, "has the reflex", "Create reflex link");
    }

    private EReflex createEReflex(ICreateConnectionContext context, ESpecies source) {
        Object newReflexName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_reflex");
        if (newReflexName == null || ((String)newReflexName).trim().length() == 0) {
            return null;
        }
        String initName = newReflexName;
        ArrayList<String> names = new ArrayList<String>();
        for (EReflexLink li : source.getReflexLinks()) {
            names.add(li.getReflex().getName());
        }
        int cpt = 2;
        while (names.contains(newReflexName)) {
            newReflexName = initName + cpt;
            ++cpt;
        }
        EReflex newReflex = GamaFactory.eINSTANCE.createEReflex();
        newReflex.setError("");
        newReflex.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newReflex);
        newReflex.setName((String)newReflexName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newReflex;
    }

    private PictogramElement addEReflex(ICreateConnectionContext context, EReflex action) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)action));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        EReflex target = this.createEReflex(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEReflex(context, target);
            EReflexLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setReflex(target);
            source.getReflexLinks().add((Object)eReference);
            target.getReflexLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private EReflexLink createEReference(ESpecies source, EReflex target) {
        EReflexLink eReference = GamaFactory.eINSTANCE.createEReflexLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.reflexlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }
}

