/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.ERule;
import gama.ui.diagram.metamodel.ERuleLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateRuleLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create rule";
    private static final String USER_QUESTION = "Enter new rule name";

    public CreateRuleLinkFeature(IFeatureProvider fp) {
        super(fp, "has the rule", "Create rule link");
    }

    private ERule createERule(ICreateConnectionContext context, ESpecies source) {
        Object newRuleName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_rule");
        if (newRuleName == null || ((String)newRuleName).trim().length() == 0) {
            return null;
        }
        String initName = newRuleName;
        ArrayList<String> names = new ArrayList<String>();
        for (ERuleLink li : source.getRuleLinks()) {
            names.add(li.getRule().getName());
        }
        int cpt = 2;
        while (names.contains(newRuleName)) {
            newRuleName = initName + cpt;
            ++cpt;
        }
        ERule newRule = GamaFactory.eINSTANCE.createERule();
        newRule.setError("");
        newRule.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newRule);
        newRule.setName((String)newRuleName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newRule;
    }

    private PictogramElement addERule(ICreateConnectionContext context, ERule plan) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)plan));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        ERule target = this.createERule(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addERule(context, target);
            ERuleLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setRule(target);
            source.getRuleLinks().add((Object)eReference);
            target.getRuleLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private ERuleLink createEReference(ESpecies source, ERule target) {
        ERuleLink eReference = GamaFactory.eINSTANCE.createERuleLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.reflexlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }

    @Override
    protected ESpecies getESpecies(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof ESpecies) {
            ESpecies species = (ESpecies)object;
            for (EFacet facet : species.getFacets()) {
                if (!facet.getName().equals("control")) continue;
                if (!"simple_bdi".equals(facet.getValue()) && !"parallel_bdi".equals(facet.getValue())) break;
                return (ESpecies)object;
            }
        }
        return null;
    }
}

