/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EState;
import gama.ui.diagram.metamodel.EStateLink;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateStateLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create state";
    private static final String USER_QUESTION = "Enter new state name";

    public CreateStateLinkFeature(IFeatureProvider fp) {
        super(fp, "has the state", "Create state link");
    }

    private EState createEState(ICreateConnectionContext context, ESpecies source) {
        Object newStateName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_state");
        if (newStateName == null || ((String)newStateName).trim().length() == 0) {
            return null;
        }
        String initName = newStateName;
        ArrayList<String> names = new ArrayList<String>();
        for (EStateLink li : source.getStateLinks()) {
            names.add(li.getState().getName());
        }
        int cpt = 2;
        while (names.contains(newStateName)) {
            newStateName = initName + cpt;
            ++cpt;
        }
        EState newState = GamaFactory.eINSTANCE.createEState();
        newState.setError("");
        newState.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newState);
        newState.setName((String)newStateName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newState;
    }

    private PictogramElement addEState(ICreateConnectionContext context, EState action) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)action));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        EState target = this.createEState(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addEState(context, target);
            EStateLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setState(target);
            source.getStateLinks().add((Object)eReference);
            target.getStateLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        if (source.getStateLinks().size() == 1) {
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setValue("true");
            facet.setName("initial");
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
        }
        return newConnection;
    }

    private EStateLink createEReference(ESpecies source, EState target) {
        EStateLink eReference = GamaFactory.eINSTANCE.createEStateLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.reflexlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }

    @Override
    protected ESpecies getESpecies(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof ESpecies) {
            ESpecies species = (ESpecies)object;
            for (EFacet facet : species.getFacets()) {
                if (!facet.getName().equals("control")) continue;
                if (!"fsm".equals(facet.getValue())) break;
                return (ESpecies)object;
            }
        }
        return null;
    }
}

