/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.ESubSpeciesLink;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateSubSpeciesLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create species";
    private static final String USER_QUESTION = "Enter new species name";

    public CreateSubSpeciesLinkFeature(IFeatureProvider fp) {
        super(fp, "is composed of a species", "Create a new species");
    }

    private ESpecies createESpecies(ICreateConnectionContext context, ESpecies source) {
        Object newSpeciesName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_species");
        if (newSpeciesName == null || ((String)newSpeciesName).trim().length() == 0) {
            return null;
        }
        String initName = newSpeciesName;
        ArrayList<String> names = new ArrayList<String>();
        for (ESubSpeciesLink li : source.getMicroSpeciesLinks()) {
            if (li.getMicro() == null) continue;
            names.add(li.getMicro().getName());
        }
        int cpt = 2;
        while (names.contains(newSpeciesName)) {
            newSpeciesName = initName + cpt;
            ++cpt;
        }
        ESpecies newSpecies = GamaFactory.eINSTANCE.createESpecies();
        newSpecies.setError("");
        newSpecies.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newSpecies);
        this.updatePictogramElement((PictogramElement)this.getDiagram());
        System.out.println("this.getDiagram().eResource().getContents(): " + String.valueOf(this.getDiagram().eResource().getContents()));
        newSpecies.setName((String)newSpeciesName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newSpecies;
    }

    private PictogramElement addESpecies(ICreateConnectionContext context, ESpecies species) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 110, context.getTargetLocation().getY() - 50);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)species));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        ESpecies target = this.createESpecies(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addESpecies(context, target);
            ESubSpeciesLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setMacro(source);
            eReference.setMicro(target);
            source.getMicroSpeciesLinks().add((Object)eReference);
            target.getMacroSpeciesLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        return newConnection;
    }

    private ESubSpeciesLink createEReference(ESpecies source, ESpecies target) {
        ESubSpeciesLink eReference = GamaFactory.eINSTANCE.createESubSpeciesLink();
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.subspecieslink";
    }

    public void execute(IContext context) {
        super.execute(context);
    }
}

