/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.create;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.create.AbstractCreateSpeciesComponentLinkFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.ETask;
import gama.ui.diagram.metamodel.ETaskLink;
import gama.ui.diagram.metamodel.GamaFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateTaskLinkFeature
extends AbstractCreateSpeciesComponentLinkFeature {
    private static final String TITLE = "Create task";
    private static final String USER_QUESTION = "Enter new task name";
    List<String> archiName = Arrays.asList("probabilistic_tasks", "sorted_tasks", "weighted_tasks");

    public CreateTaskLinkFeature(IFeatureProvider fp) {
        super(fp, "has the task", "Create task link");
    }

    private ETask createETask(ICreateConnectionContext context, ESpecies source) {
        Object newTaskName = ExampleUtil.askString(TITLE, USER_QUESTION, "my_task");
        if (newTaskName == null || ((String)newTaskName).trim().length() == 0) {
            return null;
        }
        String initName = newTaskName;
        ArrayList<String> names = new ArrayList<String>();
        for (ETaskLink li : source.getTaskLinks()) {
            names.add(li.getTask().getName());
        }
        int cpt = 2;
        while (names.contains(newTaskName)) {
            newTaskName = initName + cpt;
            ++cpt;
        }
        ETask newTask = GamaFactory.eINSTANCE.createETask();
        newTask.setError("");
        newTask.setHasError(false);
        this.getDiagram().eResource().getContents().add((Object)newTask);
        newTask.setName((String)newTaskName);
        CreateContext ac = new CreateContext();
        ac.setLocation(context.getTargetLocation().getX(), context.getTargetLocation().getY());
        ac.setSize(0, 0);
        ac.setTargetContainer((ContainerShape)this.getDiagram());
        return newTask;
    }

    private PictogramElement addETask(ICreateConnectionContext context, ETask task) {
        CreateContext cc = new CreateContext();
        cc.setLocation(context.getTargetLocation().getX() - 75, context.getTargetLocation().getY() - 25);
        cc.setSize(0, 0);
        cc.setTargetContainer((ContainerShape)this.getDiagram());
        return this.getFeatureProvider().addIfPossible((IAddContext)new AddContext((IAreaContext)cc, (Object)task));
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        ESpecies source = this.getESpecies(context.getSourceAnchor());
        ETask target = this.createETask(context, source);
        if (source != null && target != null) {
            PictogramElement targetpe = this.addETask(context, target);
            ETaskLink eReference = this.createEReference(source, target);
            this.getDiagram().eResource().getContents().add((Object)eReference);
            AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), this.getAnchor(targetpe));
            addContext.setNewObject((Object)eReference);
            newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            eReference.setSpecies(source);
            eReference.setTask(target);
            source.getTaskLinks().add((Object)eReference);
            target.getTaskLinks().add((Object)eReference);
        }
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.getFeatureProvider());
        diagramEditor.addEOject(target);
        if (source.getStateLinks().size() == 1) {
            EFacet facet = GamaFactory.eINSTANCE.createEFacet();
            facet.setValue("1");
            facet.setName("weight");
            facet.setOwner(target);
            target.getFacets().add((Object)facet);
        }
        return newConnection;
    }

    private ETaskLink createEReference(ESpecies source, ETask target) {
        ETaskLink eReference = GamaFactory.eINSTANCE.createETaskLink();
        eReference.setSource(source);
        eReference.setTarget(target);
        return eReference;
    }

    public String getCreateImageId() {
        return "gama.ui.diagram.reflexlink";
    }

    public void execute(IContext context) {
        super.execute(context);
        ModelGenerator.modelValidation(this.getFeatureProvider(), this.getDiagram());
    }

    @Override
    protected ESpecies getESpecies(Anchor anchor) {
        Object object;
        if (anchor != null && (object = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof ESpecies) {
            ESpecies species = (ESpecies)object;
            for (EFacet facet : species.getFacets()) {
                if (!facet.getName().equals("control")) continue;
                if (!this.archiName.contains(facet.getValue())) break;
                return (ESpecies)object;
            }
        }
        return null;
    }
}

