/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.layout;

import gama.ui.diagram.metamodel.EGamaObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutCommonFeature
extends AbstractLayoutFeature {
    private static final int MIN_HEIGHT = 50;
    private static final int MIN_WIDTH = 120;

    public LayoutCommonFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        EList businessObjects = pe.getLink().getBusinessObjects();
        return businessObjects.size() == 1 && businessObjects.get(0) instanceof EGamaObject;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        IGaService gaService = Graphiti.getGaService();
        PictogramElement pe = context.getPictogramElement();
        EList businessObjects = pe.getLink().getBusinessObjects();
        if (businessObjects != null) {
            EGamaObject obj = (EGamaObject)businessObjects.get(0);
            EList<Integer> currentColor = obj.getColorPicto();
            Color color = gaService.manageColor(this.getDiagram(), ((Integer)currentColor.get(0)).intValue(), ((Integer)currentColor.get(1)).intValue(), ((Integer)currentColor.get(2)).intValue());
            containerGa.setBackground(color);
        }
        if (containerGa.getHeight() < 50) {
            containerGa.setHeight(50);
            anythingChanged = true;
        }
        if (containerGa.getWidth() < 120) {
            containerGa.setWidth(120);
            anythingChanged = true;
        }
        int containerWidth = containerGa.getWidth();
        int containerHeight = containerGa.getHeight();
        for (Shape shape : containerShape.getChildren()) {
            GraphicsAlgorithm graphicsAlgorithm = shape.getGraphicsAlgorithm();
            IDimension size = gaService.calculateSize(graphicsAlgorithm);
            if (containerWidth == size.getWidth() && containerHeight == size.getHeight()) continue;
            if (graphicsAlgorithm instanceof Text) {
                Text text = (Text)graphicsAlgorithm;
                gaService.setWidth((GraphicsAlgorithm)text, containerWidth);
                gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, 0, containerWidth, containerHeight);
                anythingChanged = true;
                continue;
            }
            if (graphicsAlgorithm instanceof Image) {
                Image im = (Image)graphicsAlgorithm;
                gaService.setLocation((GraphicsAlgorithm)im, 10, containerGa.getHeight() / 2 - 8);
                anythingChanged = true;
                continue;
            }
            gaService.setWidth(graphicsAlgorithm, containerWidth);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

