/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.layout;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class LayoutDiagramFeature
extends AbstractCustomFeature {
    private static final int PADDING = 30;

    public LayoutDiagramFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return "Layout diagram";
    }

    public String getName() {
        return "&Layout Diagram";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        CompoundDirectedGraph graph = LayoutDiagramFeature.mapDiagramToGraph(this.getDiagram());
        graph.setDefaultPadding(new Insets(30));
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        LayoutDiagramFeature.mapGraphCoordinatesToDiagram(graph);
    }

    public static void execute(Diagram d) {
        CompoundDirectedGraph graph = LayoutDiagramFeature.mapDiagramToGraph(d);
        graph.setDefaultPadding(new Insets(30));
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        LayoutDiagramFeature.mapGraphCoordinatesToDiagram(graph);
    }

    private static Diagram mapGraphCoordinatesToDiagram(CompoundDirectedGraph graph) {
        NodeList myNodes = new NodeList();
        myNodes.addAll((Collection)graph.nodes);
        myNodes.addAll((Collection)graph.subgraphs);
        for (Object object : myNodes) {
            Node node = (Node)object;
            Shape shape = (Shape)node.data;
            shape.getGraphicsAlgorithm().setX(node.x);
            shape.getGraphicsAlgorithm().setY(node.y);
            shape.getGraphicsAlgorithm().setWidth(node.width);
            shape.getGraphicsAlgorithm().setHeight(node.height);
        }
        return null;
    }

    private static CompoundDirectedGraph mapDiagramToGraph(Diagram d) {
        HashMap<Shape, Node> shapeToNode = new HashMap<Shape, Node>();
        CompoundDirectedGraph dg = new CompoundDirectedGraph();
        EdgeList edgeList = new EdgeList();
        NodeList nodeList = new NodeList();
        EList children = d.getChildren();
        for (Shape shape : children) {
            Node node = new Node();
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            node.x = ga.getX();
            node.y = ga.getY();
            node.width = ga.getWidth();
            node.height = ga.getHeight();
            node.data = shape;
            shapeToNode.put(shape, node);
            nodeList.add((Object)node);
        }
        EList connections = d.getConnections();
        for (Connection connection : connections) {
            AnchorContainer source = connection.getStart().getParent();
            AnchorContainer target = connection.getEnd().getParent();
            Edge edge = new Edge((Node)shapeToNode.get(source), (Node)shapeToNode.get(target));
            edge.data = connection;
            edgeList.add((Object)edge);
        }
        dg.nodes = nodeList;
        dg.edges = edgeList;
        return dg;
    }
}

