/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.layout;

import gama.ui.diagram.metamodel.EGamaObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutEExperimentFeature
extends AbstractLayoutFeature {
    private static final int MIN_HEIGHT = 50;
    private static final int MIN_WIDTH = 150;

    public LayoutEExperimentFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        EList businessObjects = pe.getLink().getBusinessObjects();
        return businessObjects.size() == 1 && businessObjects.get(0) instanceof EGamaObject;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        IGaService gaService = Graphiti.getGaService();
        PictogramElement pe = context.getPictogramElement();
        EList businessObjects = pe.getLink().getBusinessObjects();
        if (businessObjects != null) {
            EGamaObject obj = (EGamaObject)businessObjects.get(0);
            EList<Integer> currentColor = obj.getColorPicto();
            Color color = gaService.manageColor(this.getDiagram(), ((Integer)currentColor.get(0)).intValue(), ((Integer)currentColor.get(1)).intValue(), ((Integer)currentColor.get(2)).intValue());
            containerGa.setBackground(color);
        }
        if (containerGa.getHeight() < 50) {
            containerGa.setHeight(50);
            anythingChanged = true;
        }
        if (containerGa.getWidth() < 150) {
            containerGa.setWidth(150);
            anythingChanged = true;
        }
        int containerWidth = containerGa.getWidth();
        for (Shape shape : containerShape.getChildren()) {
            GraphicsAlgorithm graphicsAlgorithm = shape.getGraphicsAlgorithm();
            IDimension size = gaService.calculateSize(graphicsAlgorithm);
            if (containerWidth == size.getWidth()) continue;
            if (graphicsAlgorithm instanceof Polyline) {
                Polyline polyline = (Polyline)graphicsAlgorithm;
                Point secondPoint = (Point)polyline.getPoints().get(1);
                Point newSecondPoint = gaService.createPoint(containerWidth, secondPoint.getY());
                polyline.getPoints().set(1, (Object)newSecondPoint);
                anythingChanged = true;
                continue;
            }
            if (graphicsAlgorithm instanceof Image) {
                Image im = (Image)graphicsAlgorithm;
                gaService.setLocation((GraphicsAlgorithm)im, 5 + im.getWidth() / 2 - size.getWidth() / 2, 3);
                anythingChanged = true;
                continue;
            }
            gaService.setWidth(graphicsAlgorithm, containerWidth);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

