/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.modelgeneration;

import gama.core.runtime.GAMA;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.ui.editor.GamlEditor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.util.StringInputStream;

public class ModelGenerationFeature
extends AbstractCustomFeature {
    public ModelGenerationFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Generate Gaml model";
    }

    public String getDescription() {
        return "Generate Gaml model from diagram";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        File file;
        String gamlModel = ModelGenerator.generateModel(this.getFeatureProvider(), this.getDiagram(), null);
        EList contents = this.getDiagram().getChildren();
        URI uri = null;
        if (contents == null) {
            return;
        }
        uri = EcoreUtil.getURI((EObject)((EObject)this.getBusinessObjectForPictogramElement((PictogramElement)contents.get(0))));
        if ((uri = uri.trimFragment()).isPlatform()) {
            uri = URI.createURI((String)uri.toPlatformString(true));
        }
        String containerStr = "/" + uri.segment(0);
        Object path = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation()) + uri.path();
        path = ((String)path).replace("diagrams/", "models/");
        File folder = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation()) + containerStr + "/models");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ((file = new File((String)(path = ((String)path).replace(".gadl", ".gaml")))).exists()) {
            file.delete();
        }
        try {
            FileUtils.forceMkdirParent((File)file);
            FileWriter fw = new FileWriter(file, false);
            fw.write(gamlModel);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerStr));
        IProject project = resource.getProject();
        IFolder container = project.getFolder((IPath)new Path("models/"));
        IFile fileP = container.getFile((IPath)new Path(uri.lastSegment().replace(".gadl", ".gaml")));
        try {
            Throwable throwable = null;
            Object var16_19 = null;
            try (StringInputStream source = new StringInputStream(gamlModel);){
                if (!container.exists()) {
                    container.create(true, true, null);
                }
                fileP.create((InputStream)source, true, null);
                fileP.refreshLocal(1, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            e.printStackTrace();
        }
        GAMA.getGui().editModel((Object)fileP);
        this.doFinish(fileP);
    }

    private void doFinish(IFile file) {
        WorkbenchHelper.asyncRun(() -> {
            IWorkbenchPage page = WorkbenchHelper.getPage();
            try {
                IEditorPart ed = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                if (ed instanceof GamlEditor) {
                    ((GamlEditor)ed).getAction("Format").run();
                    ed.doSave(null);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        });
    }
}

