/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.modelgeneration;

import com.google.common.collect.Iterables;
import gama.core.kernel.model.IModel;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.descriptions.ModelDescription;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.editor.ModelStructure;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EActionLink;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.EBatchExperiment;
import gama.ui.diagram.metamodel.EChartLayer;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EDisplayLink;
import gama.ui.diagram.metamodel.EEquation;
import gama.ui.diagram.metamodel.EExperiment;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.EGamaLink;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.EGrid;
import gama.ui.diagram.metamodel.ELayer;
import gama.ui.diagram.metamodel.ELayerAspect;
import gama.ui.diagram.metamodel.EMonitor;
import gama.ui.diagram.metamodel.EParameter;
import gama.ui.diagram.metamodel.EPerceive;
import gama.ui.diagram.metamodel.EPlan;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ERule;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EState;
import gama.ui.diagram.metamodel.ETask;
import gama.ui.diagram.metamodel.EVariable;
import gama.ui.diagram.metamodel.EWorldAgent;
import gaml.compiler.gaml.resource.GamlResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;

public class ModelGenerator {
    private static String EL = System.lineSeparator();

    private static ModelDescription buildModelDescription(GamlResource r, List<GamlCompilationError> errors) {
        if (r.hasErrors()) {
            if (errors != null) {
                errors.add(new GamlCompilationError("Syntax errors ", "gaml.general.issue", (EObject)r.getContents().get(0), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]));
            }
            return null;
        }
        ModelDescription model = r.buildCompleteDescription();
        if (errors != null) {
            Iterables.addAll(errors, (Iterable)r.getValidationContext());
        }
        return model;
    }

    public static IModel modelGeneration(IFeatureProvider fp, Diagram diagram) {
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(fp);
        diagramEditor.initIdsEObjects();
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        URI du = diagramEditor.getDiagramEditorInput().getUri();
        URI uri = URI.createURI((String)du.trimFragment().toString().replace(".gadl", ".gaml"), (boolean)true);
        GamlResource resource = (GamlResource)rs.createResource(uri);
        String gamlModel = ModelGenerator.generateModel(fp, diagram, null);
        ByteArrayInputStream is = new ByteArrayInputStream(gamlModel.getBytes());
        diagramEditor.setResource(resource);
        try {
            resource.load((InputStream)is, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            HashSet<GamlResource> resources = new HashSet<GamlResource>();
            resources.add(resource);
            ModelDescription modeldesc = ModelGenerator.buildModelDescription(resource, new ArrayList<GamlCompilationError>());
            return modeldesc == null ? null : (IModel)modeldesc.compile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPath(IFeatureProvider fp, Diagram diagram) {
        EList contents = diagram.getChildren();
        URI uri = null;
        if (contents == null) {
            return "";
        }
        uri = EcoreUtil.getURI((EObject)((EObject)fp.getBusinessObjectForPictogramElement((PictogramElement)contents.get(0))));
        if ((uri = uri.trimFragment()).isPlatform()) {
            uri = URI.createURI((String)uri.toPlatformString(true));
        }
        Object path = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation()) + uri.path();
        path = ((String)path).replace(".gadl", ".gaml");
        return path;
    }

    public static String getFolder(IFeatureProvider fp, Diagram diagram) {
        String path = ModelGenerator.getPath(fp, diagram);
        String[] pp = path.split("/");
        StringBuilder pF = new StringBuilder();
        int i = 0;
        while (i < pp.length - 1) {
            pF.append(pp[i]).append("/");
            ++i;
        }
        return pF.toString();
    }

    public static boolean hasSyntaxError(IFeatureProvider fp, String expression, boolean isExpression) {
        return ModelGenerator.hasSyntaxError(fp, expression, isExpression, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasSyntaxError(IFeatureProvider fp, String expression, boolean isExpression, boolean isString) {
        if (expression.replace(" ", "").isEmpty()) {
            return false;
        }
        URI du = ((GamaDiagramEditor)ExampleUtil.getDiagramEditor(fp)).getDiagramEditorInput().getUri();
        URI uri = URI.createURI((String)du.trimFragment().toString().replace(".gadl", ".gaml"), (boolean)true);
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        String gamlModel = "model toto2733663525\nglobal{init{" + (isExpression ? "string _toto_t <-" : "") + (isString ? "\"" : "") + expression + (isString ? "\"" : "") + (isExpression ? ";" : "") + "}}";
        ByteArrayInputStream is = new ByteArrayInputStream(gamlModel.getBytes());
        GamlResource resource = (GamlResource)rs.createResource(uri);
        try {
            resource.load((InputStream)is, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            GamlCompilationError error;
            resource.validate();
            Iterator iterator = resource.getValidationContext().getInternalErrors().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(error = (GamlCompilationError)iterator.next()).isError() || !"Syntax errors detected ".equals(error.toString()));
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static List<GamlCompilationError> modelValidation(IFeatureProvider fp, Diagram diagram) {
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(fp);
        diagramEditor.initIdsEObjects();
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        URI du = diagramEditor.getDiagramEditorInput().getUri();
        URI uri = URI.createURI((String)du.trimFragment().toString().replace(".gadl", ".gaml"), (boolean)true);
        GamlResource resource = (GamlResource)rs.createResource(uri);
        String gamlModel = ModelGenerator.generateModel(fp, diagram, null);
        if ("".equals(gamlModel)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(gamlModel.getBytes());
        diagramEditor.setResource(resource);
        try {
            resource.load((InputStream)is, null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            resource.getValidationContext().clear();
            resource.validate();
            ArrayList<GamlCompilationError> errors = new ArrayList<GamlCompilationError>();
            for (GamlCompilationError error : resource.getValidationContext().getInternalErrors()) {
                if (!error.isError()) continue;
                errors.add(error);
            }
            diagramEditor.getErrorsLoc().clear();
            diagramEditor.setErrors(errors);
            if (errors.isEmpty()) {
                diagramEditor.getSyntaxErrorsLoc().clear();
            }
            return errors;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static String manageName(String name) {
        if (name.contains(" ")) {
            return "\"" + name + "\"";
        }
        return name;
    }

    static String defineSpecies(ESpecies species, int level, String id) {
        boolean isId2;
        String idT2;
        if (species == null) {
            return "";
        }
        StringBuilder model = new StringBuilder().append(EL);
        Object sp = "";
        int i = 0;
        while (i < level) {
            sp = (String)sp + "\t";
            ++i;
        }
        model.append((String)sp);
        if (species instanceof EGrid) {
            model.append("grid ").append(ModelGenerator.manageName(species.getName()));
        } else {
            model.append("species ").append(ModelGenerator.manageName(species.getName()));
        }
        if (species.getInheritsFrom() != null) {
            model.append(" parent:").append(ModelGenerator.manageName(species.getInheritsFrom().getName()));
        }
        if (species.getSkills() != null && !species.getSkills().isEmpty()) {
            model.append(" skills:").append(species.getSkills());
        }
        for (EFacet facet : species.getFacets()) {
            if (facet.getValue().replace(" ", "").isEmpty() || "name".equals(facet.getName()) || "skills".equals(facet.getName())) continue;
            model.append(" ").append(facet.getName()).append(":").append(facet.getValue());
        }
        model.append(" {").append(EL);
        for (EVariable var : species.getVariables()) {
            model.append(ModelGenerator.defineVariable(var, level + 1));
        }
        String idT = ModelStructure.getElementId(species);
        boolean isId = idT.equals(id);
        if (isId) {
            model.append(EL).append(idT).append(EL);
        }
        model.append(ModelGenerator.defineInit(species, isId ? -1 : level + 1));
        if (isId) {
            model.append(EL).append(idT).append(EL);
        }
        Hashtable<String, EGamaLink> reflexMap = new Hashtable<String, EGamaLink>();
        for (EGamaLink link : species.getActionLinks()) {
            String idA = ModelStructure.getElementId(link.getAction());
            isId = idA.equals(id);
            if (isId) {
                model.append(EL).append(idA).append(EL);
            }
            model.append(ModelGenerator.defineAction((EActionLink)link, isId ? -1 : level + 1));
            if (!isId) continue;
            model.append(EL).append(idA).append(EL);
        }
        for (EGamaLink link : species.getReflexLinks()) {
            if (link.getTarget() == null) continue;
            reflexMap.put(link.getTarget().getName(), link);
        }
        ArrayList<Object> reflexes = new ArrayList<Object>();
        if (species.getReflexList().isEmpty() && !reflexMap.isEmpty()) {
            reflexes.addAll(reflexMap.keySet());
        } else {
            reflexes.addAll((Collection<Object>)species.getReflexList());
        }
        for (String reflex : reflexes) {
            if (!reflexMap.containsKey(reflex)) continue;
            idT = ModelStructure.getElementId(((EReflexLink)reflexMap.get(reflex)).getReflex());
            isId = idT.equals(id);
            if (isId) {
                model.append(EL).append(idT).append(EL);
            }
            model.append(ModelGenerator.defineGeneric((EGamaLink)reflexMap.get(reflex), isId ? -1 : level + 1));
            if (!isId) continue;
            model.append(EL).append(idT).append(EL);
        }
        for (EGamaLink link : species.getStateLinks()) {
            idT2 = ModelStructure.getElementId(link.getState());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getTaskLinks()) {
            idT2 = ModelStructure.getElementId(link.getTask());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getEquationLinks()) {
            idT2 = ModelStructure.getElementId(link.getEquation());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getPlanLinks()) {
            idT2 = ModelStructure.getElementId(link.getPlan());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getRuleLinks()) {
            idT2 = ModelStructure.getElementId(link.getRule());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getPerceiveLinks()) {
            idT2 = ModelStructure.getElementId(link.getPerceive());
            isId2 = idT2.equals(id);
            if (isId2) {
                model.append(EL).append(idT2).append(EL);
            }
            model.append(ModelGenerator.defineGeneric(link, isId2 ? -1 : level));
            if (!isId2) continue;
            model.append(EL).append(idT2).append(EL);
        }
        for (EGamaLink link : species.getAspectLinks()) {
            String idA = ModelStructure.getElementId(link.getAspect());
            isId = idA.equals(id);
            if (isId) {
                model.append(EL).append(idA).append(EL);
            }
            model.append(ModelGenerator.defineAspect((EAspectLink)link, isId ? -1 : level + 1));
            if (!isId) continue;
            model.append(EL).append(idA).append(EL);
        }
        for (EGamaLink link : species.getMicroSpeciesLinks()) {
            model.append(ModelGenerator.defineSpecies(link.getMicro(), level + 1, id));
        }
        model.append((String)sp).append("}").append(EL);
        return model.toString();
    }

    static String defineVariable(EVariable var, int level) {
        if (var == null) {
            return "";
        }
        StringBuilder varStr = new StringBuilder();
        int i = 0;
        while (i < level) {
            varStr.append("\t");
            ++i;
        }
        if (var.getType() == null || "".equals(var.getType())) {
            varStr.append("var ");
        } else {
            varStr.append(var.getType()).append(" ");
        }
        varStr.append(var.getName());
        if (var.getInit() != null && !"".equals(var.getInit())) {
            varStr.append(" <- ").append(var.getInit());
        }
        if (var.getUpdate() != null && !"".equals(var.getUpdate())) {
            varStr.append(" update: ").append(var.getUpdate());
        }
        if (var.getFunction() != null && !"".equals(var.getFunction())) {
            varStr.append(" -> {").append(var.getFunction()).append("}");
        }
        if (var.getMin() != null && !"".equals(var.getMin())) {
            varStr.append(" min: ").append(var.getMin());
        }
        if (var.getMax() != null && !"".equals(var.getMax())) {
            varStr.append(" max: ").append(var.getMax());
        }
        varStr.append(";").append(EL);
        return varStr.toString();
    }

    static String defineAction(EActionLink link, int level) {
        if (link == null || link.getAction() == null) {
            return "";
        }
        EAction action = link.getAction();
        StringBuilder result = new StringBuilder();
        Object sp = "";
        int i = 0;
        while (i < level) {
            sp = (String)sp + "\t";
            ++i;
        }
        String returnType = action.getReturnType() == null || action.getReturnType().isEmpty() ? "action" : action.getReturnType();
        Object arguments = "";
        for (EVariable var : action.getVariables()) {
            arguments = (String)arguments + (((String)arguments).isEmpty() ? "" : ", ") + var.getType() + " " + var.getName() + (String)(var.getInit() == null || var.getInit().isEmpty() ? "" : " <- " + var.getInit());
        }
        result.append((String)sp).append(returnType).append(" ").append(ModelGenerator.manageName(action.getName())).append((String)(((String)arguments).isEmpty() ? "" : "(" + (String)arguments + ")")).append(" {").append(EL);
        String code = action.getGamlCode();
        if (code != null && !code.isEmpty()) {
            result.append(code);
        }
        result.append(EL).append((String)sp).append("}").append(EL);
        return result.toString();
    }

    static String defineInit(ESpecies species, int level) {
        if (species == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String code = species.getInit();
        Object sp = "";
        int i = 0;
        while (i < level) {
            sp = (String)sp + "\t";
            ++i;
        }
        result.append((String)sp).append("init {").append(EL);
        if (code != null && !code.isEmpty()) {
            result.append(code);
        }
        result.append(EL).append((String)sp).append("}").append(EL);
        return result.toString();
    }

    static String defineGeneric(EGamaLink link, int level) {
        if (link == null || link.getTarget() == null) {
            return "";
        }
        EGamaObject object = link.getTarget();
        StringBuilder result = new StringBuilder();
        StringBuilder sp = new StringBuilder();
        int i = 0;
        while (i < level) {
            sp.append("\t");
            ++i;
        }
        String type = "";
        if (object instanceof EReflex) {
            type = "reflex";
        } else if (object instanceof EState) {
            type = "state";
        } else if (object instanceof ETask) {
            type = "task";
        } else if (object instanceof EEquation) {
            type = "equation";
        } else if (object instanceof EPlan) {
            type = "plan";
        } else if (object instanceof EPerceive) {
            type = "perceive";
        } else if (object instanceof ERule) {
            type = "rule";
        }
        result.append(type).append(" ").append(ModelGenerator.manageName(link.getTarget().getName()));
        for (EFacet facet : object.getFacets()) {
            if (facet.getValue().replace(" ", "").isEmpty()) continue;
            result.append(" ").append(facet.getName()).append(":").append(facet.getValue());
        }
        String code = null;
        if (object instanceof EReflex) {
            code = ((EReflex)object).getGamlCode();
        } else if (object instanceof EState) {
            code = ((EState)object).getGamlCode();
        } else if (object instanceof EEquation) {
            code = ((EEquation)object).getGamlCode();
        } else if (object instanceof ETask) {
            code = ((ETask)object).getGamlCode();
        } else if (object instanceof EPlan) {
            code = ((EPlan)object).getGamlCode();
        } else if (object instanceof EPerceive) {
            code = ((EPerceive)object).getGamlCode();
        }
        result.append(" {").append(EL);
        if (code != null && !code.isEmpty()) {
            result.append(code);
        }
        result.append(EL).append(sp.toString()).append("}").append(EL);
        return result.toString();
    }

    static String defineAspect(EAspectLink link, int level) {
        if (link == null || link.getAspect() == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        EAspect asp = link.getAspect();
        Object sp = "";
        int i = 0;
        while (i < level) {
            sp = (String)sp + "\t";
            ++i;
        }
        result.append((String)sp).append("aspect ").append(ModelGenerator.manageName(asp.getName())).append(" {").append(EL);
        if (asp.isDefineGamlCode()) {
            String code = asp.getGamlCode();
            if (code != null && !code.isEmpty()) {
                result.append(code);
            }
        } else {
            for (ELayerAspect lay : asp.getLayers()) {
                StringBuilder code = new StringBuilder().append((String)sp).append(level >= 0 ? "\t" : "").append("draw ");
                String val = lay.getShapeType();
                if (val == null) continue;
                if ("polyline".equals(val) || "polygon".equals(val)) {
                    code.append(val).append("(").append(lay.getPoints()).append(")");
                } else if ("circle".equals(val) || "sphere".equals(val)) {
                    code.append(val).append("(").append(lay.getRadius()).append(")");
                } else if ("square".equals(val) || "cube".equals(val) || "pyramid".equals(val)) {
                    code.append(val).append("(").append(lay.getSize()).append(")");
                } else if ("rectangle".equals(val) || "hexagon".equals(val)) {
                    code.append(val).append("({").append(lay.getWidth()).append(",").append(lay.getHeigth()).append("})");
                } else if ("expression".equals(val)) {
                    code.append(lay.getExpression());
                } else if ("image".equals(val)) {
                    code.append("file(\"").append(lay.getPath()).append("\")").append((String)(lay.getImageSize() != null && !lay.getImageSize().isEmpty() ? "" : " size:" + lay.getSize()));
                } else if ("text".equals(val)) {
                    code.append("\"").append(lay.getText()).append("\"").append((String)(lay.getTextSize() != null && !lay.getTextSize().isEmpty() ? "" : " size:" + lay.getSize()));
                }
                if (lay.getIsColorCst().booleanValue()) {
                    code.append(" color: rgb(").append(lay.getColorRBG().toString().replace("[", "").replace("]", "")).append(")");
                } else if (lay.getColor() != null && !lay.getColor().isEmpty()) {
                    code.append(" color: ").append(lay.getColor());
                }
                if (lay.getEmpty() != null && !lay.getEmpty().isEmpty() && !"false".equals(lay.getEmpty())) {
                    code.append(" empty: ").append(lay.getEmpty());
                }
                if (lay.getRotate() != null && !lay.getRotate().isEmpty() && !"0.0".equals(lay.getRotate())) {
                    code.append(" rotate: ").append(lay.getRotate());
                }
                if (lay.getAt() != null && !lay.getAt().isEmpty()) {
                    code.append(" at: ").append(lay.getAt());
                }
                if (lay.getDepth() != null && !lay.getDepth().isEmpty() && !"0.0".equals(lay.getDepth())) {
                    code.append(" depth: ").append(lay.getDepth());
                }
                if (lay.getTexture() != null && !lay.getTexture().isEmpty() && !"[]".equals(lay.getTexture())) {
                    code.append(" texture: ").append(lay.getTexture());
                }
                result.append(code.toString()).append(";").append(EL);
            }
        }
        result.append(EL).append((String)sp).append("}").append(EL);
        return result.toString();
    }

    static String defineExperiment(EExperiment exp, String id) {
        Object model = "";
        if (exp == null) {
            return model;
        }
        if (exp instanceof EBatchExperiment) {
            model = (String)model + EL + EL + "experiment \"" + exp.getName() + "\" type:batch ";
            for (EFacet facet : exp.getFacets()) {
                if (facet.getValue().replace(" ", "").isEmpty()) continue;
                model = (String)model + " " + facet.getName() + ":" + facet.getValue();
            }
            model = (String)model + " {" + EL;
            for (EParameter link : exp.getParameters()) {
                model = (String)model + ModelGenerator.defineParameter(link);
            }
            model = (String)model + EL + "}" + EL;
        } else {
            model = (String)model + EL + EL + "experiment \"" + exp.getName() + "\" type:gui ";
            for (EFacet facet : exp.getFacets()) {
                if (facet.getValue().replace(" ", "").isEmpty()) continue;
                model = (String)model + " " + facet.getName() + ":" + facet.getValue();
            }
            model = (String)model + " {" + EL;
            for (Object link : exp.getParameters()) {
                model = (String)model + ModelGenerator.defineParameter((EParameter)link);
            }
            model = (String)model + "\toutput{";
            for (EMonitor mon : exp.getMonitors()) {
                model = (String)model + ModelGenerator.defineMonitor(mon);
            }
            for (Object link : exp.getDisplayLinks()) {
                String idA = ModelStructure.getElementId(link.getDisplay());
                boolean isId = idA.equals(id);
                if (isId) {
                    model = (String)model + EL + idA + EL;
                }
                model = (String)model + ModelGenerator.defineDisplay((EDisplayLink)link);
                if (!isId) continue;
                model = (String)model + EL + idA + EL;
            }
            model = (String)model + EL + "\t}" + EL + "}" + EL;
        }
        return model;
    }

    static String defineParameter(EParameter par) {
        if (par == null) {
            return "";
        }
        StringBuilder parStr = new StringBuilder("\tparameter");
        parStr.append("\"").append(par.getName()).append("\"");
        parStr.append(" var:").append(par.getVariable());
        if (par.getCategory() != null && !par.getCategory().isEmpty()) {
            parStr.append(" category: \"").append(par.getCategory()).append("\"");
        }
        if (par.getAmong() != null && !par.getAmong().isEmpty()) {
            parStr.append(" among:").append(par.getAmong());
        }
        if (par.getInit() != null && !par.getInit().isEmpty()) {
            parStr.append(" <-").append(par.getInit());
        }
        if (par.getMin() != null && !par.getMin().isEmpty()) {
            parStr.append(" min:").append(par.getMin());
        }
        if (par.getMax() != null && !par.getMax().isEmpty()) {
            parStr.append(" max:").append(par.getMax());
        }
        if (par.getStep() != null && !par.getStep().isEmpty()) {
            parStr.append(" step:").append(par.getStep());
        }
        parStr.append(";").append(EL);
        return parStr.toString();
    }

    static String defineMonitor(EMonitor mon) {
        if (mon == null) {
            return "";
        }
        StringBuilder parStr = new StringBuilder("\t\tmonitor ");
        parStr.append("\"").append(mon.getName()).append("\"");
        if (mon.getValue() != null && !mon.getValue().isEmpty()) {
            parStr.append(" value:").append(mon.getValue());
        }
        parStr.append(";").append(EL);
        return parStr.toString();
    }

    static String defineDisplay(EDisplayLink link) {
        if (link == null || link.getDisplay() == null) {
            return "";
        }
        EDisplay disp = link.getDisplay();
        StringBuilder model = new StringBuilder().append(EL).append("\t\t");
        model.append("display ").append(ModelGenerator.manageName(disp.getName()));
        for (EFacet facet : disp.getFacets()) {
            if (facet.getValue().replace(" ", "").isEmpty()) continue;
            model.append(" ").append(facet.getName()).append(":").append(facet.getValue());
        }
        model.append(" {").append(EL);
        if (disp.isDefineGamlCode()) {
            String code = disp.getGamlCode();
            if (code != null && !code.isEmpty()) {
                model.append(code);
            }
        } else {
            for (ELayer lay : disp.getLayers()) {
                if (lay.getType() == null) continue;
                model.append("\n\t\t\t");
                if ("species".equals(lay.getType())) {
                    model.append(lay.getType()).append(" ").append(lay.getSpecies()).append((String)(lay.getAspect() == null || lay.getAspect().isEmpty() || "default".equals(lay.getAspect()) ? "" : " aspect: " + lay.getAspect()));
                } else if ("grid".equals(lay.getType())) {
                    model.append(lay.getType()).append(" ").append(lay.getGrid());
                    if (lay.getIsColorCst() == null || lay.getIsColorCst().booleanValue()) {
                        if (lay.getColorRBG().size() == 3 && lay.isShowLines()) {
                            model.append(" lines:rgb(").append(lay.getColorRBG().get(0)).append(",").append(lay.getColorRBG().get(1)).append(",").append(lay.getColorRBG().get(2)).append(")");
                        }
                    } else if (lay.getColor() != null && !"rgb(255,255,255)".equals(lay.getColor()) && !lay.getColor().isEmpty()) {
                        model.append(" lines:").append(lay.getColor());
                    }
                } else if ("agents".equals(lay.getType())) {
                    model.append(lay.getType()).append(" \"").append(lay.getName()).append("\" value:").append(lay.getAgents()).append((String)(lay.getAspect() == null || lay.getAspect().isEmpty() ? "" : " aspect: " + lay.getAspect()));
                } else if ("image".equals(lay.getType())) {
                    model.append(lay.getType()).append("\"").append(lay.getFile()).append("\"").append((String)(lay.getSize().isEmpty() ? "" : " size: " + lay.getSize()));
                    if (lay.getIsColorCst() == null || lay.getIsColorCst().booleanValue()) {
                        if (!(lay.getColorRBG().size() != 3 || "255".equals(lay.getColorRBG().get(0)) && "255".equals(lay.getColorRBG().get(1)) && "255".equals(lay.getColorRBG().get(2)))) {
                            model.append(" color:rgb(").append(lay.getColorRBG().get(0)).append(",").append(lay.getColorRBG().get(1)).append(",").append(lay.getColorRBG().get(2)).append(")");
                        }
                    } else if (lay.getColor() != null && !"rgb(255,255,255)".equals(lay.getColor()) && !lay.getColor().isEmpty()) {
                        model.append(" color:").append(lay.getColor());
                    }
                } else if ("text".equals(lay.getType())) {
                    model.append(lay.getType()).append("\"").append(lay.getText()).append("\"").append((String)(lay.getSize().isEmpty() ? "" : " size: " + lay.getSize()));
                    if (lay.getIsColorCst() == null || lay.getIsColorCst().booleanValue()) {
                        if (!(lay.getColorRBG().size() != 3 || "255".equals(lay.getColorRBG().get(0)) && "255".equals(lay.getColorRBG().get(1)) && "255".equals(lay.getColorRBG().get(2)))) {
                            model.append(" color:rgb(").append(lay.getColorRBG().get(0)).append(",").append(lay.getColorRBG().get(1)).append(",").append(lay.getColorRBG().get(2)).append(")");
                        }
                    } else if (lay.getColor() != null && !"rgb(255,255,255)".equals(lay.getColor()) && !lay.getColor().isEmpty()) {
                        model.append(" color:").append(lay.getColor());
                    }
                } else if ("chart".equals(lay.getType())) {
                    Object background = "";
                    if (lay.getIsColorCst() == null || lay.getIsColorCst().booleanValue()) {
                        if (!(lay.getColorRBG().size() != 3 || "255".equals(lay.getColorRBG().get(0)) && "255".equals(lay.getColorRBG().get(1)) && "255".equals(lay.getColorRBG().get(2)))) {
                            background = " background:rgb(" + String.valueOf(lay.getColorRBG().get(0)) + "," + String.valueOf(lay.getColorRBG().get(1)) + "," + String.valueOf(lay.getColorRBG().get(2)) + ")";
                        }
                    } else if (lay.getColor() != null && !"rgb(255,255,255)".equals(lay.getColor()) && !lay.getColor().isEmpty()) {
                        background = " background:" + lay.getColor();
                    }
                    model.append(lay.getType()).append(" \"").append(lay.getName()).append("\" type:").append(lay.getChart_type()).append((String)background);
                }
                for (EFacet facet : lay.getFacets()) {
                    if (facet.getValue().replace(" ", "").isEmpty()) continue;
                    model.append(" ").append(facet.getName()).append(":").append(facet.getValue());
                }
                if ("chart".equals(lay.getType())) {
                    model.append("{").append(EL);
                    if (lay.getChartlayers() != null && !lay.getChartlayers().isEmpty()) {
                        for (EChartLayer cl : lay.getChartlayers()) {
                            model.append("\t\t\t\tdata \"").append(cl.getName()).append("\" style:").append(cl.getStyle()).append(" value:").append(cl.getValue() == null || cl.getValue().isEmpty() ? "0.0" : cl.getValue()).append((String)(cl.getColor() == null || cl.getColor().isEmpty() ? "" : " color:" + cl.getColor())).append(";").append(EL);
                        }
                    }
                    model.append(EL).append("\t\t\t}").append(EL);
                    continue;
                }
                model.append(";").append(EL);
            }
        }
        model.append("\t\t}");
        return model.toString();
    }

    public static String generateModel(IFeatureProvider fp, Diagram diagram, String id) {
        Object model = "";
        EList contents = diagram.getChildren();
        if (contents != null) {
            boolean isId;
            String idT;
            EWorldAgent worldAgent = null;
            for (Shape obj : contents) {
                Object bo = fp.getBusinessObjectForPictogramElement((PictogramElement)obj);
                if (!(bo instanceof EWorldAgent)) continue;
                worldAgent = (EWorldAgent)bo;
                break;
            }
            if (worldAgent == null) {
                return "";
            }
            Object modelName = diagram.getName();
            if (!Character.isLetter(((String)modelName).charAt(0))) {
                modelName = "_" + (String)modelName;
            }
            model = "model " + (String)modelName + EL + EL + "global";
            if (worldAgent.getSkills() != null && !worldAgent.getSkills().isEmpty()) {
                model = (String)model + " skills:" + String.valueOf(worldAgent.getSkills());
            }
            for (EFacet facet : worldAgent.getFacets()) {
                if (facet.getValue().replace(" ", "").isEmpty()) continue;
                model = (String)model + " " + facet.getName() + ":" + facet.getValue();
            }
            model = (String)model + " {" + EL;
            for (EVariable var : worldAgent.getVariables()) {
                model = (String)model + ModelGenerator.defineVariable(var, 1);
            }
            for (EActionLink link : worldAgent.getActionLinks()) {
                String idA = ModelStructure.getElementId(link.getAction());
                boolean isId2 = idA.equals(id);
                if (isId2) {
                    model = (String)model + EL + (String)idA + EL;
                }
                model = (String)model + ModelGenerator.defineAction(link, isId2 ? -1 : 1);
                if (!isId2) continue;
                model = (String)model + EL + (String)idA + EL;
            }
            Hashtable<String, EReflexLink> reflexMap = new Hashtable<String, EReflexLink>();
            for (EReflexLink link : worldAgent.getReflexLinks()) {
                if (link.getTarget() == null) continue;
                reflexMap.put(link.getTarget().getName(), link);
            }
            ArrayList<Object> reflexes = new ArrayList<Object>();
            if (worldAgent.getReflexList().isEmpty() && !reflexMap.isEmpty()) {
                reflexes.addAll(reflexMap.keySet());
            } else {
                reflexes.addAll((Collection<Object>)worldAgent.getReflexList());
            }
            for (String reflex : reflexes) {
                if (!reflexMap.containsKey(reflex)) continue;
                idT = ModelStructure.getElementId(((EReflexLink)reflexMap.get(reflex)).getReflex());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric((EGamaLink)reflexMap.get(reflex), isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getStateLinks()) {
                idT = ModelStructure.getElementId(link.getState());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getTaskLinks()) {
                idT = ModelStructure.getElementId(link.getTask());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getEquationLinks()) {
                idT = ModelStructure.getElementId(link.getEquation());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getPlanLinks()) {
                idT = ModelStructure.getElementId(link.getPlan());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getRuleLinks()) {
                idT = ModelStructure.getElementId(link.getRule());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getPerceiveLinks()) {
                idT = ModelStructure.getElementId(link.getPerceive());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineGeneric(link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            for (EGamaLink link : worldAgent.getAspectLinks()) {
                idT = ModelStructure.getElementId(link.getAspect());
                isId = idT.equals(id);
                if (isId) {
                    model = (String)model + EL + idT + EL;
                }
                model = (String)model + ModelGenerator.defineAspect((EAspectLink)link, isId ? -1 : 1);
                if (!isId) continue;
                model = (String)model + EL + idT + EL;
            }
            String idT2 = ModelStructure.getElementId(worldAgent);
            boolean isId3 = idT2.equals(id);
            if (isId3) {
                model = (String)model + EL + idT2 + EL;
            }
            model = (String)model + ModelGenerator.defineInit(worldAgent, isId3 ? -1 : 1);
            if (isId3) {
                model = (String)model + EL + idT2 + EL;
            }
            model = (String)model + "}";
            model = (String)model + EL;
            for (EGamaLink link : worldAgent.getMicroSpeciesLinks()) {
                model = (String)model + ModelGenerator.defineSpecies(link.getMicro(), 0, id);
            }
            model = (String)model + EL;
            for (EGamaLink link : worldAgent.getExperimentLinks()) {
                model = (String)model + ModelGenerator.defineExperiment(link.getExperiment(), id);
            }
        }
        return model;
    }
}

