/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.others;

import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.metamodel.EGamaObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class RenameEGamaObjectFeature
extends AbstractCustomFeature {
    private boolean hasDoneChanges = false;

    public RenameEGamaObjectFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Rename";
    }

    public String getDescription() {
        return "Change the name of the object";
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof EGamaObject) {
            ret = true;
        }
        return ret;
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof EGamaObject) {
            EGamaObject eClass = (EGamaObject)bo;
            String currentName = eClass.getName();
            String newName = ExampleUtil.askString(this.getName(), this.getDescription(), currentName);
            if (newName != null && !newName.equals(currentName)) {
                this.hasDoneChanges = true;
                eClass.setName(newName);
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

