/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.features.others;

import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EVariable;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class UpdateEGamaObjectFeature
extends AbstractUpdateFeature {
    public UpdateEGamaObjectFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof EGamaObject;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateVarNeeded;
        boolean updateNameNeeded;
        String pictogramName = null;
        String pictogramVar = "";
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            if (bo instanceof EGamaObject) {
                boolean error;
                EGamaObject eClass = (EGamaObject)bo;
                boolean bl = error = eClass.getHasError() != null && eClass.getHasError() != false;
                if (cs.getGraphicsAlgorithm() != null && cs.getGraphicsAlgorithm().getForeground() != null && cs.getGraphicsAlgorithm().getForeground().getGreen() == 255 == error) {
                    return Reason.createTrueReason((String)"Foreground color is out of date");
                }
            }
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                if (text.getY() != 25) {
                    pictogramName = text.getValue();
                    continue;
                }
                pictogramVar = text.getValue();
            }
        }
        String businessName = null;
        Object varNames = "";
        if (bo instanceof EGamaObject) {
            EGamaObject eClass = (EGamaObject)bo;
            businessName = eClass.getName();
            if (bo instanceof ESpecies) {
                for (EVariable var : ((ESpecies)eClass).getVariables()) {
                    String type = var.getType() == null || var.getType().isEmpty() ? "var" : var.getType();
                    varNames = (String)varNames + type + " " + var.getName() + "\n";
                }
            }
        }
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)"Name is out of date");
        }
        boolean bl2 = updateVarNeeded = !pictogramVar.equals(varNames);
        if (updateVarNeeded) {
            return Reason.createTrueReason((String)"Variables are out of date");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        String businessName = null;
        Object varNames = "";
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        int cpt = 0;
        boolean error = true;
        if (bo instanceof EGamaObject) {
            EGamaObject eClass = (EGamaObject)bo;
            error = eClass.getHasError() != null && eClass.getHasError() != false;
            businessName = eClass.getName();
            if (bo instanceof ESpecies) {
                for (EVariable var : ((ESpecies)eClass).getVariables()) {
                    String type = var.getType() == null || var.getType().isEmpty() ? "var" : var.getType();
                    varNames = (String)varNames + type + " " + var.getName() + "\n";
                }
                cpt = ((ESpecies)eClass).getVariables().size();
            }
        }
        boolean update = false;
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            cs.getGraphicsAlgorithm().setForeground(error ? this.manageColor((IColorConstant)new ColorConstant(255, 0, 0)) : this.manageColor((IColorConstant)new ColorConstant(0, 255, 0)));
            cs.getGraphicsAlgorithm().setLineWidth(Integer.valueOf(error ? 4 : 2));
            update = true;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                if (text.getY() < 25) {
                    text.setValue(businessName);
                    continue;
                }
                text.setValue((String)varNames);
                Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)text, 5, 25, text.getWidth(), 25 + cpt * 20);
            }
        }
        return update;
    }
}

