/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.commands;

import gama.core.kernel.model.IModel;
import gama.ui.diagram.FileService;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.editor.GamaFeatureProvider;
import gama.ui.shared.utils.WorkbenchHelper;
import gaml.compiler.gaml.validation.GamlModelBuilder;
import gaml.compiler.ui.editor.GamlEditor;
import gaml.compiler.ui.editor.IDiagramOpener;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class GenerateDiagramHandler
extends AbstractHandler
implements IDiagramOpener {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GamlEditor editor = (GamlEditor)WorkbenchHelper.getActiveEditor();
        this.open(editor);
        return null;
    }

    private void createDiagramEditor(IFile file, String diagramName, IModel gamaModel) {
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("gamaDiagram", diagramName, true);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        FileService.createEmfFileForDiagram(uri, diagram);
        DiagramEditorInput editorInput = new DiagramEditorInput(EcoreUtil.getURI((EObject)diagram), "gama.ui.diagram.editor.GamaDiagramTypeProvider");
        WorkbenchHelper.asyncRun(() -> {
            IWorkbenchPage pag = WorkbenchHelper.getPage();
            try {
                IEditorPart ep = pag.openEditor((IEditorInput)editorInput, "gama.ui.diagram.editor");
                IDiagramTypeProvider dtp = ((GamaDiagramEditor)ep).getDiagramTypeProvider();
                GamaFeatureProvider gfp = (GamaFeatureProvider)dtp.getFeatureProvider();
                gfp.setTypeOfModel("custom");
                gfp.setGamaModel(gamaModel);
                gfp.init();
                ep.doSave(null);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        });
    }

    public static TransactionalEditingDomain createEmfFileForDiagram(URI uri, final Diagram diagram) {
        TransactionalEditingDomain editingDomain = GraphitiUiInternal.getEmfService().createResourceSetAndEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final Resource resource = resourceSet.createResource(uri);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.setTrackingModification(true);
                resource.getContents().add((Object)diagram);
            }
        });
        return editingDomain;
    }

    public void open(GamlEditor editor) {
        IResource resource;
        IProject container;
        IFolder modelFolder;
        IModel model = (IModel)editor.getDocument().readOnly(state -> GamlModelBuilder.getDefaultInstance().compile(state.getURI(), null));
        if (model == null) {
            return;
        }
        File file = new File(model.getProjectPath() + "/diagrams/" + model.getName() + ".gadl");
        if (file.exists()) {
            file.delete();
        }
        if (!(modelFolder = (container = (resource = editor.getResource()).getProject()).getFolder((IPath)new Path("diagrams"))).exists()) {
            try {
                modelFolder.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IFile fileP = container.getFile((IPath)new Path("diagrams/" + model.getName() + ".gadl"));
        this.createDiagramEditor(fileP, model.getName(), model);
    }

    public void close(GamlEditor editor) {
    }
}

