/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import gama.core.util.GamaMapFactory;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.edit.EditFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAspect;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.ELayerAspect;
import gama.ui.diagram.metamodel.GamaFactory;
import gama.ui.diagram.swt.editFrame.EditFrame;
import gama.ui.diagram.swt.editFrame.EditLayerAspectFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditAspectFrame
extends EditFrame {
    Table layerViewer;
    EditAspectFrame frame;
    List<ELayerAspect> layers;
    Diagram diagram;
    final Map<ELayerAspect, EditLayerAspectFrame> layerFrames = GamaMapFactory.create();
    Group gpLay;
    Group gpC;

    public EditAspectFrame(Diagram diagram, IFeatureProvider fp, EditFeature eaf, EAspect aspect, String name) {
        super(diagram, fp, eaf, aspect, name == null ? "Aspect definition" : name);
        this.frame = this;
        this.layers = new ArrayList<ELayerAspect>();
        this.layers.addAll((Collection<ELayerAspect>)aspect.getLayers());
        this.diagram = diagram;
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.groupName(container);
        this.groupRadioGamlCode(container, "aspect");
        this.gpLay = this.groupLayers(container);
        this.gpC = this.groupGamlCode(container, "GAML code");
        EAspect asp = (EAspect)this.eobject;
        if (asp.isDefineGamlCode()) {
            this.radioGaml.setSelection(true);
            this.removeOther();
        } else {
            this.radioEdit.setSelection(true);
            this.removeGaml();
        }
        return container;
    }

    @Override
    public void removeGaml() {
        EditAspectFrame.recursiveSetEnabled((Control)this.gpLay, true);
        EditAspectFrame.recursiveSetEnabled((Control)this.gpC, false);
        this.layerViewer.setVisible(true);
        this.editor.getViewer().getControl().setVisible(false);
    }

    @Override
    public void removeOther() {
        EditAspectFrame.recursiveSetEnabled((Control)this.gpLay, false);
        EditAspectFrame.recursiveSetEnabled((Control)this.gpC, true);
        this.layerViewer.setVisible(false);
        this.editor.getViewer().getControl().setVisible(true);
    }

    protected Group groupLayers(Composite container) {
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        ArrayList<String> vals = new ArrayList<String>();
        diagramEditor.buildLocation(this.eobject, vals);
        vals.add("draw");
        diagramEditor.getIdsEObjects().put(vals, this.eobject);
        Group group = new Group(container, 0);
        group.setLayout((Layout)new FillLayout(512));
        group.setText("Aspect layers");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        this.layerViewer = new Table((Composite)group, 68100);
        this.layerViewer.setHeaderVisible(false);
        this.layerViewer.setLinesVisible(false);
        this.layerViewer.setLayoutData((Object)gridData2);
        final EAspect aspect = (EAspect)this.eobject;
        for (ELayerAspect la : aspect.getLayers()) {
            TableItem ti = new TableItem(this.layerViewer, 0);
            ti.setText(la.getName());
            ti.setBackground(this.hasError(la) ? new Color((Device)this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)this.frame.getShell().getDisplay(), 100, 255, 100));
        }
        Composite containerButtons = new Composite((Composite)group, 0);
        containerButtons.setLayout((Layout)new FillLayout(256));
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        containerButtons.setLayoutData((Object)gridData3);
        Button addLayerBtn = new Button(containerButtons, 524288);
        addLayerBtn.setText("Add");
        addLayerBtn.setSelection(false);
        addLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ELayerAspect elayer = GamaFactory.eINSTANCE.createELayerAspect();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)EditAspectFrame.this.eobject);
                if (domain != null) {
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        public void doExecute() {
                            elayer.setName("Layer");
                            elayer.setAspect((EAspect)(this).EditAspectFrame.this.eobject);
                            (this).EditAspectFrame.this.diagram.eResource().getContents().add((Object)elayer);
                            TableItem ti = new TableItem((this).EditAspectFrame.this.layerViewer, 0);
                            ti.setText(elayer.getName());
                            ti.setBackground(EditAspectFrame.this.hasError(elayer) ? new Color((Device)(this).EditAspectFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)(this).EditAspectFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                            ((EAspect)(this).EditAspectFrame.this.eobject).getLayers().add((Object)elayer);
                        }
                    });
                }
                EditLayerAspectFrame eaf = new EditLayerAspectFrame(elayer, EditAspectFrame.this.frame, false, EditAspectFrame.this.diagram, EditAspectFrame.this.fp, EditAspectFrame.this.ef);
                EditAspectFrame.this.layerFrames.put(elayer, eaf);
                eaf.open();
            }
        });
        Button editLayerBtn = new Button(containerButtons, 524288);
        editLayerBtn.setText("Edit");
        editLayerBtn.setSelection(false);
        editLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditAspectFrame.this.layerViewer.getSelectionCount() == 1) {
                    int index = EditAspectFrame.this.layerViewer.getSelectionIndex();
                    ELayerAspect layer = (ELayerAspect)((EAspect)EditAspectFrame.this.eobject).getLayers().get(index);
                    EditLayerAspectFrame eaf = EditAspectFrame.this.layerFrames.get(layer);
                    if (eaf == null || eaf.getShell() == null || eaf.getShell().isDisposed()) {
                        eaf = new EditLayerAspectFrame(layer, EditAspectFrame.this.frame, true, EditAspectFrame.this.diagram, EditAspectFrame.this.fp, EditAspectFrame.this.ef);
                        eaf.open();
                        EditAspectFrame.this.layerFrames.put(layer, eaf);
                    } else {
                        eaf.getShell().setFocus();
                    }
                    eaf.open();
                }
            }
        });
        Button removeLayerBtn = new Button(containerButtons, 524288);
        removeLayerBtn.setText("Remove");
        removeLayerBtn.setSelection(false);
        removeLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditAspectFrame.this.layerViewer.getSelectionCount() == 1) {
                    final int index = EditAspectFrame.this.layerViewer.getSelectionIndex();
                    EditAspectFrame.this.layerViewer.remove(index);
                    final ELayerAspect lay = EditAspectFrame.this.layers.remove(index);
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)EditAspectFrame.this.eobject);
                    if (domain != null) {
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            public void doExecute() {
                                aspect.getLayers().remove(index);
                                (this).EditAspectFrame.this.layerFrames.remove(lay);
                                (this).EditAspectFrame.this.diagram.eResource().getContents().remove((Object)lay);
                                EcoreUtil.delete((EObject)lay);
                            }
                        });
                    }
                    EditAspectFrame.this.save("");
                    ModelGenerator.modelValidation(EditAspectFrame.this.fp, EditAspectFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                    EditAspectFrame.this.ef.hasDoneChanges = true;
                }
            }
        });
        Button btnUp = new Button(containerButtons, 132);
        btnUp.setSelection(false);
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (EditAspectFrame.this.layerViewer.getSelectionCount() == 1 && (index = EditAspectFrame.this.layerViewer.getSelectionIndex()) > 0) {
                    ((EDisplay)EditAspectFrame.this.eobject).getLayers().move(index - 1, index);
                    EditAspectFrame.this.layerViewer.removeAll();
                    for (ELayerAspect la : ((EAspect)EditAspectFrame.this.eobject).getLayers()) {
                        TableItem ti = new TableItem(EditAspectFrame.this.layerViewer, 0);
                        ti.setText(la.getName());
                        ti.setBackground(EditAspectFrame.this.hasError(la) ? new Color((Device)EditAspectFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)EditAspectFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                    }
                }
            }
        });
        Button btnDown = new Button(containerButtons, 1028);
        btnDown.setSelection(false);
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (EditAspectFrame.this.layerViewer.getSelectionCount() == 1 && (index = EditAspectFrame.this.layerViewer.getSelectionIndex()) < EditAspectFrame.this.layerViewer.getItemCount() - 1) {
                    ((EDisplay)EditAspectFrame.this.eobject).getLayers().move(index + 1, index);
                    EditAspectFrame.this.layerViewer.removeAll();
                    for (ELayerAspect la : ((EAspect)EditAspectFrame.this.eobject).getLayers()) {
                        TableItem ti = new TableItem(EditAspectFrame.this.layerViewer, 0);
                        ti.setText(la.getName());
                        ti.setBackground(EditAspectFrame.this.hasError(la) ? new Color((Device)EditAspectFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)EditAspectFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                    }
                }
            }
        });
        return group;
    }

    @Override
    protected Point getInitialSize() {
        return new Point(743, 430);
    }

    public List<ELayerAspect> getLayers() {
        return this.layers;
    }

    public void setLayers(List<ELayerAspect> layers) {
        this.layers = layers;
    }

    public Table getLayerViewer() {
        return this.layerViewer;
    }

    @Override
    protected void clean() {
        EAspect aspect = (EAspect)this.eobject;
        for (ELayerAspect lay : this.layers) {
            if (aspect.getLayers().contains((Object)lay)) continue;
            EcoreUtil.delete((EObject)lay, (boolean)true);
        }
        this.layers.clear();
    }

    @Override
    protected void save(String name) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    EditAspectFrame.this.eobject.setName(EditAspectFrame.this.textName.getText());
                    EAspect asp = (EAspect)EditAspectFrame.this.eobject;
                    asp.setGamlCode(EditAspectFrame.this.modelXText.getEditablePart());
                    asp.setDefineGamlCode(EditAspectFrame.this.radioGaml.getSelection());
                }
            });
        }
        this.ef.hasDoneChanges = true;
        ModelGenerator.modelValidation(this.fp, this.diagram);
    }

    public boolean hasError(ELayerAspect elayer) {
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        ArrayList<String> ids = new ArrayList<String>();
        diagramEditor.buildLocation(elayer, ids);
        if (diagramEditor.getErrorsLoc().isEmpty() && diagramEditor.getSyntaxErrorsLoc().isEmpty()) {
            return false;
        }
        return diagramEditor.getErrorsLoc().containsKey(ids) || diagramEditor.getSyntaxErrorsLoc().containsKey(ids);
    }

    public void updateLayer() {
        this.layerViewer.removeAll();
        for (ELayerAspect elayer : ((EAspect)this.eobject).getLayers()) {
            TableItem ti = new TableItem(this.layerViewer, 0);
            ti.setText(elayer.getName());
            ti.setBackground(this.hasError(elayer) ? new Color((Device)this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)this.frame.getShell().getDisplay(), 100, 255, 100));
        }
    }
}

