/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import gama.core.util.GamaMapFactory;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.edit.EditFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EDisplay;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.EGrid;
import gama.ui.diagram.metamodel.ELayer;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import gama.ui.diagram.swt.editFrame.EditFrame;
import gama.ui.diagram.swt.editFrame.EditLayerFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditDisplayFrame
extends EditFrame {
    Table layerViewer;
    EditDisplayFrame frame;
    List<ESpecies> species;
    List<ESpecies> grids;
    Group gpLay;
    Group gpC;
    Diagram diagram;
    final Map<ELayer, EditLayerFrame> layerFrames;
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

    public EditDisplayFrame(Diagram diagram, IFeatureProvider fp, EditFeature eaf, EGamaObject display, String name) {
        super(diagram, fp, eaf, display, name == null ? "Display definition" : name);
        this.comboValues = new Hashtable();
        this.comboValues.put("type", Arrays.asList("java2D", "opengl"));
        this.layerFrames = GamaMapFactory.create();
        this.species = new ArrayList<ESpecies>();
        this.grids = new ArrayList<ESpecies>();
        this.diagram = diagram;
        EList contents = diagram.getChildren();
        for (Shape sh : contents) {
            Object obj = fp.getBusinessObjectForPictogramElement((PictogramElement)sh);
            if (obj instanceof EGrid) {
                this.grids.add((ESpecies)obj);
            }
            if (!(obj instanceof ESpecies)) continue;
            this.species.add((ESpecies)obj);
        }
        this.frame = this;
        this.updateLayerId();
        ModelGenerator.modelValidation(fp, diagram);
    }

    private void loadData() {
        EDisplay display = (EDisplay)this.eobject;
        for (ELayer la : display.getLayers()) {
            TableItem ti = new TableItem(this.layerViewer, 0);
            ti.setText(la.getName());
            ti.setBackground(this.hasError(la) ? new Color((Device)this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)this.frame.getShell().getDisplay(), 100, 255, 100));
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.groupName(container);
        this.groupFacets(container, "display", 4);
        this.groupRadioGamlCode(container, "aspect");
        this.gpLay = this.groupLayers(container);
        this.gpC = this.groupGamlCode(container, "GAML code");
        EDisplay asp = (EDisplay)this.eobject;
        if (asp.isDefineGamlCode()) {
            this.radioGaml.setSelection(true);
            this.removeOther();
        } else {
            this.radioEdit.setSelection(true);
            this.removeGaml();
        }
        this.loadData();
        return container;
    }

    @Override
    public void removeGaml() {
        EditDisplayFrame.recursiveSetEnabled((Control)this.gpLay, true);
        EditDisplayFrame.recursiveSetEnabled((Control)this.gpC, false);
        this.layerViewer.setVisible(true);
        this.editor.getViewer().getControl().setVisible(false);
    }

    @Override
    public void removeOther() {
        EditDisplayFrame.recursiveSetEnabled((Control)this.gpLay, false);
        EditDisplayFrame.recursiveSetEnabled((Control)this.gpC, true);
        this.layerViewer.setVisible(false);
        this.editor.getViewer().getControl().setVisible(true);
    }

    protected Group groupLayers(Composite container) {
        Group group = new Group(container, 0);
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        group.setLayout((Layout)new FillLayout(512));
        group.setText("Display layers");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        this.layerViewer = new Table((Composite)group, 68100);
        this.layerViewer.setHeaderVisible(false);
        this.layerViewer.setLinesVisible(false);
        this.layerViewer.setLayoutData((Object)gridData2);
        Composite containerButtons = new Composite((Composite)group, 0);
        containerButtons.setLayout((Layout)new FillLayout(256));
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        containerButtons.setLayoutData((Object)gridData3);
        Button addLayerBtn = new Button(containerButtons, 524288);
        addLayerBtn.setText("Add");
        addLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ELayer elayer = GamaFactory.eINSTANCE.createELayer();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)EditDisplayFrame.this.eobject);
                if (domain != null) {
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        public void doExecute() {
                            elayer.setName("Layer");
                            elayer.setDisplay((EDisplay)(this).EditDisplayFrame.this.eobject);
                            (this).EditDisplayFrame.this.diagram.eResource().getContents().add((Object)elayer);
                            TableItem ti = new TableItem((this).EditDisplayFrame.this.layerViewer, 0);
                            ti.setText(elayer.getName());
                            ti.setBackground(EditDisplayFrame.this.hasError(elayer) ? new Color((Device)(this).EditDisplayFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)(this).EditDisplayFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                            ((EDisplay)(this).EditDisplayFrame.this.eobject).getLayers().add((Object)elayer);
                        }
                    });
                }
                EditDisplayFrame.this.ef.hasDoneChanges = true;
                EditLayerFrame eaf = new EditLayerFrame(elayer, EditDisplayFrame.this.frame, EditDisplayFrame.this.species, EditDisplayFrame.this.grids, false, EditDisplayFrame.this.diagram, EditDisplayFrame.this.fp, EditDisplayFrame.this.ef);
                EditDisplayFrame.this.layerFrames.put(elayer, eaf);
                eaf.open();
                EditDisplayFrame.this.frame.updateLayerId();
            }
        });
        Button editLayerBtn = new Button(containerButtons, 524288);
        editLayerBtn.setText("Edit");
        editLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDisplayFrame.this.layerViewer.getSelectionCount() == 1) {
                    EditDisplayFrame.this.updateLayerId();
                    int index = EditDisplayFrame.this.layerViewer.getSelectionIndex();
                    ELayer layer = (ELayer)((EDisplay)EditDisplayFrame.this.eobject).getLayers().get(index);
                    EditLayerFrame eaf = EditDisplayFrame.this.layerFrames.get(layer);
                    if (eaf == null || eaf.getShell() == null || eaf.getShell().isDisposed()) {
                        eaf = new EditLayerFrame(layer, EditDisplayFrame.this.frame, EditDisplayFrame.this.species, EditDisplayFrame.this.grids, true, EditDisplayFrame.this.diagram, EditDisplayFrame.this.fp, EditDisplayFrame.this.ef);
                        eaf.open();
                        EditDisplayFrame.this.layerFrames.put(layer, eaf);
                    } else {
                        eaf.getShell().setFocus();
                    }
                }
            }
        });
        Button removeLayerBtn = new Button(containerButtons, 524288);
        removeLayerBtn.setText("Remove");
        removeLayerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDisplayFrame.this.layerViewer.getSelectionCount() == 1) {
                    final int index = EditDisplayFrame.this.layerViewer.getSelectionIndex();
                    EditDisplayFrame.this.layerViewer.remove(index);
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)EditDisplayFrame.this.eobject);
                    if (domain != null) {
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            public void doExecute() {
                                ELayer lay = (ELayer)((EDisplay)(this).EditDisplayFrame.this.eobject).getLayers().remove(index);
                                (this).EditDisplayFrame.this.layerFrames.remove(lay);
                                (this).EditDisplayFrame.this.diagram.eResource().getContents().remove((Object)lay);
                                EcoreUtil.delete((EObject)lay);
                            }
                        });
                    }
                    EditDisplayFrame.this.frame.updateLayerId();
                    EditDisplayFrame.this.save("");
                    ModelGenerator.modelValidation(EditDisplayFrame.this.fp, EditDisplayFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                    EditDisplayFrame.this.ef.hasDoneChanges = true;
                }
            }
        });
        Button btnUp = new Button(containerButtons, 132);
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (EditDisplayFrame.this.layerViewer.getSelectionCount() == 1 && (index = EditDisplayFrame.this.layerViewer.getSelectionIndex()) > 0) {
                    ((EDisplay)EditDisplayFrame.this.eobject).getLayers().move(index - 1, index);
                    EditDisplayFrame.this.layerViewer.removeAll();
                    for (ELayer la : ((EDisplay)EditDisplayFrame.this.eobject).getLayers()) {
                        TableItem ti = new TableItem(EditDisplayFrame.this.layerViewer, 0);
                        ti.setText(la.getName());
                        ti.setBackground(EditDisplayFrame.this.hasError(la) ? new Color((Device)EditDisplayFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)EditDisplayFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                    }
                }
            }
        });
        Button btnDown = new Button(containerButtons, 1028);
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                if (EditDisplayFrame.this.layerViewer.getSelectionCount() == 1 && (index = EditDisplayFrame.this.layerViewer.getSelectionIndex()) < EditDisplayFrame.this.layerViewer.getItemCount() - 1) {
                    ((EDisplay)EditDisplayFrame.this.eobject).getLayers().move(index + 1, index);
                    EditDisplayFrame.this.layerViewer.removeAll();
                    for (ELayer la : ((EDisplay)EditDisplayFrame.this.eobject).getLayers()) {
                        TableItem ti = new TableItem(EditDisplayFrame.this.layerViewer, 0);
                        ti.setText(la.getName());
                        ti.setBackground(EditDisplayFrame.this.hasError(la) ? new Color((Device)EditDisplayFrame.this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)EditDisplayFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                    }
                }
            }
        });
        return group;
    }

    public void updateLayerId() {
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        ArrayList<String> loc = new ArrayList<String>();
        diagramEditor.buildLocation(this.eobject, loc);
        int size = loc.size();
        ArrayList<List<String>> ids = new ArrayList<List<String>>(diagramEditor.getIdsEObjects().keySet());
        for (List list : ids) {
            if (list.size() <= size || !((String)list.get(list.size() - 2)).equals(this.eobject.getName())) continue;
            diagramEditor.getIdsEObjects().remove(list);
        }
        for (ELayer eLayer : ((EDisplay)this.eobject).getLayers()) {
            if (eLayer.getType() == null) continue;
            ArrayList<String> key = new ArrayList<String>(loc);
            key.add(eLayer.getType());
            diagramEditor.getIdsEObjects().put(key, this.eobject);
        }
    }

    @Override
    protected Point getInitialSize() {
        return new Point(1300, 750);
    }

    public Table getLayerViewer() {
        return this.layerViewer;
    }

    private void modifyOtherProperties() {
        EDisplay display = (EDisplay)this.eobject;
        display.setName(this.textName.getText());
        this.saveFacets();
    }

    @Override
    protected void save(final String name) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    if (name == null) {
                        EditDisplayFrame.this.eobject.setName(EditDisplayFrame.this.textName.getText());
                        EditDisplayFrame.this.modifyOtherProperties();
                        EDisplay asp = (EDisplay)EditDisplayFrame.this.eobject;
                        asp.setGamlCode(EditDisplayFrame.this.modelXText.getEditablePart());
                        asp.setDefineGamlCode(EditDisplayFrame.this.radioGaml.getSelection());
                    } else if ("name".equals(name)) {
                        EditDisplayFrame.this.eobject.setName(EditDisplayFrame.this.textName.getText());
                    } else {
                        EDisplay asp = (EDisplay)EditDisplayFrame.this.eobject;
                        asp.setGamlCode(EditDisplayFrame.this.modelXText.getEditablePart());
                        asp.setDefineGamlCode(EditDisplayFrame.this.radioGaml.getSelection());
                        EditDisplayFrame.this.modifyOtherProperties();
                    }
                }
            });
        }
        this.ef.hasDoneChanges = true;
    }

    public void updateLayer() {
        this.layerViewer.removeAll();
        for (ELayer elayer : ((EDisplay)this.eobject).getLayers()) {
            TableItem ti = new TableItem(this.layerViewer, 0);
            ti.setText(elayer.getName());
            ti.setBackground(this.hasError(elayer) ? new Color((Device)this.frame.getShell().getDisplay(), 255, 100, 100) : new Color((Device)this.frame.getShell().getDisplay(), 100, 255, 100));
        }
    }

    public boolean testBasicOk(ELayer lay, List<String> speciesStr) {
        return lay.getType() == null || "species".equals(lay.getType()) && speciesStr.contains(lay.getSpecies());
    }

    public boolean hasError(ELayer elayer) {
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        ArrayList<String> speciesStr = new ArrayList<String>();
        for (ESpecies sp : this.species) {
            speciesStr.add(sp.getName());
        }
        ArrayList<String> ids = new ArrayList<String>();
        boolean basicOk = this.testBasicOk(elayer, speciesStr);
        if (basicOk) {
            return false;
        }
        diagramEditor.buildLocation(elayer, ids);
        if (diagramEditor.getErrorsLoc().isEmpty() && diagramEditor.getSyntaxErrorsLoc().isEmpty()) {
            return false;
        }
        return diagramEditor.getErrorsLoc().containsKey(ids) || diagramEditor.getSyntaxErrorsLoc().containsKey(ids);
    }

    public List<ESpecies> getGrids() {
        return this.grids;
    }

    public static boolean isNumber(String s) {
        return s == null || s.isEmpty() || DOUBLE_PATTERN.matcher(s).matches();
    }
}

