/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import com.google.inject.Injector;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.descriptions.FacetProto;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.factories.DescriptionFactory;
import gama.ui.diagram.editor.GAMARessourceProvider;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.editor.ModelStructure;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.edit.EditFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAction;
import gama.ui.diagram.metamodel.EFacet;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.EReflex;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EWorldAgent;
import gama.ui.diagram.metamodel.GamaFactory;
import gama.ui.diagram.swt.editFrame.UtilEditFrame;
import gama.ui.diagram.swt.editFrame.ValidateText;
import gama.ui.editor.internal.EditorActivator;
import gaml.compiler.gaml.Model;
import gaml.compiler.gaml.impl.S_ActionImpl;
import gaml.compiler.gaml.impl.S_DefinitionImpl;
import gaml.compiler.gaml.impl.S_DisplayImpl;
import gaml.compiler.gaml.impl.S_ExperimentImpl;
import gaml.compiler.gaml.impl.S_ReflexImpl;
import gaml.compiler.gaml.impl.S_SpeciesImpl;
import gaml.compiler.gaml.impl.VariableRefImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.SynchronizedXtextResourceSet;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public abstract class EditFrame
extends ApplicationWindow {
    Diagram diagram;
    EditFeature ef;
    IFeatureProvider fp;
    String name;
    EGamaObject eobject;
    ValidateText textName;
    EditFrame frame;
    Shell shell;
    EmbeddedEditorModelAccess modelXText;
    EmbeddedEditor editor;
    Button radioGaml;
    Button radioEdit;
    List<CCombo> combos;
    Map<String, Composite> facetsEditor;
    List<String> facetsToRemove;
    List<String> gridFacets = Arrays.asList("schedules", "frequency", "control", "neighbors", "file", "cell_height", "cell_width", "width", "height", "use_regular_agents", "use_individual_shapes", "use_neighbors_cache");
    List<String> globalFacets = Arrays.asList("schedules", "frequency", "control", "torus");
    List<String> speciesFacets = Arrays.asList("schedules", "frequency", "control");
    Map<String, List<String>> comboValues;
    GAMARessourceProvider rp;

    public EditFrame(Diagram diagram, IFeatureProvider fp, EditFeature ef, EGamaObject eobject, String name, List<String> facetsToRemove) {
        super(null);
        this.facetsToRemove = facetsToRemove;
        this.facetsEditor = new Hashtable<String, Composite>();
        this.combos = new ArrayList<CCombo>();
        this.diagram = diagram;
        this.frame = this;
        this.fp = fp;
        this.ef = ef;
        this.name = name;
        this.eobject = eobject;
        this.addToolBar(0x800040);
        this.addMenuBar();
        this.addStatusLine();
        ModelGenerator.modelValidation(fp, diagram);
    }

    public EditFrame(Diagram diagram, IFeatureProvider fp, EditFeature ef, EGamaObject eobject, String name) {
        super(null);
        this.facetsToRemove = new ArrayList<String>();
        this.facetsEditor = new Hashtable<String, Composite>();
        this.combos = new ArrayList<CCombo>();
        this.diagram = diagram;
        this.frame = this;
        this.fp = fp;
        this.ef = ef;
        this.name = name;
        this.eobject = eobject;
        this.addToolBar(0x800040);
        this.addMenuBar();
        this.addStatusLine();
        ModelGenerator.modelValidation(fp, diagram);
    }

    public List<String> getFacetsToRemove() {
        return this.facetsToRemove;
    }

    public static String fromErrorToString(GamlCompilationError error) {
        StringBuilder result = new StringBuilder("Error concerning: ");
        EObject toto = error.getStatement();
        ArrayList<String> ids = new ArrayList<String>();
        do {
            if (toto instanceof VariableRefImpl) {
                VariableRefImpl vv = (VariableRefImpl)toto;
                ids.add(0, vv.getRef().getName());
                continue;
            }
            if (toto instanceof S_ReflexImpl) {
                S_ReflexImpl vv = (S_ReflexImpl)toto;
                if (vv.getName() != null) {
                    ids.add(0, vv.getName());
                    continue;
                }
                ids.add(0, "init");
                continue;
            }
            if (toto instanceof S_ExperimentImpl) {
                S_ExperimentImpl vv = (S_ExperimentImpl)toto;
                ids.add(0, vv.getName());
                continue;
            }
            if (toto instanceof S_DisplayImpl) {
                S_DisplayImpl vv = (S_DisplayImpl)toto;
                ids.add(0, vv.getName());
                continue;
            }
            if (toto instanceof S_ActionImpl) {
                S_ActionImpl vv = (S_ActionImpl)toto;
                ids.add(0, vv.getName());
                continue;
            }
            if (toto instanceof S_SpeciesImpl) {
                S_SpeciesImpl vv = (S_SpeciesImpl)toto;
                ids.add(0, vv.getName());
                continue;
            }
            if (!(toto instanceof S_DefinitionImpl)) continue;
            S_DefinitionImpl vv = (S_DefinitionImpl)toto;
            ids.add(0, vv.getName());
        } while (!((toto = toto.eContainer()) instanceof Model));
        for (String id : ids) {
            result.append("->").append(id);
        }
        result.append(" : ").append(error.toString());
        return result.toString();
    }

    protected Group groupFacets(Composite container, String gamlName, int nbCol) {
        List<String> facets;
        SymbolProto proto = "layer".equals(gamlName) ? DescriptionFactory.getStatementProto((String)"species_layer") : DescriptionFactory.getStatementProto((String)gamlName);
        Group group = new Group(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(nbCol, false));
        if ("grid".equals(gamlName)) {
            facets = this.gridFacets;
        } else if ("global".equals(gamlName)) {
            facets = this.globalFacets;
        } else if ("species".equals(gamlName)) {
            facets = this.speciesFacets;
        } else {
            facets = new ArrayList(proto.getPossibleFacets().keySet());
            facets.removeAll(this.facetsToRemove);
            Collections.sort(facets);
        }
        for (String facet : facets) {
            FacetProto pt = proto.getFacet(facet);
            if (pt.deprecated != null || pt.internal || !"name".equals(gamlName) && "name".equals(facet) || "layer".equals(gamlName) && ("aspect".equals(facet) || "species".equals(facet))) continue;
            if (this.comboValues != null && this.comboValues.containsKey(facet)) {
                this.combos.add(this.groupFacetCombo((Composite)group, facet, this.comboValues.get(facet), pt.doc));
                continue;
            }
            this.groupFacet((Composite)group, facet, pt.typesToString(), pt.doc);
        }
        return group;
    }

    protected CCombo groupFacetCombo(Composite container, String facetName, List<String> values, String doc) {
        Group group = new Group(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        CLabel lblName = new CLabel((Composite)group, 0);
        lblName.setText(facetName + ":");
        CCombo textFacet = new CCombo((Composite)group, 2048);
        String[] items = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            items[i] = values.get(i);
            ++i;
        }
        textFacet.setItems(items);
        textFacet.setText(values.get(0));
        textFacet.setToolTipText(doc);
        String val = this.facetValue(facetName);
        if (val != null && !val.isEmpty()) {
            textFacet.setText(val);
        }
        GridData gridData2 = new GridData();
        gridData2.heightHint = 20;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        textFacet.setLayoutData((Object)gridData2);
        this.facetsEditor.put(facetName, (Composite)textFacet);
        textFacet.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditFrame.this.save(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return textFacet;
    }

    protected void groupFacet(Composite container, String facetName, String type, String doc) {
        Group group = new Group(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        CLabel lblName = new CLabel((Composite)group, 0);
        lblName.setText(facetName + " (" + type.replaceFirst(" ", "") + "):");
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        ArrayList<String> uselessName = null;
        String nm = "";
        if (!"name".equals(facetName)) {
            uselessName = new ArrayList<String>();
            uselessName.add("name");
        } else {
            nm = "name";
        }
        ValidateText textFacet = new ValidateText((Composite)group, 2048, this.diagram, this.fp, this, diagramEditor, nm, uselessName, null);
        textFacet.setToolTipText(doc);
        String val = this.facetValue(facetName);
        if (val != null) {
            textFacet.setText(val);
        } else {
            textFacet.setText("");
        }
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        textFacet.setLayoutData(gridData2);
        if (this.eobject instanceof EWorldAgent && "name".equals(facetName)) {
            textFacet.setEditable(false);
        }
        textFacet.setSaveData(true);
        this.facetsEditor.put(facetName, (Composite)textFacet);
    }

    protected void groupRadioGamlCode(Composite container, String title) {
        Group group = new Group(container, 0);
        group.setLayout((Layout)new FillLayout(256));
        CLabel lblName = new CLabel((Composite)group, 0);
        lblName.setText("Define " + title + " through GAML code: ");
        GridData gridData = new GridData();
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(3, false));
        this.radioGaml = new Button((Composite)group, 16);
        this.radioGaml.setText("Yes");
        this.radioGaml.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditFrame.this.removeOther();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.radioEdit = new Button((Composite)group, 16);
        this.radioEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditFrame.this.removeGaml();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.radioEdit.setText("No");
    }

    public static void recursiveSetEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite comp = (Composite)control;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                EditFrame.recursiveSetEnabled(c, enabled);
                ++n2;
            }
        }
        if (enabled) {
            control.setForeground(new Color((Device)control.getDisplay(), 0, 0, 0));
        } else {
            control.setForeground(new Color((Device)control.getDisplay(), 200, 200, 200));
        }
        control.setEnabled(enabled);
    }

    public void removeGaml() {
    }

    public void removeOther() {
    }

    protected Group groupGamlCode(Composite container, String title) {
        Group group = new Group(container, 0);
        group.setLayout((Layout)new FillLayout(256));
        group.setText(title);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(1, false));
        Injector injector = EditorActivator.getInstance().getInjector("gaml.compiler.Gaml");
        this.rp = (GAMARessourceProvider)injector.getInstance(GAMARessourceProvider.class);
        this.rp.setName(ExampleUtil.getDiagramEditor(this.fp), this.fp, this.diagram);
        EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        this.editor = factory.newEditor((IEditedResourceProvider)this.rp).showErrorAndWarningAnnotations().withParent((Composite)group);
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        ModelStructure struct = new ModelStructure(this.diagram, this.fp);
        struct.writeModelWithoutElement(this.eobject);
        this.modelXText = this.editor.createPartialEditor(struct.getPrefix(), struct.getText(), struct.getSuffix(), true);
        return group;
    }

    protected void groupName(Composite container) {
        this.groupName(container, true);
    }

    protected void groupName(Composite container, boolean hasNameFaeture) {
        Group group = new Group(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        CLabel lblName = new CLabel((Composite)group, 0);
        lblName.setText("Name:");
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        this.textName = new ValidateText((Composite)group, 2048, this.diagram, this.fp, this, diagramEditor, "name", null, null);
        this.textName.setNameFeature(hasNameFaeture);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        this.textName.setLayoutData(gridData2);
        this.textName.setText(this.eobject.getName());
        if (this.eobject instanceof EWorldAgent) {
            this.textName.setEditable(false);
        }
        this.textName.setSaveData(true);
    }

    protected Canvas canvasName(Composite container) {
        return this.canvasName(container, true);
    }

    protected Canvas canvasName(Composite container, boolean hasNameFeature) {
        Canvas canvasName = new Canvas(container, 2048);
        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        this.textName = new ValidateText((Composite)canvasName, 2048, this.diagram, this.fp, this, diagramEditor, "name", null, null);
        this.textName.setNameFeature(hasNameFeature);
        UtilEditFrame.buildCanvasName(container, canvasName, this.textName, this.eobject, this.ef);
        canvasName.setBounds(10, 10, 720, 30);
        this.textName.setSaveData(true);
        return canvasName;
    }

    protected MenuManager createMenuManager() {
        MenuManager menuManager = new MenuManager("menu");
        return menuManager;
    }

    protected ToolBarManager createToolBarManager(int style) {
        ToolBarManager toolBarManager = new ToolBarManager(style);
        return toolBarManager;
    }

    protected StatusLineManager createStatusLineManager() {
        StatusLineManager statusLineManager = new StatusLineManager();
        return statusLineManager;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.name);
    }

    protected Point getInitialSize() {
        return new Point(743, 727);
    }

    protected abstract void save(String var1);

    protected void clean_close() {
        this.frame.clean();
        this.save(null);
        for (CCombo c : this.combos) {
            if (c != null) {
                c.dispose();
            }
            Object var1_2 = null;
        }
        this.combos.clear();
        this.setReturnCode(1);
    }

    protected void handleShellCloseEvent() {
        this.frame.clean();
        this.save(null);
        super.handleShellCloseEvent();
    }

    public void create() {
        this.setShellStyle(2160);
        super.create();
        this.shell = this.getShell();
    }

    protected void clean() {
    }

    public void updateError() {
    }

    public String facetValue(String facetName) {
        for (EFacet facet : this.eobject.getFacets()) {
            if (!facet.getName().equals(facetName)) continue;
            return facet.getValue();
        }
        return null;
    }

    public void saveFacets() {
        for (String facet : this.facetsEditor.keySet()) {
            Composite vt = this.facetsEditor.get(facet);
            if (vt == null) continue;
            if (vt instanceof ValidateText) {
                this.saveFacetValue(facet, ((ValidateText)this.facetsEditor.get(facet)).getText());
                continue;
            }
            if (!(vt instanceof CCombo)) continue;
            this.saveFacetValue(facet, ((CCombo)this.facetsEditor.get(facet)).getText());
        }
    }

    public void saveFacetValue(final String facetName, final String facetValue) {
        for (EFacet facet : this.eobject.getFacets()) {
            if (!facet.getName().equals(facetName)) continue;
            facet.setValue(facetValue);
            return;
        }
        final EFacet eFacet = GamaFactory.eINSTANCE.createEFacet();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    eFacet.setName(facetName);
                    eFacet.setValue(facetValue);
                    EditFrame.this.diagram.eResource().getContents().add((Object)eFacet);
                    EditFrame.this.eobject.getFacets().add((Object)eFacet);
                }
            });
        }
    }

    public void saveEditorCode() {
        if (this.modelXText == null) {
            return;
        }
        if (this.eobject instanceof ESpecies) {
            ((ESpecies)this.eobject).setInit(this.modelXText.getEditablePart());
        } else if (this.eobject instanceof EAction) {
            ((EAction)this.eobject).setGamlCode(this.modelXText.getEditablePart());
        } else if (this.eobject instanceof EReflex) {
            ((EReflex)this.eobject).setGamlCode(this.modelXText.getEditablePart());
        }
    }

    public void updateEditor() {
        if (this.modelXText == null) {
            return;
        }
        this.saveEditorCode();
        SynchronizedXtextResourceSet rs = new SynchronizedXtextResourceSet();
        rs.setClasspathURIContext(ModelGenerator.class);
        ModelStructure struct = new ModelStructure(this.diagram, this.fp);
        struct.writeModelWithoutElement(this.eobject);
        this.modelXText.updateModel(struct.getPrefix(), struct.getText(), struct.getSuffix());
    }

    public ValidateText getTextName() {
        return this.textName;
    }
}

