/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.edit.EditFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EAspectLink;
import gama.ui.diagram.metamodel.EChartLayer;
import gama.ui.diagram.metamodel.EGamaObject;
import gama.ui.diagram.metamodel.ELayer;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.GamaFactory;
import gama.ui.diagram.swt.editFrame.EditDisplayFrame;
import gama.ui.diagram.swt.editFrame.EditFrame;
import gama.ui.diagram.swt.editFrame.ValidateText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EditLayerFrame
extends EditFrame {
    private CCombo comboType;
    private final String[] type_shape = new String[]{"species", "grid", "agents", "image", "text", "chart"};
    private String[] species_list;
    private String[] grid_list;
    private Map<String, String[]> aspectsSpecies;
    private final String[] styles_layer = new String[]{"line", "whisker", "area", "bar", "dot", "step", "spline", "stack", "3d", "ring", "exploded"};
    private final String[] types_chart = new String[]{"series", "histogram", "pie", "box_whisker", "xy"};
    private String[] aspects;
    EditLayerFrame layerFrame;
    private ValidateText textPath;
    private ValidateText textText;
    private ValidateText textSizeText;
    private ValidateText textAgents;
    Composite speciesComp;
    Composite chartComp;
    Composite gridComp;
    Composite agentsComp;
    Composite textComp;
    Composite imageComp;
    Composite shapeComp;
    private CCombo comboSpecies;
    private CCombo comboAspectsSpecies;
    private CCombo comboAspectsAgents;
    private CCombo comboGrid;
    private CCombo comboTypeChart;
    boolean ok = false;
    boolean edit;
    private Table table_chart_layers;
    EditDisplayFrame frame;
    EditLayerFrame cFrame;
    Color color;
    int[] rgb;
    Button btnShowLines;
    ValidateText textColorGrid;
    Button btnCstColGrid;
    Button btnExpressionGrid;
    Label colorLabelGrid;
    ValidateText textColorText;
    Button btnCstColText;
    Button btnExpressionText;
    Label colorLabelText;
    ValidateText textColorImage;
    Button btnCstColImage;
    Button btnExpressionImage;
    Label colorLabelImage;
    ValidateText textColorChart;
    Button btnExpressionChart;
    Button btnCstColChart;
    Label colorLabelChart;
    List<ESpecies> species;
    List<ESpecies> grids;
    Diagram diagram;

    public EditLayerFrame(Diagram diagram, IFeatureProvider fp, EditFeature ef, EGamaObject eobject, String name) {
        super(diagram, fp, ef, eobject, name);
    }

    public EditLayerFrame(ELayer elayer, EditDisplayFrame asp, List<ESpecies> species, List<ESpecies> grids, boolean edit, Diagram diagram, IFeatureProvider fp, EditFeature ef) {
        super(diagram, fp, ef, elayer, "Edit Layer");
        this.frame = asp;
        this.cFrame = this;
        this.layerFrame = this;
        this.species = species;
        this.grids = grids;
        this.updateSpeciesAspect();
        this.rgb = new int[3];
        this.rgb[2] = 255;
        this.rgb[1] = 255;
        this.rgb[0] = 255;
        this.diagram = diagram;
        this.edit = edit;
    }

    public void updateSpeciesAspect() {
        this.aspectsSpecies = new Hashtable<String, String[]>();
        this.species_list = new String[this.species.size()];
        ArrayList<String> aspectsL = new ArrayList<String>();
        int i = 0;
        while (i < this.species_list.length) {
            ESpecies sp = this.species.get(i);
            ArrayList<String> aspL = new ArrayList<String>(this.aspectSpecies(aspectsL, sp));
            if (aspL.isEmpty()) {
                aspL.add("default");
            }
            this.aspectsSpecies.put(sp.getName(), aspL.toArray(new String[aspL.size()]));
            this.species_list[i] = sp.getName();
            ++i;
        }
        this.aspects = aspectsL.toArray(new String[aspectsL.size()]);
        this.grid_list = new String[this.grids.size()];
        i = 0;
        while (i < this.grid_list.length) {
            this.grid_list[i] = this.grids.get(i).getName();
            ++i;
        }
    }

    private void loadData() {
        ELayer elayer = (ELayer)this.eobject;
        if (elayer.getType() != null) {
            this.comboType.setText(elayer.getType());
        }
        if (elayer.getText() != null) {
            this.textText.setText(elayer.getText());
        }
        if (elayer.getSize() != null) {
            this.textSizeText.setText(elayer.getSize());
        }
        if (elayer.getAgents() != null) {
            this.textAgents.setText(elayer.getAgents());
        }
        if (elayer.getSpecies() != null) {
            List<String> ln = Arrays.asList(this.species_list);
            if (ln.contains(elayer.getSpecies())) {
                this.comboSpecies.setText(elayer.getSpecies());
            } else {
                this.comboSpecies.setText("world");
            }
        }
        if (elayer.getGrid() != null) {
            this.comboGrid.setText(elayer.getGrid());
        }
        if (elayer.getAspect() != null) {
            List<String> la = Arrays.asList(this.aspectsSpecies.get(this.comboSpecies.getText()));
            if (la.contains(elayer.getAspect())) {
                this.comboAspectsSpecies.setText(elayer.getAspect());
            } else {
                this.comboAspectsSpecies.setText("");
            }
            List<String> la2 = Arrays.asList(this.aspects);
            if (la2.contains(elayer.getAspect())) {
                this.comboAspectsAgents.setText(elayer.getAspect());
            }
        }
        if (elayer.getColor() != null) {
            this.textColorChart.setText(elayer.getColor());
            this.textColorGrid.setText(elayer.getColor());
            this.textColorText.setText(elayer.getColor());
            this.textColorImage.setText(elayer.getColor());
        }
        if (elayer.getIsColorCst() != null) {
            boolean selected = elayer.getIsColorCst();
            this.btnCstColChart.setSelection(selected);
            this.btnCstColImage.setSelection(selected);
            this.btnCstColText.setSelection(selected);
            this.btnCstColGrid.setSelection(selected);
            this.textColorChart.setEnabled(!selected);
            this.textColorImage.setEnabled(!selected);
            this.textColorText.setEnabled(!selected);
            this.textColorGrid.setEnabled(!selected);
            this.btnExpressionChart.setSelection(!selected);
            this.btnExpressionImage.setSelection(!selected);
            this.btnExpressionText.setSelection(!selected);
            this.btnExpressionGrid.setSelection(!selected);
        }
        if (elayer.getColorRBG() != null && elayer.getColorRBG().size() == 3) {
            this.rgb[0] = (Integer)elayer.getColorRBG().get(0);
            this.rgb[1] = (Integer)elayer.getColorRBG().get(1);
            this.rgb[2] = (Integer)elayer.getColorRBG().get(2);
            this.color = new Color((Device)this.frame.getShell().getDisplay(), new RGB(this.rgb[0], this.rgb[1], this.rgb[2]));
            this.colorLabelGrid.setBackground(this.color);
            this.colorLabelText.setBackground(this.color);
            this.colorLabelImage.setBackground(this.color);
            this.colorLabelChart.setBackground(this.color);
        }
        if (elayer.getChart_type() != null) {
            this.comboTypeChart.setText(elayer.getChart_type());
        }
        this.initTable();
        this.frame.updateLayerId();
    }

    public void buildColorComposite(Composite compositeColor, final ValidateText textColor, final Label colorLabel, Button button, Button btnCstCol, Button btnExpressionCol, String text) {
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        compositeColor.setSize(700, 20);
        CLabel lblColor = new CLabel(compositeColor, 0);
        lblColor.setText("Color:");
        lblColor.setBounds(0, 0, 110, 20);
        textColor.setEnabled(false);
        button.setText("Color...");
        button.setBounds(250, 0, 80, 20);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(EditLayerFrame.this.cFrame.getShell());
                dlg.setRGB(colorLabel.getBackground().getRGB());
                dlg.setText("Choose a Color");
                RGB rgbL = dlg.open();
                if (rgbL != null) {
                    EditLayerFrame.this.rgb[0] = rgbL.red;
                    EditLayerFrame.this.rgb[1] = rgbL.green;
                    EditLayerFrame.this.rgb[2] = rgbL.blue;
                    EditLayerFrame.this.save("");
                    ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                    EditLayerFrame.this.color.dispose();
                    EditLayerFrame.this.color = new Color((Device)EditLayerFrame.this.frame.getShell().getDisplay(), rgbL);
                    colorLabel.setBackground(EditLayerFrame.this.color);
                }
            }
        });
        btnCstCol.setText("Constant");
        btnCstCol.setSelection(true);
        btnCstCol.setBounds(0, 0, 85, 18);
        btnCstCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                textColor.setEnabled(false);
                if (textColor.isSaveData()) {
                    EditLayerFrame.this.save("");
                    ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                }
            }
        });
        this.color = new Color((Device)this.frame.getShell().getDisplay(), new RGB(this.rgb[0], this.rgb[1], this.rgb[2]));
        colorLabel.setText("                  ");
        colorLabel.setBackground(this.color);
        colorLabel.setBounds(190, 0, 50, 18);
        btnExpressionCol.setText("Expression:");
        btnExpressionCol.setBounds(260, 0, 85, 18);
        btnExpressionCol.setSelection(true);
        btnExpressionCol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                textColor.setEnabled(true);
                if (textColor.isSaveData()) {
                    EditLayerFrame.this.save("");
                    ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                }
            }
        });
        textColor.setBounds(465, 0, 200, 18);
    }

    private Set<String> aspectSpecies(List<String> aspectsL, ESpecies sp) {
        HashSet<String> aspL = new HashSet<String>();
        for (EAspectLink al : sp.getAspectLinks()) {
            String apN = al.getAspect().getName();
            aspL.add(apN);
            if (aspectsL.contains(apN)) continue;
            aspectsL.add(apN);
        }
        if (sp.getInheritsFrom() != null) {
            aspL.addAll(this.aspectSpecies(aspectsL, sp.getInheritsFrom()));
        }
        return aspL;
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setBounds(0, 0, 740, 390);
        this.canvasName(comp, false);
        this.buildCanvasTopo(comp);
        Group group = this.groupFacets(comp, "layer", 2);
        group.setBounds(10, 310, 720, 230);
        comp.pack();
        if (this.edit) {
            this.loadData();
            this.updateVisible();
        }
        this.textPath.setSaveData(true);
        this.textText.setSaveData(true);
        this.textSizeText.setSaveData(true);
        this.textAgents.setSaveData(true);
        this.textColorGrid.setSaveData(true);
        this.textColorText.setSaveData(true);
        this.textColorChart.setSaveData(true);
        this.textColorImage.setSaveData(true);
        if (!this.edit) {
            this.updateError();
            this.save("");
        }
        return comp;
    }

    @Override
    protected void save(String name) {
        final ELayer elayer = (ELayer)this.eobject;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    EditLayerFrame.this.modifyChartLayers();
                    EditLayerFrame.this.saveFacets();
                    elayer.setType(EditLayerFrame.this.comboType.getText());
                    elayer.setName(EditLayerFrame.this.textName.getText());
                    elayer.setFile(EditLayerFrame.this.textPath.getText());
                    elayer.setText(EditLayerFrame.this.textText.getText());
                    elayer.setSize(EditLayerFrame.this.textSizeText.getText());
                    elayer.setAgents(EditLayerFrame.this.textAgents.getText());
                    elayer.setSpecies(EditLayerFrame.this.comboSpecies.getText());
                    elayer.setGrid(EditLayerFrame.this.comboGrid.getText());
                    elayer.setAspect("species".equals(EditLayerFrame.this.comboType.getText()) ? EditLayerFrame.this.comboAspectsSpecies.getText() : EditLayerFrame.this.comboAspectsAgents.getText());
                    elayer.setChart_type(EditLayerFrame.this.comboTypeChart.getText());
                    elayer.getColorRBG().clear();
                    elayer.getColorRBG().add((Object)EditLayerFrame.this.rgb[0]);
                    elayer.getColorRBG().add((Object)EditLayerFrame.this.rgb[1]);
                    elayer.getColorRBG().add((Object)EditLayerFrame.this.rgb[2]);
                    elayer.setShowLines(EditLayerFrame.this.btnShowLines.getSelection());
                    if ("image".equals(elayer.getType())) {
                        elayer.setIsColorCst(EditLayerFrame.this.btnCstColImage.getSelection());
                        elayer.setColor(EditLayerFrame.this.textColorImage.getText());
                    } else if ("text".equals(elayer.getType())) {
                        elayer.setIsColorCst(EditLayerFrame.this.btnCstColText.getSelection());
                        elayer.setColor(EditLayerFrame.this.textColorText.getText());
                    } else if ("chart".equals(elayer.getType())) {
                        elayer.setIsColorCst(EditLayerFrame.this.btnCstColChart.getSelection());
                        elayer.setColor(EditLayerFrame.this.textColorChart.getText());
                    } else if ("grid".equals(elayer.getType())) {
                        elayer.setIsColorCst(EditLayerFrame.this.btnCstColGrid.getSelection());
                        elayer.setColor(EditLayerFrame.this.textColorGrid.getText());
                    }
                }
            });
        }
    }

    @Override
    public void updateError() {
        this.frame.updateLayerId();
        this.frame.updateLayer();
    }

    private void modifyChartLayers() {
        for (EChartLayer cl : ((ELayer)this.eobject).getChartlayers()) {
            this.diagram.eResource().getContents().remove((Object)cl);
            EcoreUtil.delete((EObject)cl);
        }
        ((ELayer)this.eobject).getChartlayers().clear();
        if (this.table_chart_layers != null) {
            TableItem[] tableItemArray = this.table_chart_layers.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                EChartLayer var = GamaFactory.eINSTANCE.createEChartLayer();
                this.diagram.eResource().getContents().add((Object)var);
                var.setName(item.getText(0));
                var.setStyle(item.getText(1));
                var.setColor(item.getText(2));
                var.setValue(item.getText(3));
                ((ELayer)this.eobject).getChartlayers().add((Object)var);
                ++n2;
            }
        }
    }

    private void updateVisible() {
        String val = this.comboType.getText();
        int size = this.textPath.getLoc().size() - 1;
        this.textPath.getLoc().remove(size);
        this.textPath.getLoc().add(val);
        this.textText.getLoc().remove(size);
        this.textText.getLoc().add(val);
        this.textSizeText.getLoc().remove(size);
        this.textSizeText.getLoc().add(val);
        this.textAgents.getLoc().remove(size);
        this.textAgents.getLoc().add(val);
        this.textColorChart.getLoc().remove(size);
        this.textColorChart.getLoc().add(val);
        this.textColorText.getLoc().remove(size);
        this.textColorText.getLoc().add(val);
        this.textColorGrid.getLoc().remove(size);
        this.textColorGrid.getLoc().add(val);
        this.textColorImage.getLoc().remove(size);
        this.textColorImage.getLoc().add(val);
        if ("species".equals(val)) {
            this.speciesComp.setVisible(true);
            this.speciesComp.setEnabled(true);
            this.imageComp.setVisible(false);
            this.imageComp.setEnabled(false);
            this.textComp.setEnabled(false);
            this.textComp.setVisible(false);
            this.gridComp.setEnabled(false);
            this.gridComp.setVisible(false);
            this.agentsComp.setEnabled(false);
            this.agentsComp.setVisible(false);
            this.chartComp.setEnabled(false);
            this.chartComp.setVisible(false);
        } else if ("grid".equals(val)) {
            this.speciesComp.setVisible(false);
            this.speciesComp.setEnabled(false);
            this.imageComp.setVisible(false);
            this.imageComp.setEnabled(false);
            this.textComp.setEnabled(false);
            this.textComp.setVisible(false);
            this.gridComp.setEnabled(true);
            this.gridComp.setVisible(true);
            this.agentsComp.setEnabled(false);
            this.agentsComp.setVisible(false);
            this.chartComp.setEnabled(false);
            this.chartComp.setVisible(false);
        } else if ("agents".equals(val)) {
            this.speciesComp.setVisible(false);
            this.speciesComp.setEnabled(false);
            this.imageComp.setVisible(false);
            this.imageComp.setEnabled(false);
            this.textComp.setEnabled(false);
            this.textComp.setVisible(false);
            this.gridComp.setEnabled(false);
            this.gridComp.setVisible(false);
            this.agentsComp.setEnabled(true);
            this.agentsComp.setVisible(true);
            this.chartComp.setEnabled(false);
            this.chartComp.setVisible(false);
        } else if ("image".equals(val)) {
            this.speciesComp.setVisible(false);
            this.speciesComp.setEnabled(false);
            this.imageComp.setVisible(true);
            this.imageComp.setEnabled(true);
            this.textComp.setEnabled(false);
            this.textComp.setVisible(false);
            this.gridComp.setEnabled(false);
            this.gridComp.setVisible(false);
            this.agentsComp.setEnabled(false);
            this.agentsComp.setVisible(false);
            this.chartComp.setEnabled(false);
            this.chartComp.setVisible(false);
        } else if ("text".equals(val)) {
            this.speciesComp.setVisible(false);
            this.speciesComp.setEnabled(false);
            this.imageComp.setVisible(false);
            this.imageComp.setEnabled(false);
            this.textComp.setEnabled(true);
            this.textComp.setVisible(true);
            this.gridComp.setEnabled(false);
            this.gridComp.setVisible(false);
            this.agentsComp.setEnabled(false);
            this.agentsComp.setVisible(false);
            this.chartComp.setEnabled(false);
            this.chartComp.setVisible(false);
        } else if ("chart".equals(val)) {
            this.speciesComp.setVisible(false);
            this.speciesComp.setEnabled(false);
            this.imageComp.setVisible(false);
            this.imageComp.setEnabled(false);
            this.textComp.setEnabled(false);
            this.textComp.setVisible(false);
            this.gridComp.setEnabled(false);
            this.gridComp.setVisible(false);
            this.agentsComp.setEnabled(false);
            this.agentsComp.setVisible(false);
            this.chartComp.setEnabled(true);
            this.chartComp.setVisible(true);
        }
        this.shapeComp.pack();
    }

    public void buildCanvasTopo(Composite container) {
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        Canvas canvasTopo = new Canvas(container, 2048);
        canvasTopo.setBounds(10, 50, 720, 250);
        this.shapeComp = new Composite((Composite)canvasTopo, 2048);
        this.shapeComp.setBounds(10, 5, 700, 190);
        CLabel lblShape = new CLabel(this.shapeComp, 0);
        lblShape.setBounds(5, 5, 50, 20);
        lblShape.setText("Type");
        this.comboType = new CCombo(this.shapeComp, 2048);
        this.comboType.setBounds(60, 5, 300, 20);
        if (!this.frame.getGrids().isEmpty()) {
            this.comboType.setItems(this.type_shape);
        } else {
            String[] type_shape2 = new String[]{"species", "agents", "image", "text", "chart"};
            this.comboType.setItems(type_shape2);
        }
        this.comboType.setText("species");
        this.comboType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditLayerFrame.this.updateVisible();
                EditLayerFrame.this.save("");
                EditLayerFrame.this.frame.updateLayerId();
                ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                diagramEditor.updateEObjectErrors();
            }
        });
        this.speciesComp = new Composite(this.shapeComp, 0);
        this.speciesComp.setVisible(true);
        this.speciesComp.setEnabled(true);
        this.speciesComp.setBounds(20, 40, 680, 180);
        CLabel lblSpecies = new CLabel(this.speciesComp, 0);
        lblSpecies.setBounds(0, 0, 60, 20);
        lblSpecies.setText("Species");
        this.comboSpecies = new CCombo(this.speciesComp, 2048);
        this.comboSpecies.setItems(this.species_list);
        this.comboSpecies.setBounds(70, 0, 300, 20);
        if (this.species_list.length > 0) {
            this.comboSpecies.setText(this.species_list[0]);
        }
        this.comboSpecies.addModifyListener(event -> {
            this.comboAspectsSpecies.setItems(this.aspectsSpecies.get(this.comboSpecies.getText()));
            this.comboAspectsSpecies.setText(this.aspectsSpecies.get(this.comboSpecies.getText())[0]);
            if (this.textColorText.isSaveData()) {
                this.save("");
            }
            ModelGenerator.modelValidation(this.fp, this.diagram);
            diagramEditor.updateEObjectErrors();
        });
        CLabel lblAspect = new CLabel(this.speciesComp, 0);
        lblAspect.setBounds(0, 30, 60, 20);
        lblAspect.setText("Aspect");
        this.comboAspectsSpecies = new CCombo(this.speciesComp, 2048);
        this.comboAspectsSpecies.setEditable(false);
        this.comboAspectsSpecies.setItems(this.aspectsSpecies.get(this.comboSpecies.getText()));
        this.comboAspectsSpecies.setBounds(70, 30, 300, 20);
        if (this.species_list.length > 0) {
            this.comboAspectsSpecies.setText(this.aspectsSpecies.get(this.comboSpecies.getText())[0]);
        }
        this.comboAspectsSpecies.addModifyListener(event -> {
            if (this.textColorText.isSaveData()) {
                this.save("");
            }
            ModelGenerator.modelValidation(this.fp, this.diagram);
            diagramEditor.updateEObjectErrors();
        });
        this.gridComp = new Composite(this.shapeComp, 0);
        this.gridComp.setVisible(false);
        this.gridComp.setEnabled(false);
        this.gridComp.setBounds(20, 40, 670, 190);
        CLabel lblGrid = new CLabel(this.gridComp, 0);
        lblGrid.setBounds(0, 0, 60, 20);
        lblGrid.setText("grid");
        this.comboGrid = new CCombo(this.gridComp, 2048);
        this.comboGrid.setItems(this.grid_list);
        this.comboGrid.setBounds(70, 0, 300, 20);
        if (this.grid_list.length > 0) {
            this.comboGrid.setText(this.grid_list[0]);
        }
        CLabel lblSL = new CLabel(this.gridComp, 0);
        lblSL.setBounds(0, 40, 90, 20);
        lblSL.setText("Show Lines");
        this.btnShowLines = new Button(this.gridComp, 32);
        this.btnShowLines.setBounds(100, 40, 20, 20);
        this.btnShowLines.setSelection(((ELayer)this.eobject).isShowLines());
        this.btnShowLines.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (EditLayerFrame.this.textColorText.isSaveData()) {
                    EditLayerFrame.this.save("");
                }
                ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                diagramEditor.updateEObjectErrors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (EditLayerFrame.this.textColorText.isSaveData()) {
                    EditLayerFrame.this.save("");
                }
                ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                diagramEditor.updateEObjectErrors();
            }
        });
        Composite ccg = new Composite(this.gridComp, 0);
        this.textColorGrid = new ValidateText(ccg, 0, this.diagram, this.fp, this, diagramEditor, "color:", null, null);
        this.colorLabelGrid = new Label(ccg, 0);
        Button button1 = new Button(ccg, 8);
        Composite cColor1 = new Composite(ccg, 0);
        cColor1.setBounds(110, 0, 400, 18);
        this.btnCstColGrid = new Button(cColor1, 16);
        this.btnExpressionGrid = new Button(cColor1, 16);
        this.buildColorComposite(ccg, this.textColorGrid, this.colorLabelGrid, button1, this.btnCstColGrid, this.btnExpressionGrid, "line color");
        ccg.setLocation(0, 70);
        this.imageComp = new Composite(this.shapeComp, 0);
        this.imageComp.setBounds(20, 40, 680, 180);
        this.imageComp.setVisible(false);
        this.imageComp.setEnabled(false);
        CLabel lblPath = new CLabel(this.imageComp, 0);
        lblPath.setBounds(0, 0, 60, 20);
        lblPath.setText("Path");
        this.textPath = new ValidateText(this.imageComp, 2048, this.diagram, this.fp, this, diagramEditor, "file:", null, null);
        this.textPath.setString(true);
        this.textPath.setBounds(70, 0, 300, 20);
        this.textPath.setText("../images/background.png");
        Composite cci = new Composite(this.imageComp, 0);
        this.textColorImage = new ValidateText(cci, 0, this.diagram, this.fp, this, diagramEditor, "color:", null, null);
        this.colorLabelImage = new Label(cci, 0);
        Button button2 = new Button(cci, 8);
        Composite cColor2 = new Composite(cci, 0);
        cColor2.setBounds(110, 0, 400, 18);
        this.btnCstColImage = new Button(cColor2, 16);
        this.btnExpressionImage = new Button(cColor2, 16);
        this.buildColorComposite(cci, this.textColorImage, this.colorLabelImage, button2, this.btnCstColImage, this.btnExpressionImage, "color");
        cci.setLocation(0, 30);
        this.textComp = new Composite(this.shapeComp, 0);
        this.textComp.setBounds(20, 40, 680, 180);
        this.textComp.setVisible(false);
        this.textComp.setEnabled(false);
        CLabel lbltext = new CLabel(this.textComp, 0);
        lbltext.setBounds(0, 0, 60, 20);
        lbltext.setText("Text");
        this.textText = new ValidateText(this.textComp, 2048, this.diagram, this.fp, this, diagramEditor, "text:", null, null);
        this.textText.setBounds(70, 0, 300, 20);
        this.textText.setString(true);
        this.textText.setText("");
        CLabel lblSizeTxt = new CLabel(this.textComp, 0);
        lblSizeTxt.setBounds(0, 30, 60, 20);
        lblSizeTxt.setText("Size");
        this.textSizeText = new ValidateText(this.textComp, 2048, this.diagram, this.fp, this, diagramEditor, "size:", null, null);
        this.textSizeText.setBounds(70, 30, 300, 20);
        this.textSizeText.setText("1.0");
        Composite cct = new Composite(this.textComp, 0);
        this.textColorText = new ValidateText(cct, 0, this.diagram, this.fp, this, diagramEditor, "color:", null, null);
        this.colorLabelText = new Label(cct, 0);
        Button button3 = new Button(cct, 8);
        Composite cColor3 = new Composite(cct, 0);
        cColor3.setBounds(110, 0, 400, 18);
        this.btnCstColText = new Button(cColor3, 16);
        this.btnExpressionText = new Button(cColor3, 16);
        this.buildColorComposite(cct, this.textColorText, this.colorLabelText, button3, this.btnCstColText, this.btnExpressionText, "color");
        cct.setLocation(0, 60);
        this.agentsComp = new Composite(this.shapeComp, 0);
        this.agentsComp.setVisible(false);
        this.agentsComp.setEnabled(false);
        this.agentsComp.setBounds(20, 40, 680, 180);
        CLabel lblAgents = new CLabel(this.agentsComp, 0);
        lblAgents.setBounds(0, 0, 60, 20);
        lblAgents.setText("agents");
        this.textAgents = new ValidateText(this.agentsComp, 2048, this.diagram, this.fp, this, diagramEditor, "value:", null, null);
        this.textAgents.setBounds(70, 0, 300, 20);
        this.textAgents.setText("[]");
        CLabel lblAspectA = new CLabel(this.agentsComp, 0);
        lblAspectA.setBounds(0, 30, 60, 20);
        lblAspectA.setText("Aspect");
        this.comboAspectsAgents = new CCombo(this.agentsComp, 2048);
        this.comboAspectsAgents.setEditable(false);
        this.comboAspectsAgents.setItems(this.aspects);
        this.comboAspectsAgents.setBounds(70, 30, 300, 20);
        if (this.aspects.length > 0) {
            this.comboAspectsAgents.setText(this.aspects[0]);
        }
        this.comboAspectsAgents.addModifyListener(event -> {
            if (this.textColorText.isSaveData()) {
                this.save("");
            }
            ModelGenerator.modelValidation(this.fp, this.diagram);
            diagramEditor.updateEObjectErrors();
        });
        this.chartComp = new Composite(this.shapeComp, 0);
        this.chartComp.setVisible(false);
        this.chartComp.setEnabled(false);
        this.chartComp.setBounds(20, 40, 680, 180);
        Composite ccc = new Composite(this.chartComp, 0);
        this.textColorChart = new ValidateText(ccc, 0, this.diagram, this.fp, this, diagramEditor, "background:", null, null);
        this.btnCstColChart = new Button(ccc, 2048);
        this.colorLabelChart = new Label(ccc, 0);
        Button button4 = new Button(ccc, 8);
        Composite cColor4 = new Composite(ccc, 0);
        cColor4.setBounds(110, 0, 400, 18);
        this.btnCstColChart = new Button(cColor4, 16);
        this.btnExpressionChart = new Button(cColor4, 16);
        this.buildColorComposite(ccc, this.textColorChart, this.colorLabelChart, button4, this.btnCstColChart, this.btnExpressionChart, "background color");
        ccc.setLocation(0, 0);
        CLabel lbltypeChart = new CLabel(this.chartComp, 0);
        lbltypeChart.setBounds(0, 30, 80, 20);
        lbltypeChart.setText("Chart type");
        this.comboTypeChart = new CCombo(this.chartComp, 2048);
        this.comboTypeChart.setItems(this.types_chart);
        this.comboTypeChart.setBounds(90, 30, 200, 20);
        if (this.types_chart.length > 0) {
            this.comboTypeChart.setText(this.types_chart[0]);
        }
        Canvas canvasCL = this.canvasChartLayer(this.chartComp);
        canvasCL.setLocation(0, 70);
    }

    public Canvas canvasChartLayer(Composite container) {
        Canvas canvasChartLayer = new Canvas(container, 0);
        canvasChartLayer.setSize(720, 120);
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        this.table_chart_layers = this.createTableEditor((Composite)canvasChartLayer);
        this.table_chart_layers.setBounds(10, 0, 660, 80);
        this.table_chart_layers.setHeaderVisible(true);
        this.table_chart_layers.setLinesVisible(true);
        this.table_chart_layers.setLinesVisible(true);
        Button btnAddChartLayer = new Button((Composite)canvasChartLayer, 0);
        btnAddChartLayer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = new TableItem(EditLayerFrame.this.table_chart_layers, 0);
                ti.setText(new String[]{"data_name", EditLayerFrame.this.styles_layer[0], "", ""});
                EditLayerFrame.this.save("");
            }
        });
        btnAddChartLayer.setBounds(62, 90, 94, 20);
        btnAddChartLayer.setText("Add data");
        Button btnDeleteChartLayer = new Button((Composite)canvasChartLayer, 0);
        btnDeleteChartLayer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = EditLayerFrame.this.table_chart_layers.getSelectionIndices();
                EditLayerFrame.this.table_chart_layers.remove(indices);
                EditLayerFrame.this.table_chart_layers.redraw();
                EditLayerFrame.this.save("");
                ModelGenerator.modelValidation(EditLayerFrame.this.fp, EditLayerFrame.this.diagram);
                diagramEditor.updateEObjectErrors();
                EditLayerFrame.this.frame.updateLayer();
            }
        });
        btnDeleteChartLayer.setBounds(163, 90, 112, 20);
        btnDeleteChartLayer.setText("Delete data");
        return canvasChartLayer;
    }

    private Table createTableEditor(Composite container) {
        final Table tableChartLayer = new Table(container, 98308);
        tableChartLayer.setHeaderVisible(true);
        tableChartLayer.setLinesVisible(true);
        TableColumn tblclmnName = new TableColumn(tableChartLayer, 0);
        tblclmnName.setWidth(230);
        tblclmnName.setText("Name");
        TableColumn tblclmnType = new TableColumn(tableChartLayer, 0);
        tblclmnType.setWidth(100);
        tblclmnType.setText("Style");
        TableColumn tblclmnColor = new TableColumn(tableChartLayer, 0);
        tblclmnColor.setWidth(100);
        tblclmnColor.setText("Color");
        TableColumn tblclmnValue = new TableColumn(tableChartLayer, 0);
        tblclmnValue.setWidth(230);
        tblclmnValue.setText("Value");
        final TableEditor editor = new TableEditor(tableChartLayer);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        tableChartLayer.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt;
                TableItem item;
                Control old = editor.getEditor();
                if (old != null) {
                    old.dispose();
                }
                if ((item = tableChartLayer.getItem(pt = new Point(event.x, event.y))) != null) {
                    int column = -1;
                    int i = 0;
                    int n = tableChartLayer.getColumnCount();
                    while (i < n) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            column = i;
                            break;
                        }
                        ++i;
                    }
                    if (column == 1) {
                        final CCombo combo = new CCombo((Composite)tableChartLayer, 8);
                        combo.setItems(EditLayerFrame.this.styles_layer);
                        combo.select(combo.indexOf(item.getText(column)));
                        combo.setFocus();
                        editor.setEditor((Control)combo, item, column);
                        final int col = column;
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                item.setText(col, combo.getText());
                                combo.dispose();
                            }
                        });
                    } else {
                        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(EditLayerFrame.this.fp);
                        String name = "legend:";
                        switch (column) {
                            case 2: {
                                name = "color:";
                                break;
                            }
                            case 3: {
                                name = "";
                            }
                        }
                        ValidateText text = new ValidateText((Composite)tableChartLayer, 0, EditLayerFrame.this.diagram, EditLayerFrame.this.fp, EditLayerFrame.this.cFrame, diagramEditor, name, null, null);
                        item.setBackground(column, text.getBackground());
                        text.setForeground(item.getForeground());
                        if (column == 0) {
                            text.setString(true);
                        }
                        text.setText(item.getText(column));
                        text.setForeground(item.getForeground());
                        text.selectAll();
                        text.setFocus();
                        editor.minimumWidth = text.getBounds().width;
                        editor.setEditor((Control)text, item, column);
                        int col = column;
                        text.addModifyListener(event1 -> {
                            item.setText(col, text.getText());
                            EditLayerFrame.this.save("");
                            text.applyModification();
                            item.setBackground(col, text.getBackground());
                            int i = 2;
                            while (i < tableChartLayer.getColumnCount()) {
                                if (i != col) {
                                    String name1 = "legend:";
                                    switch (col) {
                                        case 2: {
                                            name1 = "color:";
                                            break;
                                        }
                                        case 3: {
                                            name1 = "";
                                        }
                                    }
                                    String error = diagramEditor.containErrors(text.getLoc(), name1, null);
                                    String textI = item.getText(i);
                                    if (error != null && !error.isEmpty()) {
                                        item.setBackground(i, new Color((Device)text.getDisplay(), 255, 100, 100));
                                    } else if (!(textI.contains(";") || textI.contains("{") || textI.contains("}"))) {
                                        item.setBackground(i, new Color((Device)text.getDisplay(), 100, 255, 100));
                                    }
                                }
                                ++i;
                            }
                        });
                    }
                }
            }
        });
        return tableChartLayer;
    }

    void initTable() {
        if (((ELayer)this.eobject).getChartlayers() == null) {
            return;
        }
        for (EChartLayer var : ((ELayer)this.eobject).getChartlayers()) {
            TableItem ti = new TableItem(this.table_chart_layers, 0);
            ti.setText(new String[]{var.getName(), var.getStyle(), var.getColor(), var.getValue()});
        }
    }

    @Override
    protected Point getInitialSize() {
        return new Point(743, 510);
    }

    @Override
    protected void handleShellCloseEvent() {
        this.clean_close();
        if (this.comboType != null) {
            this.comboType.dispose();
        }
        this.comboType = null;
        this.close();
    }
}

