/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.ExampleUtil;
import gama.ui.diagram.features.edit.EditSpeciesFeature;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.metamodel.EGrid;
import gama.ui.diagram.metamodel.EReflexLink;
import gama.ui.diagram.metamodel.ESpecies;
import gama.ui.diagram.metamodel.EVariable;
import gama.ui.diagram.metamodel.EWorldAgent;
import gama.ui.diagram.metamodel.GamaFactory;
import gama.ui.diagram.swt.editFrame.EditFrame;
import gama.ui.diagram.swt.editFrame.ValidateText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EditSpeciesFrame
extends EditFrame {
    int cpt = 1;
    private Table table_vars;
    private final List<String> types = new ArrayList<String>();
    org.eclipse.swt.widgets.List reflexViewer;
    org.eclipse.swt.widgets.List skillsViewer;
    List<String> reflexStrs;
    List<String> skillsStrs;
    Font titleFont;
    private final int CONST_WIDTH = 763;
    final EditFrame frame = this;

    public EditSpeciesFrame(Diagram diagram, IFeatureProvider fp, EditSpeciesFeature esf, ESpecies species, List<ESpecies> speciesList) {
        super(diagram, fp, esf, species, species instanceof EWorldAgent ? "World definition" : (species instanceof EGrid ? "Grid definition" : "Species definition"));
        this.skillsStrs = new ArrayList<String>();
        this.skillsStrs.addAll(GamaSkillRegistry.INSTANCE.getAllSkillNames());
        this.skillsStrs.remove("grid");
        Collections.sort(this.skillsStrs);
        this.comboValues = new Hashtable();
        ArrayList<String> values = new ArrayList<String>(GamaSkillRegistry.INSTANCE.getArchitectureNames());
        values.remove("reflex");
        Collections.sort(values);
        values.add(0, "reflex");
        this.comboValues.put("control", values);
        this.reflexStrs = new ArrayList<String>();
        ArrayList<String> newReflex = new ArrayList<String>();
        for (EReflexLink link : species.getReflexLinks()) {
            if (link.getTarget() == null) continue;
            newReflex.add(link.getTarget().getName());
        }
        if (species.getReflexList() == null || species.getReflexList().isEmpty()) {
            this.reflexStrs.addAll(newReflex);
        } else {
            for (String ref : species.getReflexList()) {
                if (!newReflex.contains(ref)) continue;
                this.reflexStrs.add(ref);
            }
            for (String ref : newReflex) {
                if (this.reflexStrs.contains(ref)) continue;
                this.reflexStrs.add(ref);
            }
        }
        this.defineTypes(speciesList);
    }

    public void defineTypes(List<ESpecies> speciesList) {
        this.types.add("int");
        this.types.add("float");
        this.types.add("string");
        this.types.add("bool");
        this.types.add("rgb");
        this.types.add("point");
        this.types.add("geometry");
        for (String ty : GAML.VARTYPE2KEYWORDS.values()) {
            if (this.types.contains(ty) || ty.toString().endsWith("_file")) continue;
            this.types.add(ty);
        }
        for (ESpecies sp : speciesList) {
            this.types.add(sp.getName());
        }
        this.types.remove("unknown");
        this.types.remove("world");
        ArrayList<String> tt = new ArrayList<String>(this.types);
        for (String ty : tt) {
            this.types.add("list<" + ty + ">");
        }
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2560);
        Composite container = new Composite((Composite)sc, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.titleFont = new Font((Device)this.getShell().getDisplay(), "Arial", 10, 1);
        if (!(this.eobject instanceof EWorldAgent)) {
            this.groupName(container);
        }
        this.groupSkills(container);
        if (this.eobject instanceof EWorldAgent) {
            this.groupFacets(container, "global", 2);
        } else if (this.eobject instanceof EGrid) {
            this.groupFacets(container, "grid", 2);
        } else {
            this.groupFacets(container, "species", 2);
        }
        this.groupVariables(container);
        this.groupReflex(container);
        this.groupGamlCode(container, "Init");
        sc.setContent((Control)container);
        if (this.eobject instanceof EGrid) {
            sc.setMinSize(container.computeSize(730, 1080));
        } else {
            sc.setMinSize(container.computeSize(730, 800));
        }
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        return container;
    }

    private EVariable getEVariable(String name) {
        if (((ESpecies)this.eobject).getVariables() == null || ((ESpecies)this.eobject).getVariables().isEmpty()) {
            return null;
        }
        for (EVariable var : ((ESpecies)this.eobject).getVariables()) {
            if (var == null || !name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    private void modifyVariables() {
        ESpecies species = (ESpecies)this.eobject;
        ArrayList<EVariable> vars = new ArrayList<EVariable>();
        vars.addAll((Collection<EVariable>)species.getVariables());
        species.getVariables().clear();
        for (EVariable var : vars) {
            GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
            diagramEditor.removeEOject(var);
            EcoreUtil.delete((EObject)var, (boolean)true);
        }
        TableItem[] tableItemArray = this.table_vars.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            EVariable var = GamaFactory.eINSTANCE.createEVariable();
            var.setName(item.getText(0));
            var.setType(item.getText(1));
            var.setInit(item.getText(2));
            var.setUpdate(item.getText(3));
            var.setFunction(item.getText(4));
            var.setMin(item.getText(5));
            var.setMax(item.getText(6));
            species.getVariables().add((Object)var);
            GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
            diagramEditor.addEOject(var);
            ++n2;
        }
    }

    private void modifyReflexOrder() {
        ((ESpecies)this.eobject).getReflexList().clear();
        ((ESpecies)this.eobject).getReflexList().addAll(this.reflexStrs);
    }

    private Table createTableEditor(Composite container) {
        final Table tableVars = new Table(container, 65540);
        tableVars.setHeaderVisible(true);
        tableVars.setLinesVisible(true);
        tableVars.addListener(41, event -> {
            int n = event.height = 20;
        });
        TableColumn tblclmnName = new TableColumn(tableVars, 0);
        tblclmnName.setWidth(100);
        tblclmnName.setText("Name");
        TableColumn tblclmnType = new TableColumn(tableVars, 0);
        tblclmnType.setWidth(100);
        tblclmnType.setText("Type");
        TableColumn tblclmnInitValue = new TableColumn(tableVars, 0);
        tblclmnInitValue.setWidth(100);
        tblclmnInitValue.setText("init value");
        TableColumn tblclmnUpdate = new TableColumn(tableVars, 0);
        tblclmnUpdate.setWidth(100);
        tblclmnUpdate.setText("update");
        TableColumn tblclmnFunction = new TableColumn(tableVars, 0);
        tblclmnFunction.setWidth(100);
        tblclmnFunction.setText("function");
        TableColumn tblclmnMin = new TableColumn(tableVars, 0);
        tblclmnMin.setWidth(100);
        tblclmnMin.setText("min");
        TableColumn tblclmnMax = new TableColumn(tableVars, 0);
        tblclmnMax.setWidth(100);
        tblclmnMax.setText("max");
        final TableEditor editor = new TableEditor(tableVars);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        tableVars.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt;
                TableItem item;
                Control old = editor.getEditor();
                if (old != null) {
                    old.dispose();
                }
                if ((item = tableVars.getItem(pt = new Point(event.x, event.y))) != null) {
                    int column = -1;
                    int i = 0;
                    int n = tableVars.getColumnCount();
                    while (i < n) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            column = i;
                            break;
                        }
                        ++i;
                    }
                    if (column == 1) {
                        final CCombo combo = new CCombo((Composite)tableVars, 8);
                        EditSpeciesFrame.this.combos.add(combo);
                        for (String type : EditSpeciesFrame.this.types) {
                            combo.add(type);
                        }
                        combo.select(combo.indexOf(item.getText(column)));
                        combo.setFocus();
                        editor.setEditor((Control)combo, item, column);
                        final int col = column;
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                item.setText(col, combo.getText());
                                EditSpeciesFrame.this.save("variables");
                            }
                        });
                    } else {
                        GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(EditSpeciesFrame.this.fp);
                        String name = "name";
                        switch (column) {
                            case 2: {
                                name = "<-";
                                break;
                            }
                            case 3: {
                                name = "update:";
                                break;
                            }
                            case 4: {
                                name = "->";
                                break;
                            }
                            case 5: {
                                name = "min:";
                                break;
                            }
                            case 6: {
                                name = "max:";
                            }
                        }
                        ValidateText text = new ValidateText((Composite)tableVars, 2048, EditSpeciesFrame.this.diagram, EditSpeciesFrame.this.fp, EditSpeciesFrame.this.frame, diagramEditor, name, null, item.getText(0));
                        item.setBackground(column, text.getBackground());
                        text.setText(item.getText(column));
                        text.setForeground(item.getForeground());
                        text.selectAll();
                        text.setFocus();
                        editor.minimumWidth = text.getBounds().width;
                        editor.setEditor((Control)text, item, column);
                        int col = column;
                        text.addModifyListener(event1 -> {
                            item.setText(col, text.getText());
                            EditSpeciesFrame.this.save("variables");
                            text.applyModification();
                            item.setBackground(col, text.getBackground());
                            int i = 2;
                            while (i < EditSpeciesFrame.this.table_vars.getColumnCount()) {
                                if (i != col) {
                                    String name1 = "name";
                                    switch (i) {
                                        case 2: {
                                            name1 = "<-";
                                            break;
                                        }
                                        case 3: {
                                            name1 = "update:";
                                            break;
                                        }
                                        case 4: {
                                            name1 = "->";
                                            break;
                                        }
                                        case 5: {
                                            name1 = "min:";
                                            break;
                                        }
                                        case 6: {
                                            name1 = "max:";
                                        }
                                    }
                                    String error = diagramEditor.containErrors(text.getLoc(), name1, null);
                                    String textI = item.getText(i);
                                    if (error != null && !error.isEmpty()) {
                                        item.setBackground(i, new Color((Device)text.getDisplay(), 255, 100, 100));
                                    } else if (!(textI.contains(";") || textI.contains("{") || textI.contains("}"))) {
                                        item.setBackground(i, new Color((Device)text.getDisplay(), 100, 255, 100));
                                    }
                                }
                                ++i;
                            }
                        });
                    }
                } else {
                    tableVars.deselectAll();
                }
            }
        });
        return tableVars;
    }

    void initTable() {
        for (EVariable var : ((ESpecies)this.eobject).getVariables()) {
            TableItem ti = new TableItem(this.table_vars, 0);
            ti.setText(new String[]{var.getName(), var.getType(), var.getInit(), var.getUpdate(), var.getFunction(), var.getMin(), var.getMax()});
            ++this.cpt;
        }
    }

    public void groupVariables(Composite container) {
        Group group = new Group(container, 0);
        this.table_vars = this.createTableEditor((Composite)group);
        this.table_vars.setBounds(10, 30, 740, 120);
        this.table_vars.setHeaderVisible(true);
        this.table_vars.setLinesVisible(true);
        this.initTable();
        CLabel lblVariables = new CLabel((Composite)group, 0);
        lblVariables.setBounds(10, 5, 100, 20);
        lblVariables.setText("Variables");
        lblVariables.setFont(this.titleFont);
        Button btnAddVariable = new Button((Composite)group, 0);
        btnAddVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = new TableItem(EditSpeciesFrame.this.table_vars, 0);
                String name = "var_name" + EditSpeciesFrame.this.cpt;
                ti.setText(new String[]{name, "int", "", "", "", "", ""});
                ti.setBackground(new Color((Device)EditSpeciesFrame.this.frame.getShell().getDisplay(), 100, 255, 100));
                ++EditSpeciesFrame.this.cpt;
                EditSpeciesFrame.this.save("variables");
            }
        });
        btnAddVariable.setBounds(62, 162, 94, 28);
        btnAddVariable.setText("Add variable");
        Button btnDeleteVariable = new Button((Composite)group, 0);
        btnDeleteVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = EditSpeciesFrame.this.table_vars.getSelectionIndices();
                EditSpeciesFrame.this.table_vars.remove(indices);
                EditSpeciesFrame.this.table_vars.redraw();
                EditSpeciesFrame.this.save("variables");
            }
        });
        btnDeleteVariable.setBounds(163, 162, 112, 28);
        btnDeleteVariable.setText("Delete variable");
    }

    public void groupSkills(Composite container) {
        final GamaDiagramEditor diagramEditor = (GamaDiagramEditor)ExampleUtil.getDiagramEditor(this.fp);
        Group group = new Group(container, 0);
        CLabel lblSkills = new CLabel((Composite)group, 0);
        lblSkills.setBounds(5, 5, 100, 20);
        lblSkills.setText("Skills");
        lblSkills.setFont(this.titleFont);
        CLabel lblAvSkills = new CLabel((Composite)group, 0);
        lblAvSkills.setBounds(5, 23, 150, 20);
        lblAvSkills.setText("Available Skills");
        CLabel lblSelectSkills = new CLabel((Composite)group, 0);
        lblSelectSkills.setBounds(405, 23, 150, 20);
        lblSelectSkills.setText("Selected Skills");
        final org.eclipse.swt.widgets.List listAvSkills = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        listAvSkills.setBounds(5, 45, 330, 55);
        for (String ski : this.skillsStrs) {
            listAvSkills.add(ski);
        }
        this.skillsViewer = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        this.skillsViewer.setBounds(405, 45, 330, 55);
        Button btnRigth = new Button((Composite)group, 131076);
        btnRigth.setBounds(345, 45, 50, 25);
        btnRigth.setSelection(true);
        btnRigth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (listAvSkills.getSelectionCount() > 0) {
                    String[] els;
                    String[] stringArray = els = listAvSkills.getSelection();
                    int n = els.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String el = stringArray[n2];
                        EditSpeciesFrame.this.skillsViewer.add(el);
                        ++n2;
                    }
                    listAvSkills.remove(listAvSkills.getSelectionIndices());
                    listAvSkills.redraw();
                    EditSpeciesFrame.this.skillsViewer.redraw();
                    EditSpeciesFrame.this.save("skills");
                    ModelGenerator.modelValidation(EditSpeciesFrame.this.fp, EditSpeciesFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                }
            }
        });
        Button btnLeft = new Button((Composite)group, 16388);
        btnLeft.setBounds(345, 75, 50, 25);
        btnLeft.setSelection(true);
        btnLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditSpeciesFrame.this.skillsViewer.getSelectionCount() > 0) {
                    String[] els;
                    String[] stringArray = els = EditSpeciesFrame.this.skillsViewer.getSelection();
                    int n = els.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String el = stringArray[n2];
                        listAvSkills.add(el);
                        ++n2;
                    }
                    EditSpeciesFrame.this.skillsViewer.remove(EditSpeciesFrame.this.skillsViewer.getSelectionIndices());
                    listAvSkills.redraw();
                    EditSpeciesFrame.this.skillsViewer.redraw();
                    EditSpeciesFrame.this.save("skills");
                    ModelGenerator.modelValidation(EditSpeciesFrame.this.fp, EditSpeciesFrame.this.diagram);
                    diagramEditor.updateEObjectErrors();
                }
            }
        });
        if (((ESpecies)this.eobject).getSkills() != null) {
            for (String sk : ((ESpecies)this.eobject).getSkills()) {
                this.skillsStrs.remove(sk);
                this.skillsViewer.add(sk);
                listAvSkills.remove(sk);
            }
            this.skillsViewer.redraw();
            listAvSkills.redraw();
        }
    }

    public void groupReflex(Composite container) {
        Group group = new Group(container, 0);
        this.reflexViewer = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        for (String ref : this.reflexStrs) {
            this.reflexViewer.add(ref);
        }
        this.reflexViewer.setBounds(5, 30, 740, 45);
        CLabel lblReflexOrder = new CLabel((Composite)group, 0);
        lblReflexOrder.setBounds(5, 5, 200, 20);
        lblReflexOrder.setText("Reflex order");
        lblReflexOrder.setFont(this.titleFont);
        Button btnUp = new Button((Composite)group, 132);
        btnUp.setBounds(80, 85, 105, 20);
        btnUp.setText("Up");
        btnUp.setSelection(true);
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditSpeciesFrame.this.reflexViewer.getSelectionCount() == 1) {
                    String el = EditSpeciesFrame.this.reflexViewer.getSelection()[0];
                    int index = EditSpeciesFrame.this.reflexViewer.getSelectionIndex();
                    if (index > 0) {
                        EditSpeciesFrame.this.reflexStrs.remove(el);
                        EditSpeciesFrame.this.reflexStrs.add(index - 1, el);
                        EditSpeciesFrame.this.reflexViewer.removeAll();
                        for (String ref : EditSpeciesFrame.this.reflexStrs) {
                            EditSpeciesFrame.this.reflexViewer.add(ref);
                        }
                    }
                }
            }
        });
        Button btnDown = new Button((Composite)group, 1028);
        btnDown.setBounds(200, 85, 105, 20);
        btnDown.setText("Down");
        btnDown.setSelection(true);
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditSpeciesFrame.this.reflexViewer.getSelectionCount() == 1) {
                    String el = EditSpeciesFrame.this.reflexViewer.getSelection()[0];
                    int index = EditSpeciesFrame.this.reflexViewer.getSelectionIndex();
                    if (index < EditSpeciesFrame.this.reflexViewer.getItemCount() - 1) {
                        EditSpeciesFrame.this.reflexStrs.remove(el);
                        EditSpeciesFrame.this.reflexStrs.add(index + 1, el);
                        EditSpeciesFrame.this.reflexViewer.removeAll();
                        for (String ref : EditSpeciesFrame.this.reflexStrs) {
                            EditSpeciesFrame.this.reflexViewer.add(ref);
                        }
                    }
                }
            }
        });
    }

    @Override
    protected void save(final String name) {
        final ESpecies species = (ESpecies)this.eobject;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.eobject);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                public void doExecute() {
                    if (name == null || "".equals(name)) {
                        if (EditSpeciesFrame.this.textName != null) {
                            EditSpeciesFrame.this.eobject.setName(EditSpeciesFrame.this.textName.getText());
                        }
                        ((ESpecies)EditSpeciesFrame.this.eobject).setInit(EditSpeciesFrame.this.modelXText.getEditablePart());
                        EditSpeciesFrame.this.modifyReflexOrder();
                        EditSpeciesFrame.this.modifyVariables();
                        species.getSkills().clear();
                        species.getSkills().addAll(Arrays.asList(EditSpeciesFrame.this.skillsViewer.getItems()));
                        EditSpeciesFrame.this.saveFacets();
                        EditSpeciesFrame.this.updateEditor();
                    } else if ("name".equals(name)) {
                        EditSpeciesFrame.this.eobject.setName(EditSpeciesFrame.this.textName.getText());
                    } else if ("init".equals(name)) {
                        ((ESpecies)EditSpeciesFrame.this.eobject).setInit(EditSpeciesFrame.this.modelXText.getEditablePart());
                    } else if ("reflex order".equals(name)) {
                        EditSpeciesFrame.this.modifyReflexOrder();
                    } else if ("variables".equals(name)) {
                        EditSpeciesFrame.this.modifyVariables();
                        EditSpeciesFrame.this.updateEditor();
                    } else if ("skills".equals(name)) {
                        species.getSkills().clear();
                        species.getSkills().addAll(Arrays.asList(EditSpeciesFrame.this.skillsViewer.getItems()));
                        EditSpeciesFrame.this.updateEditor();
                    }
                }
            });
        }
        this.ef.hasDoneChanges = true;
        ModelGenerator.modelValidation(this.fp, this.diagram);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(763, 700);
    }

    @Override
    public void create() {
        this.setShellStyle(2160);
        super.create();
    }

    @Override
    protected void handleShellCloseEvent() {
        this.clean_close();
        this.close();
    }
}

