/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.editFrame;

import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.features.modelgeneration.ModelGenerator;
import gama.ui.diagram.swt.editFrame.EditFrame;
import gama.ui.diagram.swt.editFrame.UndoRedoStyledText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolTip;

public class ValidateText
extends StyledText {
    Color colValid;
    Color colNotValid;
    boolean isValid;
    String error;
    final Diagram diagram;
    final IFeatureProvider fp;
    final EditFrame frame;
    final String nameLoc;
    final List<String> loc;
    final GamaDiagramEditor editor;
    final ToolTip tip;
    List<String> uselessName;
    static final int TOOLTIP_HIDE_DELAY = 200;
    static final int TOOLTIP_SHOW_DELAY = 500;
    final List<ValidateText> linkedVts = new ArrayList<ValidateText>();
    boolean allErrors;
    boolean isString = false;
    boolean saveData = false;
    boolean nameFeature = true;
    boolean simpleValidation = false;
    String addToLoc;

    public ValidateText(Composite parent, int style, Diagram diagram, IFeatureProvider fp, EditFrame frame, GamaDiagramEditor editor, String name, List<String> uselessName, String addToLoc) {
        super(parent, style);
        this.diagram = diagram;
        new UndoRedoStyledText(this);
        this.tip = new ToolTip(this.getShell(), 4096);
        this.tip.setText("ERROR");
        this.tip.setAutoHide(false);
        this.uselessName = uselessName;
        this.allErrors = false;
        this.fp = fp;
        this.nameLoc = name;
        this.addToLoc = addToLoc;
        this.loc = new ArrayList<String>();
        editor.buildLocation(frame.eobject, this.loc);
        if (addToLoc != null && !addToLoc.isEmpty()) {
            this.loc.add(addToLoc);
        }
        this.colValid = new Color((Device)this.getDisplay(), 150, 255, 150);
        this.colNotValid = new Color((Device)this.getDisplay(), 255, 150, 150);
        this.error = editor.containErrors(this.loc, name, uselessName);
        this.tip.setMessage(this.error);
        this.isValid = "".equals(this.error);
        this.setBackground(this.isValid ? this.colValid : this.colNotValid);
        this.frame = frame;
        this.editor = editor;
        this.addModifyListener(event -> this.applyModification());
        this.addListener(32, event -> this.tip.getDisplay().timerExec(500, () -> {
            if (!this.isValid) {
                this.tip.setVisible(true);
            } else {
                this.tip.setVisible(false);
            }
        }));
        this.addListener(7, event -> this.tip.getDisplay().timerExec(200, () -> this.tip.setVisible(false)));
    }

    public void updateColor() {
        if ("name".equals(this.nameLoc)) {
            this.isValid = !this.getText().isEmpty() && !this.getText().contains(" ") && !this.getText().contains(";") && !this.getText().contains("{") && !this.getText().contains("}") && !this.getText().contains("\t");
        } else {
            boolean bl = this.isValid = !ModelGenerator.hasSyntaxError(this.fp, this.getText(), true, this.isString);
        }
        if (this.isValid) {
            Map<String, String> locs = this.editor.getSyntaxErrorsLoc().get(this.loc);
            if (locs != null) {
                locs.remove(this.nameLoc);
            }
            if (this.nameFeature && "name".equals(this.nameLoc)) {
                this.addToLoc = this.getText();
                ArrayList<String> oldLoc = new ArrayList<String>();
                oldLoc.addAll(this.loc);
                this.loc.clear();
                this.editor.buildLocation(this.frame.eobject, this.loc);
                if (this.addToLoc != null && !this.addToLoc.isEmpty() && !this.loc.get(this.loc.size() - 1).equals(this.addToLoc)) {
                    this.loc.add(this.addToLoc);
                }
                for (ValidateText vst : this.linkedVts) {
                    if (vst == null) continue;
                    vst.updateLoc(this.loc);
                }
                this.editor.updateErrors(oldLoc, this.loc);
                this.editor.getIdsEObjects().clear();
                this.editor.initIdsEObjects();
            }
            this.error = this.allErrors ? this.editor.containErrors(this.loc, "", this.uselessName) : this.editor.containErrors(this.loc, this.nameLoc, this.uselessName);
        } else {
            this.error = "Syntax errors detected ";
            ArrayList<String> wStr = new ArrayList<String>();
            wStr.add("world");
            this.editor.getSyntaxErrorsLoc().remove(wStr);
            IMap locs = this.editor.getSyntaxErrorsLoc().get(this.loc);
            if (locs == null) {
                locs = GamaMapFactory.create();
            }
            locs.put(this.nameLoc, "Syntax errors detected ");
            this.editor.getSyntaxErrorsLoc().put(this.loc, (Map<String, String>)locs);
        }
        if (this.error != null) {
            this.tip.setMessage(this.error);
            this.isValid = "".equals(this.error);
        }
        this.setBackground(this.isValid ? this.colValid : this.colNotValid);
        if (this.isValid) {
            this.tip.setVisible(false);
        }
        this.editor.updateEObjectErrors();
    }

    public void applyModification() {
        if (this.saveData) {
            this.frame.save(this.nameLoc);
        }
        this.frame.getShell().forceFocus();
        if ("name".equals(this.nameLoc)) {
            this.isValid = this.simpleValidation ? !this.getText().isEmpty() : !this.getText().isEmpty() && !this.getText().contains(" ") && !this.getText().contains(";") && !this.getText().contains("{") && !this.getText().contains("}") && !this.getText().contains("\t");
        } else {
            boolean bl = this.isValid = !ModelGenerator.hasSyntaxError(this.fp, this.getText(), true, this.isString);
        }
        if (this.isValid) {
            ModelGenerator.modelValidation(this.fp, this.diagram);
            Map<String, String> locs = this.editor.getSyntaxErrorsLoc().get(this.loc);
            if (locs != null) {
                locs.remove(this.nameLoc);
            }
            if (this.nameFeature && "name".equals(this.nameLoc)) {
                this.addToLoc = this.getText();
                ArrayList<String> oldLoc = new ArrayList<String>();
                oldLoc.addAll(this.loc);
                this.loc.clear();
                this.editor.buildLocation(this.frame.eobject, this.loc);
                if (this.addToLoc != null && !this.addToLoc.isEmpty() && !this.loc.get(this.loc.size() - 1).equals(this.addToLoc)) {
                    this.loc.add(this.addToLoc);
                }
                for (ValidateText vst : this.linkedVts) {
                    if (vst == null) continue;
                    vst.updateLoc(this.loc);
                }
                this.editor.updateErrors(oldLoc, this.loc);
                this.editor.getIdsEObjects().clear();
                this.editor.initIdsEObjects();
            }
            this.error = this.allErrors ? this.editor.containErrors(this.loc, "", this.uselessName) : this.editor.containErrors(this.loc, this.nameLoc, this.uselessName);
        } else {
            this.error = "Syntax errors detected ";
            if (this.editor.isWasOK()) {
                ModelGenerator.modelValidation(this.fp, this.diagram);
            }
            ArrayList<String> wStr = new ArrayList<String>();
            wStr.add("world");
            this.editor.getSyntaxErrorsLoc().remove(wStr);
            IMap locs = this.editor.getSyntaxErrorsLoc().get(this.loc);
            if (locs == null) {
                locs = GamaMapFactory.create();
            }
            locs.put(this.nameLoc, "Syntax errors detected ");
            this.editor.getSyntaxErrorsLoc().put(this.loc, (Map<String, String>)locs);
        }
        if (this.error != null) {
            this.tip.setMessage(this.error);
            this.isValid = "".equals(this.error);
        }
        this.setBackground(this.isValid ? this.colValid : this.colNotValid);
        if (this.isValid) {
            this.tip.setVisible(false);
        }
        this.setFocus();
        this.editor.updateEObjectErrors();
        this.frame.updateError();
    }

    protected void checkSubclass() {
    }

    public String getNameLoc() {
        return this.nameLoc;
    }

    public List<String> getLoc() {
        return this.loc;
    }

    public void updateLoc(List<String> nwLoc) {
        this.loc.clear();
        this.loc.addAll(nwLoc);
    }

    public List<ValidateText> getLinkedVts() {
        return this.linkedVts;
    }

    public boolean isAllErrors() {
        return this.allErrors;
    }

    public void setAllErrors(boolean allErrors) {
        this.allErrors = allErrors;
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public void setSaveData(boolean saveData) {
        this.saveData = saveData;
    }

    public boolean isString() {
        return this.isString;
    }

    public void setString(boolean isString) {
        this.isString = isString;
    }

    public boolean isNameFeature() {
        return this.nameFeature;
    }

    public void setNameFeature(boolean nameFeature) {
        this.nameFeature = nameFeature;
    }

    public boolean isSimpleValidation() {
        return this.simpleValidation;
    }

    public void setSimpleValidation(boolean simpleValidation) {
        this.simpleValidation = simpleValidation;
    }
}

