/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.wizards;

import gama.ui.diagram.FileService;
import gama.ui.diagram.editor.GamaDiagramEditor;
import gama.ui.diagram.editor.GamaFeatureProvider;
import gama.ui.diagram.swt.wizards.NewFileWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NewFileWizard
extends Wizard
implements INewWizard {
    private NewFileWizardPage page;
    private ISelection selection;

    public NewFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewFileWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String typeOfModel = this.page.getTypeOfModel();
        final String fileName = this.page.getFileName();
        final String author = this.page.getAuthor();
        final String title = this.page.getModelName();
        final String desc = this.page.getDescription();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFileWizard.this.doFinish(containerName, typeOfModel, fileName, author, title, desc, monitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String typeOfModel, String fileName, String author, String title, String desc, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        IProject container = resource.getProject();
        IFolder modelFolder = container.getFolder((IPath)new Path("diagrams"));
        if (!modelFolder.exists()) {
            modelFolder.create(true, true, monitor);
        }
        IFile file = container.getFile((IPath)new Path("diagrams/" + fileName));
        this.createDiagramEditor(file, title, monitor);
    }

    private void createDiagramEditor(IFile file, String diagramName, final IProgressMonitor monitor) {
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("gamaDiagram", diagramName, true);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        FileService.createEmfFileForDiagram(uri, diagram);
        final DiagramEditorInput editorInput = new DiagramEditorInput(EcoreUtil.getURI((EObject)diagram), "gama.ui.diagram.editor.GamaDiagramTypeProvider");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage pag = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart ep = pag.openEditor((IEditorInput)editorInput, "gama.ui.diagram.editor");
                    IDiagramTypeProvider dtp = ((GamaDiagramEditor)ep).getDiagramTypeProvider();
                    GamaFeatureProvider gfp = (GamaFeatureProvider)dtp.getFeatureProvider();
                    gfp.setTypeOfModel(NewFileWizard.this.page.getTypeOfModel());
                    gfp.init();
                    ep.doSave(monitor);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

