/*
 * Decompiled with CFR 0.152.
 */
package gama.ui.diagram.swt.wizards;

import gama.ui.navigator.view.contents.WrappedFolder;
import gama.ui.navigator.view.contents.WrappedProject;
import java.net.InetAddress;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewFileWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text authorText;
    private Text descriptionText;
    private Text titleText;
    private Button emptyModelButton;
    private Button skeletonModelButton;
    private String typeOfModel = "empty";
    private final ISelection selection;

    public NewFileWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("Model Diagram");
        this.setDescription("This wizard creates a new model file.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(e -> this.dialogChanged());
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewFileWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Choose a diagram:");
        Composite middleComposite = new Composite(container, 0);
        FillLayout fillLayout = new FillLayout();
        middleComposite.setLayout((Layout)fillLayout);
        this.emptyModelButton = new Button(middleComposite, 16);
        this.emptyModelButton.setText("Empty");
        this.emptyModelButton.setSelection(true);
        this.skeletonModelButton = new Button(middleComposite, 16);
        this.skeletonModelButton.setText("Skeleton");
        this.emptyModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NewFileWizardPage.this.typeOfModel = "empty";
                NewFileWizardPage.this.radioChanged();
            }
        });
        this.skeletonModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NewFileWizardPage.this.typeOfModel = "skeleton";
                NewFileWizardPage.this.radioChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(e -> {
            Text t = (Text)e.getSource();
            String fname = t.getText();
            int i = fname.lastIndexOf(".gadl");
            if (i > 0) {
                this.titleText.setText(fname.substring(0, i).replaceAll("[^\\p{Alnum}]", ""));
            }
            this.dialogChanged();
        });
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("&Author:");
        this.authorText = new Text(container, 2052);
        gd = new GridData(768);
        this.authorText.setLayoutData((Object)gd);
        this.authorText.setText(NewFileWizardPage.getComputerFullName());
        this.authorText.addModifyListener(e -> this.dialogChanged());
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("&Diagram name:");
        this.titleText = new Text(container, 2052);
        gd = new GridData(768);
        this.titleText.setLayoutData((Object)gd);
        this.titleText.setText("new");
        this.titleText.addModifyListener(e -> this.dialogChanged());
        label = new Label(container, 0);
        label.setText("");
        label = new Label(container, 0);
        label.setText("&Model description:");
        this.descriptionText = new Text(container, 2882);
        this.descriptionText.setBounds(0, 0, 250, 100);
        gd = new GridData(4, 4, true, false);
        gd.verticalSpan = 4;
        this.descriptionText.setLayoutData((Object)gd);
        int i = 0;
        while (i < 7) {
            label = new Label(container, 0);
            label.setText("");
            ++i;
        }
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public static String getComputerFullName() {
        String uname = System.getProperty("user.name");
        if (uname == null || uname.isEmpty()) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                uname = new String(addr.getHostName());
            }
            catch (Exception exception) {}
        }
        return uname;
    }

    private void radioChanged() {
        if (this.emptyModelButton.getSelection() || this.skeletonModelButton.getSelection()) {
            this.descriptionText.setText("");
            this.titleText.setText("new");
            this.fileText.setText("new.gadl");
            this.updateStatus(null);
        }
        this.dialogChanged();
    }

    private void initialize() {
        ISelection iSelection;
        if (this.selection != null && !this.selection.isEmpty() && (iSelection = this.selection) instanceof IStructuredSelection) {
            WrappedFolder pro;
            IFolder container;
            IStructuredSelection ssel = (IStructuredSelection)iSelection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof WrappedProject) {
                WrappedProject pro2 = (WrappedProject)obj;
                IProject container2 = (IProject)pro2.getResource();
                if (container2 != null && container2.getFullPath() != null) {
                    IContainer res;
                    String path = container2.getFullPath().toString();
                    if (("".equals(path) || "/".equals(path)) && (res = container2.getParent()) != null && res.getFullPath() != null) {
                        path = res.getFullPath().toString();
                        while ("".equals(path)) {
                            if ((res = res.getParent()) == null || res.getFullPath() == null) break;
                            path = res.getFullPath().toString();
                        }
                    }
                    this.containerText.setText(path);
                }
            } else if (obj instanceof WrappedFolder && (container = (IFolder)(pro = (WrappedFolder)obj).getResource()) != null && container.getFullPath() != null) {
                String path = container.getFullPath().toString();
                IContainer res = container.getParent();
                if (res != null && res.getFullPath() != null) {
                    path = res.getFullPath().toString();
                    while ("".equals(path)) {
                        if ((res = res.getParent()) == null || res.getFullPath() == null) break;
                        path = res.getFullPath().toString();
                    }
                }
                this.containerText.setText(path);
            }
        }
        this.fileText.setText("new.gadl");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select a project as a container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        IContainer container = (IContainer)resource;
        String fileName = this.getFileName();
        String author = this.getAuthor();
        String titleName = this.getModelName();
        IFile modelfile = container.getFile((IPath)new Path("diagrams/" + fileName));
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (resource == null || (resource.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!resource.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        if (!fileName.endsWith(".gadl")) {
            this.updateStatus("File extension must be \".gadl\"");
            return;
        }
        if (author.length() == 0) {
            this.updateStatus("Author name must be specified");
            return;
        }
        if (modelfile.exists()) {
            this.updateStatus("File already exists");
            return;
        }
        if (titleName.length() == 0) {
            this.updateStatus("Diagram name must be specified");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getAuthor() {
        return this.authorText.getText();
    }

    public String getModelName() {
        return this.titleText.getText();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public String getTypeOfModel() {
        return this.typeOfModel;
    }
}

